/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.euicc.EuiccManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=EuiccManager.class, minSdk=28)
public class ShadowEuiccManager {
    private static final Map<Integer, EuiccManager> cardIdsToEuiccManagers = new HashMap<Integer, EuiccManager>();
    private static boolean enabled;
    private static String eid;

    @Resetter
    public static void reset() {
        cardIdsToEuiccManagers.clear();
        enabled = false;
        eid = null;
    }

    @Implementation(minSdk=29)
    protected EuiccManager createForCardId(int cardId) {
        return cardIdsToEuiccManagers.get(cardId);
    }

    public void setEuiccManagerForCardId(int cardId, EuiccManager euiccManager) {
        cardIdsToEuiccManagers.put(cardId, euiccManager);
    }

    @Implementation
    protected boolean isEnabled() {
        return enabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }

    @Implementation
    protected String getEid() {
        return eid;
    }

    public void setEid(String eid) {
        ShadowEuiccManager.eid = eid;
    }
}

