/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.os.Build;
import android.os.Handler;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(value=CameraManager.class)
public class ShadowCameraManager {
    protected static final Set<CameraDeviceImpl> createdCameras = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private static final Map<String, CameraCharacteristics> cameraIdToCharacteristics = new LinkedHashMap<String, CameraCharacteristics>();
    private static final Map<String, Boolean> cameraTorches = new HashMap<String, Boolean>();
    private static final Set<CameraManager.AvailabilityCallback> registeredCallbacks = new HashSet<CameraManager.AvailabilityCallback>();
    private static final Set<Object> torchCallbacks = new HashSet<Object>();
    private static CameraDevice lastDevice;
    private static CameraDevice.StateCallback lastCallback;
    @Nullable
    private static Executor lastCallbackExecutor;
    @Nullable
    private static Handler lastCallbackHandler;
    @RealObject
    private CameraManager realObject;

    @Resetter
    public static void reset() {
        for (CameraDeviceImpl cameraDevice : createdCameras) {
            if (cameraDevice == null) continue;
            cameraDevice.close();
        }
        createdCameras.clear();
        cameraIdToCharacteristics.clear();
        cameraTorches.clear();
        registeredCallbacks.clear();
        torchCallbacks.clear();
        if (lastDevice != null) {
            lastDevice.close();
        }
        lastDevice = null;
        lastCallback = null;
        lastCallbackExecutor = null;
        if (lastCallbackHandler != null) {
            Shadows.shadowOf(lastCallbackHandler.getLooper()).idle();
            lastCallbackHandler.removeCallbacksAndMessages(null);
        }
        lastCallbackHandler = null;
    }

    @Implementation
    @Nonnull
    protected String[] getCameraIdList() throws CameraAccessException {
        Set<String> cameraIds = cameraIdToCharacteristics.keySet();
        return cameraIds.toArray(new String[0]);
    }

    @Implementation
    @Nonnull
    protected CameraCharacteristics getCameraCharacteristics(@Nonnull String cameraId) {
        Objects.requireNonNull(cameraId);
        CameraCharacteristics characteristics = cameraIdToCharacteristics.get(cameraId);
        Preconditions.checkArgument((characteristics != null ? 1 : 0) != 0);
        return characteristics;
    }

    @Implementation(minSdk=23)
    protected void setTorchMode(@Nonnull String cameraId, boolean enabled) {
        Objects.requireNonNull(cameraId);
        Preconditions.checkArgument((boolean)cameraIdToCharacteristics.keySet().contains(cameraId));
        cameraTorches.put(cameraId, enabled);
        for (Object callback : torchCallbacks) {
            ((CameraManager.TorchCallback)callback).onTorchModeChanged(cameraId, enabled);
        }
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid, int oomScoreOffset, boolean overrideToPortrait) {
        return this.openCameraDeviceUserAsync(cameraId, callback, executor, uid, oomScoreOffset);
    }

    @Implementation(minSdk=35, maxSdk=35)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid, int oomScoreOffset, int rotationOverride) {
        return this.openCameraDeviceUserAsync(cameraId, callback, executor, uid, oomScoreOffset);
    }

    @Implementation(methodName="openCameraDeviceUserAsync", minSdk=36)
    protected CameraDevice openCameraDeviceUserAsyncPostV(String cameraId, CameraDevice.StateCallback callback, Executor executor, int unusedClientUid, int unusedOomScoreOffset, boolean unused) {
        return this.openCameraDeviceUserAsync(cameraId, callback, executor, unusedClientUid, unusedOomScoreOffset);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int unusedClientUid, int unusedOomScoreOffset) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Application context = RuntimeEnvironment.getApplication();
        CameraDeviceImpl deviceImpl = this.createCameraDeviceImpl(cameraId, callback, executor, characteristics, (Context)context);
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, null, executor);
        executor.execute(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=28, maxSdk=30)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, null, executor);
        executor.execute(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=25, maxSdk=27)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = Build.VERSION.SDK_INT == 25 ? (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)}) : (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, handler, null);
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(maxSdk=24)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, handler, null);
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation
    protected void registerAvailabilityCallback(CameraManager.AvailabilityCallback callback, Handler handler) {
        Objects.requireNonNull(callback);
        registeredCallbacks.add(callback);
    }

    @Implementation
    protected void unregisterAvailabilityCallback(CameraManager.AvailabilityCallback callback) {
        Objects.requireNonNull(callback);
        registeredCallbacks.remove(callback);
    }

    @Implementation(minSdk=23)
    protected void registerTorchCallback(CameraManager.TorchCallback callback, Handler handler) {
        Objects.requireNonNull(callback);
        torchCallbacks.add(callback);
    }

    @Implementation(minSdk=23)
    protected void unregisterTorchCallback(CameraManager.TorchCallback callback) {
        Objects.requireNonNull(callback);
        torchCallbacks.remove(callback);
    }

    private CameraDeviceImpl createCameraDeviceImpl(String cameraId, CameraDevice.StateCallback callback, Executor executor, CameraCharacteristics characteristics, Context context) {
        Map<String, CameraCharacteristics> cameraCharacteristicsMap = Collections.emptyMap();
        if (RuntimeEnvironment.getApiLevel() >= 36) {
            return ((ReflectorCameraDeviceImpl)Reflector.reflector(ReflectorCameraDeviceImpl.class)).newCameraDeviceImplPostV(cameraId, callback, executor, characteristics, this.realObject, context.getApplicationInfo().targetSdkVersion, context, null, false);
        }
        if (RuntimeEnvironment.getApiLevel() == 35) {
            return ((ReflectorCameraDeviceImpl)Reflector.reflector(ReflectorCameraDeviceImpl.class)).newCameraDeviceImplV(cameraId, callback, executor, characteristics, this.realObject, context.getApplicationInfo().targetSdkVersion, context, null);
        }
        return ((ReflectorCameraDeviceImpl)Reflector.reflector(ReflectorCameraDeviceImpl.class)).newCameraDeviceImpl(cameraId, callback, executor, characteristics, cameraCharacteristicsMap, context.getApplicationInfo().targetSdkVersion, context);
    }

    private void triggerOnCameraAvailable(@Nonnull String cameraId) {
        Objects.requireNonNull(cameraId);
        for (CameraManager.AvailabilityCallback callback : registeredCallbacks) {
            callback.onCameraAvailable(cameraId);
        }
    }

    private void triggerOnCameraUnavailable(@Nonnull String cameraId) {
        Objects.requireNonNull(cameraId);
        for (CameraManager.AvailabilityCallback callback : registeredCallbacks) {
            callback.onCameraUnavailable(cameraId);
        }
    }

    public void addCamera(@Nonnull String cameraId, @Nonnull CameraCharacteristics characteristics) {
        Objects.requireNonNull(cameraId);
        Objects.requireNonNull(characteristics);
        Preconditions.checkArgument((!cameraIdToCharacteristics.containsKey(cameraId) ? 1 : 0) != 0);
        cameraIdToCharacteristics.put(cameraId, characteristics);
        this.triggerOnCameraAvailable(cameraId);
    }

    public void removeCamera(@Nonnull String cameraId) {
        Objects.requireNonNull(cameraId);
        Preconditions.checkArgument((boolean)cameraIdToCharacteristics.containsKey(cameraId));
        cameraIdToCharacteristics.remove(cameraId);
        this.triggerOnCameraUnavailable(cameraId);
    }

    public boolean getTorchMode(@Nonnull String cameraId) {
        Objects.requireNonNull(cameraId);
        Preconditions.checkArgument((boolean)cameraIdToCharacteristics.keySet().contains(cameraId));
        return cameraTorches.get(cameraId);
    }

    public void triggerDisconnect() {
        if (lastCallbackHandler != null) {
            lastCallbackHandler.post(() -> lastCallback.onDisconnected(lastDevice));
        } else if (lastCallbackExecutor != null) {
            lastCallbackExecutor.execute(() -> lastCallback.onDisconnected(lastDevice));
        }
    }

    protected void updateCameraCallback(CameraDevice device, CameraDevice.StateCallback callback, @Nullable Handler handler, @Nullable Executor executor) {
        lastDevice = device;
        lastCallback = callback;
        lastCallbackHandler = handler;
        lastCallbackExecutor = executor;
    }

    @ForType(value=CameraManager.class)
    private static interface ReflectorCameraManager {
        @Accessor(value="mContext")
        public Context getContext();
    }

    @ForType(value=CameraDeviceImpl.class)
    static interface ReflectorCameraDeviceImpl {
        @Constructor
        public CameraDeviceImpl newCameraDeviceImpl(String var1, CameraDevice.StateCallback var2, Executor var3, CameraCharacteristics var4, Map<String, CameraCharacteristics> var5, int var6, Context var7);

        @Constructor
        public CameraDeviceImpl newCameraDeviceImplV(String var1, CameraDevice.StateCallback var2, Executor var3, CameraCharacteristics var4, CameraManager var5, int var6, Context var7, @WithType(value="android.hardware.camera2.CameraDevice$CameraDeviceSetup") Object var8);

        @Constructor
        public CameraDeviceImpl newCameraDeviceImplPostV(String var1, CameraDevice.StateCallback var2, Executor var3, CameraCharacteristics var4, CameraManager var5, int var6, Context var7, @WithType(value="android.hardware.camera2.CameraDevice$CameraDeviceSetup") Object var8, boolean var9);
    }

    @Implements(className="android.hardware.camera2.CameraManager$CameraManagerGlobal")
    public static class ShadowCameraManagerGlobal {
        @Implementation(minSdk=24)
        protected void scheduleCameraServiceReconnectionLocked() {
        }
    }
}

