/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.MacAddress;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.rtt.RangingResult;
import android.net.wifi.rtt.ResponderLocation;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

public class RangingResultBuilder {
    private final int status;
    private final MacAddress mac;
    private final int distanceMm;
    private final long timestampMillis;
    private int distanceStdDevMm = 0;
    private int rssi = 0;
    private int numAttemptedMeasurements = 0;
    private int numSuccessfulMeasurements = 0;
    private byte[] lci = new byte[0];
    private byte[] lcr = new byte[0];
    private ResponderLocation unverifiedResponderLocation = null;
    private boolean is80211mcMeasurement = true;
    private boolean is80211azNtbMeasurement = false;

    public RangingResultBuilder(int status, MacAddress mac, long timestampMillis, int distanceMm) {
        this.status = status;
        this.mac = mac;
        this.timestampMillis = timestampMillis;
        this.distanceMm = distanceMm;
    }

    public RangingResultBuilder setDistanceStandardDeviation(int stddev) {
        this.distanceStdDevMm = stddev;
        return this;
    }

    public RangingResultBuilder setRssi(int rssi) {
        this.rssi = rssi;
        return this;
    }

    public RangingResultBuilder setNumAttemptedMeasurements(int num) {
        this.numAttemptedMeasurements = num;
        return this;
    }

    public RangingResultBuilder setNumSuccessfulMeasurements(int num) {
        this.numSuccessfulMeasurements = num;
        return this;
    }

    public RangingResultBuilder setLci(byte[] lci) {
        this.lci = lci;
        return this;
    }

    public RangingResultBuilder setLcr(byte[] lcr) {
        this.lcr = lcr;
        return this;
    }

    public RangingResultBuilder setUnverifiedResponderLocation(ResponderLocation unverifiedResponderLocation) {
        this.unverifiedResponderLocation = unverifiedResponderLocation;
        return this;
    }

    public RangingResultBuilder setIs80211mcMeasurement(boolean is80211mcMeasurement) {
        this.is80211mcMeasurement = is80211mcMeasurement;
        return this;
    }

    public RangingResultBuilder setIs80211azNtbMeasurement(boolean is80211azNtbMeasurement) {
        this.is80211azNtbMeasurement = is80211azNtbMeasurement;
        return this;
    }

    public RangingResult build() {
        if (RuntimeEnvironment.getApiLevel() >= 35) {
            Object builder;
            try {
                builder = ReflectionHelpers.newInstance(Class.forName("android.net.wifi.rtt.RangingResult$Builder"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setStatus(this.status);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setMacAddress(this.mac);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setDistanceMm(this.distanceMm);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setDistanceStdDevMm(this.distanceStdDevMm);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setRssi(this.rssi);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setNumAttemptedMeasurements(this.numAttemptedMeasurements);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setNumSuccessfulMeasurements(this.numSuccessfulMeasurements);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setLci(this.lci);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setLcr(this.lcr);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setUnverifiedResponderLocation(this.unverifiedResponderLocation);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).setRangingTimestampMillis(this.timestampMillis);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).set80211mcMeasurement(this.is80211mcMeasurement);
            ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).set80211azNtbMeasurement(this.is80211azNtbMeasurement);
            return ((RangingResultBuilderReflector)Reflector.reflector(RangingResultBuilderReflector.class, (Object)builder)).build();
        }
        if (RuntimeEnvironment.getApiLevel() > 30) {
            return RangingResultBuilder.asRangingResultS(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.unverifiedResponderLocation, this.timestampMillis, this.is80211mcMeasurement);
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return RangingResultBuilder.asRangingResultQ(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.unverifiedResponderLocation, this.timestampMillis);
        }
        return RangingResultBuilder.asRangingResultP(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.timestampMillis);
    }

    private static RangingResult asRangingResultP(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, long timestampMillis) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestampMillis)});
    }

    private static RangingResult asRangingResultQ(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation unverifiedResponderLocation, long timestampMillis) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(ResponderLocation.class, (Object)unverifiedResponderLocation), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestampMillis)});
    }

    private static RangingResult asRangingResultS(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, ResponderLocation unverifiedResponderLocation, long timestamp, boolean is80211mcMeasurement) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(ResponderLocation.class, (Object)unverifiedResponderLocation), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestamp), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)is80211mcMeasurement)});
    }

    @ForType(className="android.net.wifi.rtt.RangingResult$Builder")
    static interface RangingResultBuilderReflector {
        @Accessor(value="mStatus")
        public void setStatus(int var1);

        @Accessor(value="mMac")
        public void setMacAddress(MacAddress var1);

        @Accessor(value="mPeerHandle")
        public void setPeerHandle(PeerHandle var1);

        @Accessor(value="mDistanceMm")
        public void setDistanceMm(int var1);

        @Accessor(value="mDistanceStdDevMm")
        public void setDistanceStdDevMm(int var1);

        @Accessor(value="mRssi")
        public void setRssi(int var1);

        @Accessor(value="mNumAttemptedMeasurements")
        public void setNumAttemptedMeasurements(int var1);

        @Accessor(value="mNumSuccessfulMeasurements")
        public void setNumSuccessfulMeasurements(int var1);

        @Accessor(value="mLci")
        public void setLci(byte[] var1);

        @Accessor(value="mLcr")
        public void setLcr(byte[] var1);

        @Accessor(value="mResponderLocation")
        public void setUnverifiedResponderLocation(ResponderLocation var1);

        @Accessor(value="mTimestamp")
        public void setRangingTimestampMillis(long var1);

        @Accessor(value="mIs80211mcMeasurement")
        public void set80211mcMeasurement(boolean var1);

        @Accessor(value="mFrequencyMHz")
        public void setMeasurementChannelFrequencyMHz(int var1);

        @Accessor(value="mPacketBw")
        public void setMeasurementBandwidth(int var1);

        @Accessor(value="mIs80211azNtbMeasurement")
        public void set80211azNtbMeasurement(boolean var1);

        @Accessor(value="mNtbMinMeasurementTime")
        public void setMinTimeBetweenNtbMeasurementsMicros(long var1);

        @Accessor(value="mNtbMaxMeasurementTime")
        public void setMaxTimeBetweenNtbMeasurementsMicros(long var1);

        @Accessor(value="mI2rTxLtfRepetitions")
        public void set80211azInitiatorTxLtfRepetitionsCount(int var1);

        @Accessor(value="mR2iTxLtfRepetitions")
        public void set80211azResponderTxLtfRepetitionsCount(int var1);

        @Accessor(value="mNumTxSpatialStreams")
        public void set80211azNumberOfTxSpatialStreams(int var1);

        @Accessor(value="mNumRxSpatialStreams")
        public void set80211azNumberOfRxSpatialStreams(int var1);

        @Accessor(value="mVendorData")
        public void setVendorData(@WithType(value="java.util.List<android.net.wifi.OuiKeyedData>") Object var1);

        public RangingResult build();
    }
}

