/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiSsid;
import android.os.Build;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class WifiScanResultBuilder {
    private static final int UNSPECIFIED = -1;
    private static final int NATIVE_BUILDER_MIN_SDK = 35;
    private static final boolean USE_NATIVE_BUILDER = Build.VERSION.SDK_INT >= 35;
    @Nullable
    private String ssid;
    @Nullable
    private String bssid;
    @Nullable
    private String capabilities;
    private int rssi = -1;
    private int frequency = -1;
    private Duration timeSinceSeen = Duration.ZERO;
    private int channelWidth = 0;
    private int centerFreq0 = -1;
    private int centerFreq1 = -1;
    private boolean is80211McRttResponder = false;
    @Nullable
    private WifiSsid wifiSsid;
    @Nullable
    private ScanResult.Builder realBuilder;

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setCapabilities(@Nullable String capabilities) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setCaps(capabilities);
        } else {
            this.capabilities = capabilities;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setBssid(@Nullable String bssid) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setBssid(bssid);
        } else {
            this.bssid = bssid;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setRssi(int rssi) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setRssi(rssi);
        } else {
            this.rssi = rssi;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setFrequency(int frequency) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setFrequency(frequency);
        } else {
            this.frequency = frequency;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setSsid(@Nullable String ssid) {
        if (Build.VERSION.SDK_INT >= 33) {
            this.setWifiSsid(ssid != null ? WifiSsid.fromString((String)ssid) : null);
        } else {
            this.ssid = ssid;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public WifiScanResultBuilder setTimeSinceSeen(Duration timeSinceSeen) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setTsf(TimeUnit.MILLISECONDS.toMicros(timeSinceSeen.toMillis()));
        } else {
            this.timeSinceSeen = timeSinceSeen;
        }
        return this;
    }

    @RequiresApi(value=33)
    @CanIgnoreReturnValue
    public WifiScanResultBuilder setWifiSsid(@Nullable WifiSsid wifiSsid) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setWifiSsid(wifiSsid);
        } else {
            this.wifiSsid = wifiSsid;
            this.ssid = wifiSsid == null ? null : wifiSsid.toString();
        }
        return this;
    }

    @RequiresApi(value=23)
    @CanIgnoreReturnValue
    public WifiScanResultBuilder setChannelWidth(int channelWidth) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setChannelWidth(channelWidth);
        } else {
            this.channelWidth = channelWidth;
        }
        return this;
    }

    @RequiresApi(value=23)
    @CanIgnoreReturnValue
    public WifiScanResultBuilder setCenterFreq0(int centerFreq0) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setCenterFreq0(centerFreq0);
        } else {
            this.centerFreq0 = centerFreq0;
        }
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=23)
    public WifiScanResultBuilder setCenterFreq1(int centerFreq1) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setCenterFreq1(centerFreq1);
        } else {
            this.centerFreq1 = centerFreq1;
        }
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=23)
    public WifiScanResultBuilder setIs80211McRttResponder(boolean is80211McRttResponder) {
        if (USE_NATIVE_BUILDER) {
            this.ensureRealBuilder().setIs80211McRTTResponder(is80211McRttResponder);
        } else {
            this.is80211McRttResponder = is80211McRttResponder;
        }
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=35)
    public WifiScanResultBuilder setIs80211azNtbRttResponder(boolean is80211azNtbRttResponder) {
        this.ensureRealBuilder().setIs80211azNtbRTTResponder(is80211azNtbRttResponder);
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=35)
    public WifiScanResultBuilder setIsTwtResponder(boolean isTwtResponder) {
        this.ensureRealBuilder().setIsTwtResponder(isTwtResponder);
        return this;
    }

    public ScanResult build() {
        ScanResult scanResult;
        if (USE_NATIVE_BUILDER) {
            return this.ensureRealBuilder().build();
        }
        long timestampMicros = TimeUnit.MILLISECONDS.toMicros(this.timeSinceSeen.toMillis());
        if (Build.VERSION.SDK_INT >= 33) {
            scanResult = new ScanResult(this.wifiSsid, this.bssid, -1L, -1, null, this.capabilities, this.rssi, this.frequency, timestampMicros);
        } else {
            scanResult = new ScanResult();
            scanResult.SSID = this.ssid;
            scanResult.BSSID = this.bssid;
            scanResult.capabilities = this.capabilities;
            scanResult.level = this.rssi;
            scanResult.frequency = this.frequency;
            scanResult.timestamp = timestampMicros;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            scanResult.channelWidth = this.channelWidth;
            scanResult.centerFreq0 = this.centerFreq0;
            scanResult.centerFreq1 = this.centerFreq1;
            if (this.is80211McRttResponder) {
                scanResult.setFlag(2L);
            }
        }
        return scanResult;
    }

    @RequiresApi(value=35)
    private ScanResult.Builder ensureRealBuilder() {
        if (this.realBuilder == null) {
            this.realBuilder = new ScanResult.Builder();
        }
        return this.realBuilder;
    }
}

