/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.TrafficStats;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=TrafficStats.class)
public class ShadowTrafficStats {
    private static int mobileTxPackets = -1;
    private static int mobileRxPackets = -1;
    private static int mobileTxBytes = -1;
    private static int mobileRxBytes = -1;
    private static int totalTxPackets = -1;
    private static int totalRxPackets = -1;
    private static int totalTxBytes = -1;
    private static int totalRxBytes = -1;
    private static final ThreadLocal<Integer> threadTag = ThreadLocal.withInitial(() -> -1);

    @Implementation
    protected static void setThreadStatsTag(int tag) {
        threadTag.set(tag);
    }

    @Implementation
    protected static int getThreadStatsTag() {
        return threadTag.get();
    }

    @Implementation
    protected static void clearThreadStatsTag() {
        threadTag.set(-1);
    }

    @Implementation
    protected static void tagSocket(Socket socket) throws SocketException {
    }

    @Implementation(minSdk=24)
    protected static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
    }

    @Implementation
    protected static void untagSocket(Socket socket) throws SocketException {
    }

    @Implementation
    protected static void incrementOperationCount(int operationCount) {
    }

    @Implementation
    protected static void incrementOperationCount(int tag, int operationCount) {
    }

    @Implementation
    protected static long getMobileTxPackets() {
        return mobileTxPackets;
    }

    @Implementation
    protected static long getMobileRxPackets() {
        return mobileRxPackets;
    }

    @Implementation
    protected static long getMobileTxBytes() {
        return mobileTxBytes;
    }

    @Implementation
    protected static long getMobileRxBytes() {
        return mobileRxBytes;
    }

    @Implementation
    protected static long getTotalTxPackets() {
        return totalTxPackets;
    }

    @Implementation
    protected static long getTotalRxPackets() {
        return totalRxPackets;
    }

    @Implementation
    protected static long getTotalTxBytes() {
        return totalTxBytes;
    }

    @Implementation
    protected static long getTotalRxBytes() {
        return totalRxBytes;
    }

    @Implementation
    protected static long getUidTxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidRxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidTxPackets(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidRxPackets(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidTcpTxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidTcpRxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidUdpTxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidUdpRxBytes(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidTcpTxSegments(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidTcpRxSegments(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidUdpTxPackets(int i) {
        return -1L;
    }

    @Implementation
    protected static long getUidUdpRxPackets(int i) {
        return -1L;
    }

    public static void setMobileTxPackets(int mobileTxPackets) {
        ShadowTrafficStats.mobileTxPackets = mobileTxPackets;
    }

    public static void setMobileRxPackets(int mobileRxPackets) {
        ShadowTrafficStats.mobileRxPackets = mobileRxPackets;
    }

    public static void setMobileTxBytes(int mobileTxBytes) {
        ShadowTrafficStats.mobileTxBytes = mobileTxBytes;
    }

    public static void setMobileRxBytes(int mobileRxBytes) {
        ShadowTrafficStats.mobileRxBytes = mobileRxBytes;
    }

    public static void setTotalTxPackets(int totalTxPackets) {
        ShadowTrafficStats.totalTxPackets = totalTxPackets;
    }

    public static void setTotalRxPackets(int totalRxPackets) {
        ShadowTrafficStats.totalRxPackets = totalRxPackets;
    }

    public static void setTotalTxBytes(int totalTxBytes) {
        ShadowTrafficStats.totalTxBytes = totalTxBytes;
    }

    public static void setTotalRxBytes(int totalRxBytes) {
        ShadowTrafficStats.totalRxBytes = totalRxBytes;
    }

    @Resetter
    public static void restoreDefaults() {
        mobileTxPackets = -1;
        mobileRxPackets = -1;
        mobileTxBytes = -1;
        mobileRxBytes = -1;
        totalTxPackets = -1;
        totalRxPackets = -1;
        totalTxBytes = -1;
        totalRxBytes = -1;
        threadTag.remove();
    }
}

