/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowUserManager;

@Implements(value=StorageManager.class)
public class ShadowStorageManager {
    private static boolean isFileEncryptionSupported = true;
    private static final List<StorageVolume> storageVolumeList = new ArrayList<StorageVolume>();

    @Implementation(minSdk=23)
    protected static StorageVolume[] getVolumeList(int userId, int flags) {
        return storageVolumeList.toArray(new StorageVolume[0]);
    }

    @Implementation
    public StorageVolume[] getVolumeList() {
        return ShadowStorageManager.getVolumeList(0, 0);
    }

    public void addStorageVolume(StorageVolume storageVolume) {
        Objects.requireNonNull(storageVolume);
        storageVolumeList.add(storageVolume);
    }

    @Implementation(minSdk=24)
    protected List<StorageVolume> getStorageVolumes() {
        return storageVolumeList;
    }

    public void resetStorageVolumeList() {
        storageVolumeList.clear();
    }

    @Implementation(minSdk=24)
    public StorageVolume getStorageVolume(File file) {
        for (StorageVolume volume : storageVolumeList) {
            File volumeFile = volume.getPathFile();
            if (!file.getAbsolutePath().startsWith(volumeFile.getAbsolutePath())) continue;
            return volume;
        }
        return null;
    }

    @HiddenApi
    @Implementation(minSdk=24, maxSdk=33)
    protected static boolean isFileEncryptedNativeOrEmulated() {
        return isFileEncryptionSupported;
    }

    public void setFileEncryptedNativeOrEmulated(boolean isSupported) {
        isFileEncryptionSupported = isSupported;
    }

    @HiddenApi
    @Implementation(minSdk=24, maxSdk=34)
    protected static boolean isUserKeyUnlocked(int userId) {
        ShadowUserManager extract = (ShadowUserManager)Shadow.extract((Object)RuntimeEnvironment.getApplication().getSystemService(UserManager.class));
        return extract.isUserUnlocked();
    }

    @Resetter
    public static void reset() {
        storageVolumeList.clear();
        isFileEncryptionSupported = true;
    }
}

