/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.telephony.CellIdentityWcdma;
import android.telephony.ClosedSubscriberGroupInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=29)
public class CellIdentityWcdmaBuilder {
    private int lac = Integer.MAX_VALUE;
    private int cid = Integer.MAX_VALUE;
    private int psc = Integer.MAX_VALUE;
    private int uarfcn = Integer.MAX_VALUE;
    private List<String> additionalPlmns = new ArrayList<String>();
    @Nullable
    private String mccStr = null;
    @Nullable
    private String mncStr = null;
    @Nullable
    private String alphal = null;
    @Nullable
    private String alphas = null;
    @Nullable
    private ClosedSubscriberGroupInfo csgInfo = null;

    private CellIdentityWcdmaBuilder() {
    }

    public static CellIdentityWcdmaBuilder newBuilder() {
        return new CellIdentityWcdmaBuilder();
    }

    @RequiresApi(value=30)
    protected static CellIdentityWcdma getDefaultInstance() {
        return ((CellIdentityWcdmaReflector)Reflector.reflector(CellIdentityWcdmaReflector.class)).newCellIdentityWcdma();
    }

    public CellIdentityWcdmaBuilder setLac(int lac) {
        this.lac = lac;
        return this;
    }

    public CellIdentityWcdmaBuilder setCid(int cid) {
        this.cid = cid;
        return this;
    }

    public CellIdentityWcdmaBuilder setPsc(int psc) {
        this.psc = psc;
        return this;
    }

    public CellIdentityWcdmaBuilder setUarfcn(int uarfcn) {
        this.uarfcn = uarfcn;
        return this;
    }

    public CellIdentityWcdmaBuilder setMcc(String mcc) {
        this.mccStr = mcc;
        return this;
    }

    public CellIdentityWcdmaBuilder setMnc(String mnc) {
        this.mncStr = mnc;
        return this;
    }

    public CellIdentityWcdmaBuilder setOperatorAlphaLong(String operatorAlphaLong) {
        this.alphal = operatorAlphaLong;
        return this;
    }

    public CellIdentityWcdmaBuilder setOperatorAlphaShort(String operatorAlphaShort) {
        this.alphas = operatorAlphaShort;
        return this;
    }

    public CellIdentityWcdmaBuilder setAdditionalPlmns(List<String> additionalPlmns) {
        this.additionalPlmns = additionalPlmns;
        return this;
    }

    public CellIdentityWcdmaBuilder setCsgInfo(ClosedSubscriberGroupInfo csgInfo) {
        this.csgInfo = csgInfo;
        return this;
    }

    public CellIdentityWcdma build() {
        CellIdentityWcdmaReflector cellIdentityReflector = (CellIdentityWcdmaReflector)Reflector.reflector(CellIdentityWcdmaReflector.class);
        if (RuntimeEnvironment.getApiLevel() < 24) {
            int mcc = CellIdentityWcdmaBuilder.parseInt(this.mccStr, Integer.MAX_VALUE);
            int mnc = CellIdentityWcdmaBuilder.parseInt(this.mncStr, Integer.MAX_VALUE);
            return cellIdentityReflector.newCellIdentityWcdma(mcc, mnc, this.lac, this.cid, this.psc);
        }
        if (RuntimeEnvironment.getApiLevel() < 28) {
            int mcc = CellIdentityWcdmaBuilder.parseInt(this.mccStr, Integer.MAX_VALUE);
            int mnc = CellIdentityWcdmaBuilder.parseInt(this.mncStr, Integer.MAX_VALUE);
            return cellIdentityReflector.newCellIdentityWcdma(mcc, mnc, this.lac, this.cid, this.psc, this.uarfcn);
        }
        if (RuntimeEnvironment.getApiLevel() < 30) {
            return cellIdentityReflector.newCellIdentityWcdma(this.lac, this.cid, this.psc, this.uarfcn, this.mccStr, this.mncStr, this.alphal, this.alphas);
        }
        return cellIdentityReflector.newCellIdentityWcdma(this.lac, this.cid, this.psc, this.uarfcn, this.mccStr, this.mncStr, this.alphal, this.alphas, this.additionalPlmns, this.csgInfo);
    }

    private static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse integer from string: " + str, e);
        }
    }

    @ForType(value=CellIdentityWcdma.class)
    private static interface CellIdentityWcdmaReflector {
        @Constructor
        public CellIdentityWcdma newCellIdentityWcdma();

        @Constructor
        public CellIdentityWcdma newCellIdentityWcdma(int var1, int var2, int var3, int var4, int var5);

        @Constructor
        public CellIdentityWcdma newCellIdentityWcdma(int var1, int var2, int var3, int var4, int var5, int var6);

        @Constructor
        public CellIdentityWcdma newCellIdentityWcdma(int var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8);

        @Constructor
        public CellIdentityWcdma newCellIdentityWcdma(int var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8, Collection<String> var9, ClosedSubscriberGroupInfo var10);
    }
}

