/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.ActivityThread;
import android.app.Application;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.util.ReflectionHelpers;

public class ServiceController<T extends Service>
extends ComponentController<ServiceController<T>, T> {
    public static <T extends Service> ServiceController<T> of(T service, Intent intent) {
        ServiceController<T> controller = new ServiceController<T>(service, intent);
        super.attach();
        return controller;
    }

    private ServiceController(T service, Intent intent) {
        super(service, intent);
    }

    private ServiceController<T> attach() {
        if (this.attached) {
            return this;
        }
        Context context = RuntimeEnvironment.getApplication().getBaseContext();
        ComponentName name = new ComponentName(context.getPackageName(), ((Service)this.component).getClass().getName());
        context.getPackageManager().setComponentEnabledSetting(name, 1, 0);
        ReflectionHelpers.callInstanceMethod(Service.class, (Object)this.component, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.getApplication().getBaseContext()), ReflectionHelpers.ClassParameter.from(ActivityThread.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)((Service)this.component).getClass().getSimpleName()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Application.class, (Object)RuntimeEnvironment.getApplication()), ReflectionHelpers.ClassParameter.from(Object.class, null)});
        this.attached = true;
        return this;
    }

    public ServiceController<T> bind() {
        this.invokeWhilePaused("onBind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    @Override
    public ServiceController<T> create() {
        this.invokeWhilePaused("onCreate", new ReflectionHelpers.ClassParameter[0]);
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    @Override
    public ServiceController<T> destroy() {
        this.invokeWhilePaused("onDestroy", new ReflectionHelpers.ClassParameter[0]);
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    public ServiceController<T> rebind() {
        this.invokeWhilePaused("onRebind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    public ServiceController<T> startCommand(int flags, int startId) {
        this.invokeWhilePaused("onStartCommand", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)startId));
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    public ServiceController<T> unbind() {
        this.invokeWhilePaused("onUnbind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        this.shadowMainLooper.idleIfPaused();
        return this;
    }

    @Deprecated
    public ServiceController<T> withIntent(Intent intent) {
        this.intent = intent;
        return this;
    }
}

