/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowValueAnimator;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Settings.class)
public class ShadowSettings {
    private static boolean canDrawOverlays = false;

    public static void setAirplaneMode(boolean isAirplaneMode) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
    }

    public static void setWifiOn(boolean isOn) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
    }

    public static void set24HourTimeFormat(boolean use24HourTimeFormat) {
        Settings.System.putString((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"time_12_24", (String)(use24HourTimeFormat ? "24" : "12"));
    }

    @Implementation(minSdk=23)
    protected static boolean canDrawOverlays(Context context) {
        return canDrawOverlays;
    }

    public static void setCanDrawOverlays(boolean canDrawOverlays) {
        ShadowSettings.canDrawOverlays = canDrawOverlays;
    }

    public static void setAdbEnabled(boolean adbEnabled) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
    }

    public static void setInstallNonMarketApps(boolean installNonMarketApps) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
    }

    public static void setLockScreenShowNotifications(boolean lockScreenShowNotifications) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"lock_screen_show_notifications", (int)(lockScreenShowNotifications ? 1 : 0));
    }

    public static void setLockScreenAllowPrivateNotifications(boolean lockScreenAllowPrivateNotifications) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"lock_screen_allow_private_notifications", (int)(lockScreenAllowPrivateNotifications ? 1 : 0));
    }

    @Resetter
    public static void reset() {
        canDrawOverlays = false;
    }

    @ForType(value=Settings.Config.class)
    static interface SettingsConfigReflector {
        @Static
        public String createCompositeName(String var1, String var2);
    }

    @ForType(value=Settings.Secure.class)
    static interface SettingsSecureReflector {
        @Static
        public int getLocationModeForUser(ContentResolver var1, int var2);
    }

    @Implements(value=Settings.Config.class, isInAndroidSdk=false, minSdk=29)
    public static class ShadowConfig {
        private static final Map<String, String> settings = new ConcurrentHashMap<String, String>();

        @Implementation(maxSdk=29)
        protected static boolean putString(ContentResolver cr, String name, String value, boolean makeDefault) {
            return ShadowConfig.put(name, value);
        }

        @Implementation(minSdk=30, maxSdk=33)
        protected static boolean putString(ContentResolver cr, String namespace, String name, String value, boolean makeDefault) {
            String key = ((SettingsConfigReflector)Reflector.reflector(SettingsConfigReflector.class)).createCompositeName(namespace, name);
            return ShadowConfig.put(key, value);
        }

        @Implementation(minSdk=34)
        protected static boolean putString(String namespace, String name, String value, boolean makeDefault) {
            String key = ((SettingsConfigReflector)Reflector.reflector(SettingsConfigReflector.class)).createCompositeName(namespace, name);
            return ShadowConfig.put(key, value);
        }

        @Implementation(maxSdk=33)
        protected static String getString(ContentResolver cr, String name) {
            return ShadowConfig.get(name);
        }

        @Implementation(minSdk=34)
        protected static String getString(String name) {
            return ShadowConfig.get(name);
        }

        @Implementation(minSdk=30)
        protected static Map<String, String> getStrings(ContentResolver resolver, String namespace, List<String> names) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(namespace + "/")) continue;
                String keyWithoutNamespace = key.substring(namespace.length() + 1);
                if (names == null || names.isEmpty()) {
                    result.put(keyWithoutNamespace, entry.getValue());
                    continue;
                }
                if (!names.contains(keyWithoutNamespace)) continue;
                result.put(keyWithoutNamespace, entry.getValue());
            }
            return ImmutableMap.copyOf(result);
        }

        private static boolean put(String name, String value) {
            settings.put(name, value);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Implementation(minSdk=30)
        protected static boolean setStrings(ContentResolver cr, String namespace, Map<String, String> keyValues) {
            Map<String, String> map = settings;
            synchronized (map) {
                settings.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(namespace + "/"));
                for (Map.Entry<String, String> entry2 : keyValues.entrySet()) {
                    String key = ((SettingsConfigReflector)Reflector.reflector(SettingsConfigReflector.class)).createCompositeName(namespace, entry2.getKey());
                    ShadowConfig.put(key, entry2.getValue());
                }
            }
            return true;
        }

        @Implementation(minSdk=34)
        protected static boolean deleteString(String namespace, String name) {
            String key = ((SettingsConfigReflector)Reflector.reflector(SettingsConfigReflector.class)).createCompositeName(namespace, name);
            settings.remove(key);
            return true;
        }

        @Implementation(minSdk=33, maxSdk=33)
        protected static boolean deleteString(ContentResolver resolver, String namespace, String name) {
            return ShadowConfig.deleteString(namespace, name);
        }

        private static String get(String name) {
            return settings.get(name);
        }

        @Resetter
        public static void reset() {
            settings.clear();
        }
    }

    @Implements(value=Settings.Global.class)
    public static class ShadowGlobal {
        private static final ImmutableMap<String, Optional<Object>> DEFAULTS = ImmutableMap.of((Object)"animator_duration_scale", Optional.of(1));
        private static final Map<String, Optional<Object>> settings = new ConcurrentHashMap<String, Optional<Object>>((Map<String, Optional<Object>>)DEFAULTS);

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            return ShadowGlobal.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowGlobal.get(String.class, name).orElse(null);
        }

        @Implementation
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowGlobal.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowGlobal.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            boolean result = ShadowGlobal.put(cr, name, Float.valueOf(value));
            if ("animator_duration_scale".equals(name)) {
                ShadowValueAnimator.setDurationScale(value);
            }
            return result;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowGlobal.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(settings.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.Global.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return settings.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        @Resetter
        public static void reset() {
            settings.clear();
            settings.putAll((Map<String, Optional<Object>>)DEFAULTS);
        }
    }

    @Implements(value=Settings.Secure.class)
    public static class ShadowSecure {
        private static final HashMap<String, Optional<Object>> SECURE_DEFAULTS = new HashMap();
        static final boolean INITIAL_GPS_PROVIDER_STATE = true;
        static final boolean INITIAL_NETWORK_PROVIDER_STATE = false;
        private static final Map<String, Optional<Object>> dataMap;

        @Implementation(maxSdk=28)
        protected static boolean setLocationProviderEnabledForUser(ContentResolver cr, String provider, boolean enabled, int uid) {
            return ShadowSecure.updateEnabledProviders(cr, provider, enabled);
        }

        static boolean updateEnabledProviders(ContentResolver cr, String provider, boolean enabled) {
            HashSet<String> providers = new HashSet<String>();
            String oldProviders = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (!TextUtils.isEmpty((CharSequence)oldProviders)) {
                providers.addAll(Arrays.asList(oldProviders.split(",")));
            }
            if (enabled == oldProviders.contains(provider)) {
                return true;
            }
            if (enabled) {
                providers.add(provider);
            } else {
                providers.remove(provider);
            }
            String newProviders = TextUtils.join((CharSequence)",", (Object[])providers.toArray());
            boolean r = Settings.Secure.putString((ContentResolver)cr, (String)"location_providers_allowed", (String)newProviders);
            Intent providersBroadcast = new Intent("android.location.PROVIDERS_CHANGED");
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                providersBroadcast.putExtra("android.location.extra.PROVIDER_NAME", provider);
            }
            if (RuntimeEnvironment.getApiLevel() >= 30) {
                providersBroadcast.putExtra("android.location.extra.PROVIDER_ENABLED", enabled);
            }
            RuntimeEnvironment.getApplication().sendBroadcast(providersBroadcast);
            return r;
        }

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            boolean changed;
            boolean bl = changed = !Objects.equals(dataMap.put(name, Optional.of(value)), Optional.of(value));
            if ("location_mode".equals(name)) {
                if (RuntimeEnvironment.getApiLevel() <= 28) {
                    boolean gps = value == 1 || value == 3;
                    boolean network = value == 2 || value == 3;
                    Settings.Secure.setLocationProviderEnabled((ContentResolver)cr, (String)"gps", (boolean)gps);
                    Settings.Secure.setLocationProviderEnabled((ContentResolver)cr, (String)"network", (boolean)network);
                }
                Intent modeBroadcast = new Intent("android.location.MODE_CHANGED");
                if (RuntimeEnvironment.getApiLevel() >= 30) {
                    modeBroadcast.putExtra("android.location.extra.LOCATION_ENABLED", value != 0);
                }
                RuntimeEnvironment.getApplication().sendBroadcast(modeBroadcast);
            }
            if (changed && cr != null) {
                cr.notifyChange(Settings.Secure.getUriFor((String)name), null);
            }
            return true;
        }

        @Implementation
        protected static boolean putIntForUser(ContentResolver cr, String name, int value, int userHandle) {
            ShadowSecure.putInt(cr, name, value);
            return true;
        }

        @Implementation
        protected static int getIntForUser(ContentResolver cr, String name, int def, int userHandle) {
            return ShadowSecure.getInt(cr, name, def);
        }

        @Implementation
        protected static int getIntForUser(ContentResolver cr, String name, int userHandle) throws Settings.SettingNotFoundException {
            return ShadowSecure.getInt(cr, name);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() < 28) {
                return ((SettingsSecureReflector)Reflector.reflector(SettingsSecureReflector.class)).getLocationModeForUser(cr, 0);
            }
            return ShadowSecure.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() < 28) {
                return ((SettingsSecureReflector)Reflector.reflector(SettingsSecureReflector.class)).getLocationModeForUser(cr, 0);
            }
            return ShadowSecure.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowSecure.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowSecure.get(String.class, name).orElse(null);
        }

        @Implementation
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSecure.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowSecure.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowSecure.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSecure.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            return ShadowSecure.put(cr, name, Float.valueOf(value));
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowSecure.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSecure.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(dataMap.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.Secure.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return dataMap.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        public static void remove(String name) {
            dataMap.remove(name);
        }

        @Resetter
        public static void reset() {
            dataMap.clear();
            dataMap.putAll(SECURE_DEFAULTS);
        }

        static {
            SECURE_DEFAULTS.put("location_mode", Optional.of(1));
            SECURE_DEFAULTS.put("location_providers_allowed", Optional.of("gps"));
            dataMap = new ConcurrentHashMap<String, Optional<Object>>(SECURE_DEFAULTS);
        }
    }

    @Implements(value=Settings.System.class)
    public static class ShadowSystem {
        private static final ImmutableMap<String, Optional<Object>> DEFAULTS = ImmutableMap.of((Object)"animator_duration_scale", Optional.of(1));
        private static final Map<String, Optional<Object>> settings = new ConcurrentHashMap<String, Optional<Object>>((Map<String, Optional<Object>>)DEFAULTS);

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            return ShadowSystem.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowSystem.get(String.class, name).orElse(null);
        }

        @Implementation
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSystem.get(String.class, name).orElse(null);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowSystem.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            boolean result = ShadowSystem.put(cr, name, Float.valueOf(value));
            if ("window_animation_scale".equals(name)) {
                ShadowValueAnimator.setDurationScale(value);
            }
            return result;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowSystem.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(settings.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.System.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return settings.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        @Resetter
        public static void reset() {
            settings.clear();
            settings.putAll((Map<String, Optional<Object>>)DEFAULTS);
        }
    }
}

