/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.TypedValue;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.Bootstrap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowXmlBlock;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Resources.class)
public class ShadowResources {
    private static Resources system = null;
    private static List<LongSparseArray<?>> resettableArrays;
    @RealObject
    Resources realResources;
    private final Set<OnConfigurationChangeListener> configurationChangeListeners = new HashSet<OnConfigurationChangeListener>();

    @Resetter
    public static void reset() {
        if (resettableArrays == null) {
            resettableArrays = ShadowResources.obtainResettableArrays();
        }
        for (LongSparseArray<?> sparseArray : resettableArrays) {
            sparseArray.clear();
        }
        system = null;
        ReflectionHelpers.setStaticField(Resources.class, (String)"mSystem", null);
    }

    @Implementation
    protected static Resources getSystem() {
        if (system == null) {
            AssetManager assetManager = AssetManager.getSystem();
            system = new Resources(assetManager, Bootstrap.getDisplayMetrics(), Bootstrap.getConfiguration());
        }
        return system;
    }

    @HiddenApi
    @Implementation
    protected XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ResourcesReflector relectedResources = (ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources);
        return ShadowResources.setSourceResourceId(relectedResources.loadXmlResourceParser(resId, type), resId);
    }

    @HiddenApi
    @Implementation
    protected XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        ResourcesReflector relectedResources = (ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources);
        return ShadowResources.setSourceResourceId(relectedResources.loadXmlResourceParser(file, id2, assetCookie, type), id2);
    }

    private static XmlResourceParser setSourceResourceId(XmlResourceParser parser, int resourceId) {
        Object shadow;
        Object object = shadow = parser instanceof ShadowedObject ? Shadow.extract((Object)parser) : null;
        if (shadow instanceof ShadowXmlBlock.ShadowParser) {
            ((ShadowXmlBlock.ShadowParser)shadow).setSourceResourceId(resourceId);
        }
        return parser;
    }

    @Implementation(maxSdk=25)
    protected Drawable loadDrawable(TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        Drawable drawable2 = ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).loadDrawable(value, id2, theme);
        ShadowResources.setCreatedFromResId(this.realResources, id2, drawable2);
        return drawable2;
    }

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    @Implementation(minSdk=29)
    public static int getAttributeSetSourceResId(AttributeSet attrs) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class)).getAttributeSetSourceResId(attrs);
        }
        Object shadow = attrs instanceof ShadowedObject ? Shadow.extract((Object)attrs) : null;
        return shadow instanceof ShadowXmlBlock.ShadowParser ? ((ShadowXmlBlock.ShadowParser)shadow).getSourceResourceId() : 0;
    }

    public void addConfigurationChangeListener(OnConfigurationChangeListener listener) {
        this.configurationChangeListeners.add(listener);
    }

    public void removeConfigurationChangeListener(OnConfigurationChangeListener listener) {
        this.configurationChangeListeners.remove(listener);
    }

    @Implementation
    protected void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Configuration oldConfig;
        try {
            oldConfig = new Configuration(this.realResources.getConfiguration());
        }
        catch (NullPointerException e) {
            oldConfig = null;
        }
        ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).updateConfiguration(config, metrics, compat);
        if (oldConfig != null && config != null) {
            for (OnConfigurationChangeListener listener : this.configurationChangeListeners) {
                listener.onConfigurationChange(oldConfig, config, metrics);
            }
        }
    }

    static void setCreatedFromResId(Resources resources, int id2, Drawable drawable2) {
        if (drawable2 != null && Shadow.extract((Object)drawable2) instanceof ShadowDrawable) {
            String resourceName;
            ShadowDrawable shadowDrawable = (ShadowDrawable)Shadow.extract((Object)drawable2);
            try {
                resourceName = resources.getResourceName(id2);
            }
            catch (Resources.NotFoundException e) {
                resourceName = "Unknown resource #0x" + Integer.toHexString(id2);
            }
            shadowDrawable.setCreatedFromResId(id2, resourceName);
        }
    }

    @ForType(value=Resources.class)
    static interface ResourcesReflector {
        @Direct
        public XmlResourceParser loadXmlResourceParser(int var1, String var2);

        @Direct
        public XmlResourceParser loadXmlResourceParser(String var1, int var2, int var3, String var4);

        @Direct
        public Drawable loadDrawable(TypedValue var1, int var2);

        @Direct
        public Drawable loadDrawable(TypedValue var1, int var2, Resources.Theme var3);

        @Direct
        public TypedArray obtainAttributes(AttributeSet var1, int[] var2);

        @Direct
        public String getQuantityString(int var1, int var2, Object ... var3);

        @Direct
        public String getQuantityString(int var1, int var2);

        @Direct
        public InputStream openRawResource(int var1);

        @Direct
        public AssetFileDescriptor openRawResourceFd(int var1);

        @Direct
        public TypedArray obtainTypedArray(int var1);

        @Direct
        public int getAttributeSetSourceResId(AttributeSet var1);

        @Direct
        public void updateConfiguration(Configuration var1, DisplayMetrics var2, CompatibilityInfo var3);
    }

    public static interface OnConfigurationChangeListener {
        public void onConfigurationChange(Configuration var1, Configuration var2, DisplayMetrics var3);
    }

    @Implements(value=Resources.NotFoundException.class)
    public static class ShadowNotFoundException {
        @RealObject
        Resources.NotFoundException realObject;
        private String message;

        @Implementation
        protected void __constructor__() {
        }

        @Implementation
        protected void __constructor__(String name) {
            this.message = name;
        }

        @Implementation
        public String toString() {
            return ((Object)((Object)this.realObject)).getClass().getName() + ": " + this.message;
        }
    }
}

