/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.graphics.Rect;
import android.util.Size;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import libcore.io.IoUtils;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ImageDecoder.class, isInAndroidSdk=false, minSdk=28)
public class ShadowImageDecoder {
    private static final NativeObjRegistry<CppImageDecoder> NATIVE_IMAGE_DECODER_REGISTRY = new NativeObjRegistry(CppImageDecoder.class);

    private static ImageDecoder jniCreateDecoder(ImgStream imgStream) {
        CppImageDecoder cppImageDecoder = new CppImageDecoder(imgStream);
        long cppImageDecoderPtr = NATIVE_IMAGE_DECODER_REGISTRY.register((Object)cppImageDecoder);
        return (ImageDecoder)ReflectionHelpers.callConstructor(ImageDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)cppImageDecoderPtr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)imgStream.getWidth()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)imgStream.getHeight()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)imgStream.isAnimated()), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)imgStream.isNinePatch())});
    }

    protected static ImageDecoder ImageDecoder_nCreateFd(FileDescriptor fileDescriptor, ImageDecoder.Source source) {
        throw new UnsupportedOperationException();
    }

    protected static ImageDecoder ImageDecoder_nCreateInputStream(final InputStream is, byte[] storage, ImageDecoder.Source source) {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return is;
            }
        });
    }

    protected static ImageDecoder ImageDecoder_nCreateAsset(final AssetManager.AssetInputStream assetInputStream, ImageDecoder.Source source) throws ImageDecoder.DecodeException {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return assetInputStream;
            }
        });
    }

    protected static ImageDecoder ImageDecoder_nCreateByteBuffer(final ByteBuffer jbyteBuffer, int initialPosition, int limit, ImageDecoder.Source source) throws ImageDecoder.DecodeException {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return new ByteArrayInputStream(jbyteBuffer.array());
            }
        });
    }

    protected static ImageDecoder ImageDecoder_nCreateByteArray(final byte[] byteArray, int offset, int length, ImageDecoder.Source source) {
        return ShadowImageDecoder.jniCreateDecoder(new ImgStream(){

            @Override
            protected InputStream getInputStream() {
                return new ByteArrayInputStream(byteArray);
            }
        });
    }

    protected static Bitmap ImageDecoder_nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, ColorSpace desiredColorSpace) throws IOException {
        CppImageDecoder cppImageDecoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        ImgStream imgStream = cppImageDecoder.imgStream;
        InputStream stream = imgStream.getInputStream();
        if (stream == null) {
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
        if (bitmap.getWidth() != width || bitmap.getHeight() != height) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        if (imgStream.isNinePatch() && ReflectionHelpers.getField((Object)bitmap, (String)"mNinePatchChunk") == null) {
            ReflectionHelpers.setField(Bitmap.class, (Object)bitmap, (String)"mNinePatchChunk", (Object)new byte[0]);
        }
        return bitmap;
    }

    static Size ImageDecoder_nGetSampledSize(long nativePtr, int sampleSize) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        throw new UnsupportedOperationException();
    }

    static void ImageDecoder_nGetPadding(long nativePtr, Rect outPadding) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        if (decoder.imgStream.isNinePatch()) {
            outPadding.set(0, 0, 0, 0);
        } else {
            outPadding.set(-1, -1, -1, -1);
        }
    }

    static void ImageDecoder_nClose(long nativePtr) {
        NATIVE_IMAGE_DECODER_REGISTRY.unregister(nativePtr);
    }

    static String ImageDecoder_nGetMimeType(long nativePtr) {
        CppImageDecoder decoder = (CppImageDecoder)NATIVE_IMAGE_DECODER_REGISTRY.getNativeObject(nativePtr);
        return decoder.getMimeType();
    }

    static ColorSpace ImageDecoder_nGetColorSpace(long nativePtr) {
        return ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder nCreate(ByteBuffer buffer, int position, int limit, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteBuffer(buffer, position, limit, src);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder nCreate(byte[] data, int offset, int length, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteArray(data, offset, length, src);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder nCreate(InputStream is, byte[] storage, ImageDecoder.Source source) {
        return ShadowImageDecoder.ImageDecoder_nCreateInputStream(is, storage, source);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder nCreate(FileDescriptor fd, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateFd(fd, src);
    }

    @Implementation(maxSdk=29)
    protected static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, ImageDecoder.Source source) throws IOException {
        return ShadowImageDecoder.createFromAsset(ais, false, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, boolean preferAnimation, ImageDecoder.Source source) throws IOException {
        ImageDecoder decoder = null;
        try {
            decoder = ShadowImageDecoder.ImageDecoder_nCreateAsset(ais, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly((AutoCloseable)ais);
            } else {
                ((ImageDecoderReflector)Reflector.reflector(ImageDecoderReflector.class, (Object)decoder)).setInputStream((InputStream)ais);
                ((ImageDecoderReflector)Reflector.reflector(ImageDecoderReflector.class, (Object)decoder)).setOwnsInputStream(true);
            }
        }
        return decoder;
    }

    @Implementation(minSdk=30)
    protected static ImageDecoder nCreate(ByteBuffer buffer, int position, int limit, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteBuffer(buffer, position, limit, src);
    }

    @Implementation(minSdk=30)
    protected static ImageDecoder nCreate(byte[] data, int offset, int length, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateByteArray(data, offset, length, src);
    }

    @Implementation(minSdk=30)
    protected static ImageDecoder nCreate(InputStream is, byte[] storage, boolean preferAnimation, ImageDecoder.Source source) {
        return ShadowImageDecoder.ImageDecoder_nCreateInputStream(is, storage, source);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected static ImageDecoder nCreate(FileDescriptor fd, boolean preferAnimation, ImageDecoder.Source src) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nCreateFd(fd, src);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, ColorSpace desiredColorSpace) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nDecodeBitmap(nativePtr, decoder, doPostProcess, width, height, cropRect, mutable, allocator, unpremulRequired, conserveMemory, decodeAsAlphaMask, desiredColorSpace);
    }

    @Implementation(minSdk=29)
    protected static Bitmap nDecodeBitmap(long nativePtr, ImageDecoder decoder, boolean doPostProcess, int width, int height, Rect cropRect, boolean mutable, int allocator, boolean unpremulRequired, boolean conserveMemory, boolean decodeAsAlphaMask, long desiredColorSpace, boolean extended) throws IOException {
        return ShadowImageDecoder.ImageDecoder_nDecodeBitmap(nativePtr, decoder, doPostProcess, width, height, cropRect, mutable, allocator, unpremulRequired, conserveMemory, decodeAsAlphaMask, null);
    }

    @Implementation
    protected static Size nGetSampledSize(long nativePtr, int sampleSize) {
        return ShadowImageDecoder.ImageDecoder_nGetSampledSize(nativePtr, sampleSize);
    }

    @Implementation
    protected static void nGetPadding(long nativePtr, Rect outRect) {
        ShadowImageDecoder.ImageDecoder_nGetPadding(nativePtr, outRect);
    }

    @Implementation
    protected static void nClose(long nativePtr) {
        ShadowImageDecoder.ImageDecoder_nClose(nativePtr);
    }

    @Implementation
    protected static String nGetMimeType(long nativePtr) {
        return ShadowImageDecoder.ImageDecoder_nGetMimeType(nativePtr);
    }

    @Implementation
    protected static ColorSpace nGetColorSpace(long nativePtr) {
        return ShadowImageDecoder.ImageDecoder_nGetColorSpace(nativePtr);
    }

    private static final class CppImageDecoder {
        private final ImgStream imgStream;

        CppImageDecoder(ImgStream imgStream) {
            this.imgStream = imgStream;
        }

        public String getMimeType() {
            return this.imgStream.mimeType();
        }
    }

    private static abstract class ImgStream {
        private final int width;
        private final int height;
        private final boolean animated = false;
        private final boolean ninePatch;
        private final String mimeType;

        ImgStream() {
            InputStream inputStream = this.getInputStream();
            ImageUtil.ImageInfo info = ImageUtil.getImageInfoFromStream(inputStream);
            this.width = info == null ? 10 : info.width;
            this.height = info == null ? 10 : info.height;
            String string = this.mimeType = info == null ? "image/unknown" : info.mimeType;
            if (inputStream instanceof AssetManager.AssetInputStream) {
                ShadowAssetInputStream sis = (ShadowAssetInputStream)Shadow.extract((Object)inputStream);
                this.ninePatch = sis.isNinePatch();
            } else {
                this.ninePatch = false;
            }
        }

        protected abstract InputStream getInputStream();

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        boolean isAnimated() {
            return false;
        }

        boolean isNinePatch() {
            return this.ninePatch;
        }

        String mimeType() {
            return this.mimeType;
        }
    }

    @ForType(value=ImageDecoder.class)
    static interface ImageDecoderReflector {
        @Accessor(value="mInputStream")
        public void setInputStream(InputStream var1);

        @Accessor(value="mOwnsInputStream")
        public void setOwnsInputStream(boolean var1);
    }
}

