/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.le.DistanceMeasurementManager;
import android.bluetooth.le.DistanceMeasurementMethod;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.DistanceMeasurementResult;
import android.bluetooth.le.DistanceMeasurementSession;
import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.ParcelUuid;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=DistanceMeasurementManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowDistanceMeasurementManager {
    private final Map<BluetoothDevice, DistanceMeasurementSession> sessionMap = new HashMap<BluetoothDevice, DistanceMeasurementSession>();
    private final Map<BluetoothDevice, DistanceMeasurementSession.Callback> sessionCallbackMap = new HashMap<BluetoothDevice, DistanceMeasurementSession.Callback>();
    private List<DistanceMeasurementMethod> supportedMethods = new ArrayList<DistanceMeasurementMethod>();

    @Implementation
    protected List<DistanceMeasurementMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    @Implementation
    protected CancellationSignal startMeasurementSession(DistanceMeasurementParams params, Executor executor, DistanceMeasurementSession.Callback callback) {
        Class iDistanceMeasurementClazz = null;
        try {
            iDistanceMeasurementClazz = ReflectionHelpers.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)"android.bluetooth.IDistanceMeasurement");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (iDistanceMeasurementClazz != null && ReflectionHelpers.hasConstructor(DistanceMeasurementSession.class, (Class[])new Class[]{iDistanceMeasurementClazz, ParcelUuid.class, DistanceMeasurementParams.class, Executor.class, AttributionSource.class, DistanceMeasurementSession.Callback.class})) {
            this.sessionMap.put(params.getDevice(), (DistanceMeasurementSession)ReflectionHelpers.callConstructor(DistanceMeasurementSession.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from((Class)iDistanceMeasurementClazz, (Object)ReflectionHelpers.createNullProxy((Class)iDistanceMeasurementClazz)), ReflectionHelpers.ClassParameter.from(ParcelUuid.class, (Object)new ParcelUuid(UUID.randomUUID())), ReflectionHelpers.ClassParameter.from(DistanceMeasurementParams.class, (Object)params), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(AttributionSource.class, (Object)AttributionSource.myAttributionSource()), ReflectionHelpers.ClassParameter.from(DistanceMeasurementSession.Callback.class, (Object)callback)}));
        } else {
            this.sessionMap.put(params.getDevice(), (DistanceMeasurementSession)ReflectionHelpers.callConstructor(DistanceMeasurementSession.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IBluetoothGatt.class, (Object)((IBluetoothGatt)ReflectionHelpers.createNullProxy(IBluetoothGatt.class))), ReflectionHelpers.ClassParameter.from(ParcelUuid.class, (Object)new ParcelUuid(UUID.randomUUID())), ReflectionHelpers.ClassParameter.from(DistanceMeasurementParams.class, (Object)params), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(AttributionSource.class, (Object)AttributionSource.myAttributionSource()), ReflectionHelpers.ClassParameter.from(DistanceMeasurementSession.Callback.class, (Object)callback)}));
        }
        this.sessionCallbackMap.put(params.getDevice(), callback);
        return new CancellationSignal();
    }

    public void simulateOnResult(BluetoothDevice device, DistanceMeasurementResult result) {
        DistanceMeasurementSession session = this.sessionMap.get(device);
        DistanceMeasurementSession.Callback sessionCallback = this.sessionCallbackMap.get(device);
        if (session == null || sessionCallback == null) {
            throw new NoSuchElementException("Session or session callback is missing.");
        }
        sessionCallback.onStarted(session);
        sessionCallback.onResult(device, result);
    }

    public void simulateOnStartFailError(BluetoothDevice device, int error) {
        DistanceMeasurementSession.Callback sessionCallback = this.sessionCallbackMap.get(device);
        if (sessionCallback == null) {
            throw new NoSuchElementException("Session callback is missing.");
        }
        sessionCallback.onStartFail(error);
        this.sessionMap.remove(device);
        this.sessionCallbackMap.remove(device);
    }

    public void simulateOnStoppedError(BluetoothDevice device, int error) {
        DistanceMeasurementSession session = this.sessionMap.get(device);
        DistanceMeasurementSession.Callback sessionCallback = this.sessionCallbackMap.get(device);
        if (session == null || sessionCallback == null) {
            throw new NoSuchElementException("Session or session callback is missing.");
        }
        sessionCallback.onStarted(session);
        sessionCallback.onStopped(session, error);
        this.sessionMap.remove(device);
        this.sessionCallbackMap.remove(device);
    }

    public void simulateSuccessfulTermination(BluetoothDevice device) {
        DistanceMeasurementSession session = this.sessionMap.get(device);
        DistanceMeasurementSession.Callback sessionCallback = this.sessionCallbackMap.get(device);
        if (session == null || sessionCallback == null) {
            throw new NoSuchElementException("Session or session callback is missing.");
        }
        sessionCallback.onStarted(session);
        sessionCallback.onStopped(session, 16);
        this.sessionMap.remove(device);
        this.sessionCallbackMap.remove(device);
    }

    public void simulateTimeout(BluetoothDevice device) {
        DistanceMeasurementSession session = this.sessionMap.get(device);
        DistanceMeasurementSession.Callback sessionCallback = this.sessionCallbackMap.get(device);
        if (session == null || sessionCallback == null) {
            throw new NoSuchElementException("Session or session callback is missing.");
        }
        sessionCallback.onStarted(session);
        sessionCallback.onStopped(session, 15);
        this.sessionMap.remove(device);
        this.sessionCallbackMap.remove(device);
    }

    public void setSupportedMethods(List<DistanceMeasurementMethod> methods) {
        this.supportedMethods = ImmutableList.copyOf(methods);
    }
}

