/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.compat.Compatibility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Compatibility.class, isInAndroidSdk=false, minSdk=30)
public class ShadowCompatibility {
    private static final long CALL_ACTIVITY_RESULT_BEFORE_RESUME = 78294732L;
    private static final long ENFORCE_EDGE_TO_EDGE = 309578419L;
    private static final long ENABLE_CHECKING_TELEPHONY_FEATURES_FOR_VCN = 330902016L;
    private static final ImmutableMap<Long, Integer> ENABLED_SINCE_TARGET_SDK = ImmutableMap.of((Object)309578419L, (Object)35, (Object)330902016L, (Object)35);
    @RealObject
    protected static Compatibility realCompatibility;

    @Implementation(minSdk=32)
    protected static boolean isChangeEnabled(long changeId) {
        if (changeId == 78294732L) {
            return false;
        }
        if (ENABLED_SINCE_TARGET_SDK.containsKey((Object)changeId)) {
            int targetSdkVersion = ShadowCompatibility.getTargetSdkVersion();
            return ShadowCompatibility.isEnabled(changeId, targetSdkVersion);
        }
        return ((CompatibilityReflector)Reflector.reflector(CompatibilityReflector.class)).isChangeEnabled(changeId);
    }

    @VisibleForTesting
    static boolean isEnabled(long flag, int targetSdkVersion) {
        int enabledSince = (Integer)ENABLED_SINCE_TARGET_SDK.get((Object)flag);
        return targetSdkVersion >= enabledSince;
    }

    private static int getTargetSdkVersion() {
        return RuntimeEnvironment.getApplication().getApplicationInfo().targetSdkVersion;
    }

    @ForType(value=Compatibility.class)
    private static interface CompatibilityReflector {
        @Direct
        @Static
        public boolean isChangeEnabled(long var1);
    }
}

