/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.content.ComponentName;
import android.os.ParcelFileDescriptor;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureManager;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.DataShareRequest;
import android.view.contentcapture.DataShareWriteAdapter;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ContentCaptureManager.class, minSdk=29, isInAndroidSdk=false)
public class ShadowContentCaptureManager {
    @Nullable
    private Set<ContentCaptureCondition> contentCaptureConditions;
    @Nullable
    private ComponentName serviceComponentName;
    private boolean isContentCaptureEnabled = false;
    @Nullable
    private ParcelFileDescriptor parcelFileDescriptor;
    private int dataShareErrorCode = -1;
    private boolean shouldRejectRequest = false;

    public void setContentCaptureConditions(@Nonnull Set<ContentCaptureCondition> contentCaptureConditions) {
        this.contentCaptureConditions = contentCaptureConditions;
    }

    public void setServiceComponentName(@Nonnull ComponentName serviceComponentName) {
        this.serviceComponentName = serviceComponentName;
    }

    public void setIsContentCaptureEnabled(boolean isContentCaptureEnabled) {
        this.isContentCaptureEnabled = isContentCaptureEnabled;
    }

    @RequiresApi(value=30)
    public void setDataShareErrorCode(int dataShareErrorCode) {
        this.dataShareErrorCode = dataShareErrorCode;
    }

    @RequiresApi(value=30)
    public void setShouldRejectRequest(boolean shouldRejectRequest) {
        this.shouldRejectRequest = shouldRejectRequest;
    }

    @RequiresApi(value=30)
    public void setShareDataParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
        this.parcelFileDescriptor = parcelFileDescriptor;
    }

    @Nullable
    @Implementation
    protected Set<ContentCaptureCondition> getContentCaptureConditions() {
        return this.contentCaptureConditions;
    }

    @Nullable
    @Implementation
    protected ComponentName getServiceComponentName() {
        return this.serviceComponentName;
    }

    @Implementation
    protected boolean isContentCaptureEnabled() {
        return this.isContentCaptureEnabled;
    }

    @Implementation
    protected void setContentCaptureEnabled(boolean enabled) {
        this.isContentCaptureEnabled = enabled;
    }

    @Implementation
    protected void removeData(DataRemovalRequest request) {
    }

    @Implementation(minSdk=30)
    protected void shareData(DataShareRequest request, Executor executor, DataShareWriteAdapter dataShareWriteAdapter) {
        if (this.shouldRejectRequest) {
            dataShareWriteAdapter.onRejected();
            return;
        }
        if (this.dataShareErrorCode >= 0) {
            dataShareWriteAdapter.onError(this.dataShareErrorCode);
            return;
        }
        dataShareWriteAdapter.onWrite(this.parcelFileDescriptor);
    }
}

