/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.GraphicsMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.ShadowPicker;

public class GraphicsShadowPicker<T>
implements ShadowPicker<T> {
    private final Class<? extends T> legacyShadowClass;
    private final Class<? extends T> nativeShadowClass;

    public GraphicsShadowPicker(Class<? extends T> legacyShadowClass, Class<? extends T> nativeShadowClass) {
        this.legacyShadowClass = legacyShadowClass;
        this.nativeShadowClass = nativeShadowClass;
    }

    public Class<? extends T> pickShadowClass() {
        if (RuntimeEnvironment.getApiLevel() >= this.getMinApiLevel() && ConfigurationRegistry.get(GraphicsMode.Mode.class) == GraphicsMode.Mode.NATIVE) {
            return this.nativeShadowClass;
        }
        return this.legacyShadowClass;
    }

    protected int getMinApiLevel() {
        return 26;
    }
}

