/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.telephony.CellIdentityGsm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@RequiresApi(value=29)
public class CellIdentityGsmBuilder {
    private int lac = Integer.MAX_VALUE;
    private int cid = Integer.MAX_VALUE;
    private int bsic = Integer.MAX_VALUE;
    private int arfcn = Integer.MAX_VALUE;
    private List<String> additionalPlmns = new ArrayList<String>();
    @Nullable
    private String mccStr = null;
    @Nullable
    private String mncStr = null;
    @Nullable
    private String alphal = null;
    @Nullable
    private String alphas = null;

    private CellIdentityGsmBuilder() {
    }

    public static CellIdentityGsmBuilder newBuilder() {
        return new CellIdentityGsmBuilder();
    }

    @RequiresApi(value=30)
    protected static CellIdentityGsm getDefaultInstance() {
        return ((CellIdentityGsmReflector)Reflector.reflector(CellIdentityGsmReflector.class)).newCellIdentityGsm();
    }

    public CellIdentityGsmBuilder setLac(int lac) {
        this.lac = lac;
        return this;
    }

    public CellIdentityGsmBuilder setCid(int cid) {
        this.cid = cid;
        return this;
    }

    public CellIdentityGsmBuilder setBsic(int bsic) {
        this.bsic = bsic;
        return this;
    }

    public CellIdentityGsmBuilder setArfcn(int arfcn) {
        this.arfcn = arfcn;
        return this;
    }

    public CellIdentityGsmBuilder setMcc(String mcc) {
        this.mccStr = mcc;
        return this;
    }

    public CellIdentityGsmBuilder setMnc(String mnc) {
        this.mncStr = mnc;
        return this;
    }

    public CellIdentityGsmBuilder setOperatorAlphaLong(String operatorAlphaLong) {
        this.alphal = operatorAlphaLong;
        return this;
    }

    public CellIdentityGsmBuilder setOperatorAlphaShort(String operatorAlphaShort) {
        this.alphas = operatorAlphaShort;
        return this;
    }

    public CellIdentityGsmBuilder setAdditionalPlmns(List<String> additionalPlmns) {
        this.additionalPlmns = additionalPlmns;
        return this;
    }

    public CellIdentityGsm build() {
        CellIdentityGsmReflector cellIdentityReflector = (CellIdentityGsmReflector)Reflector.reflector(CellIdentityGsmReflector.class);
        if (RuntimeEnvironment.getApiLevel() < 24) {
            int mcc = CellIdentityGsmBuilder.parseInt(this.mccStr, Integer.MAX_VALUE);
            int mnc = CellIdentityGsmBuilder.parseInt(this.mncStr, Integer.MAX_VALUE);
            return cellIdentityReflector.newCellIdentityGsm(mcc, mnc, this.lac, this.cid);
        }
        if (RuntimeEnvironment.getApiLevel() < 28) {
            int mcc = CellIdentityGsmBuilder.parseInt(this.mccStr, Integer.MAX_VALUE);
            int mnc = CellIdentityGsmBuilder.parseInt(this.mncStr, Integer.MAX_VALUE);
            return cellIdentityReflector.newCellIdentityGsm(mcc, mnc, this.lac, this.cid, this.arfcn, this.bsic);
        }
        if (RuntimeEnvironment.getApiLevel() < 30) {
            return cellIdentityReflector.newCellIdentityGsm(this.lac, this.cid, this.arfcn, this.bsic, this.mccStr, this.mncStr, this.alphal, this.alphas);
        }
        return cellIdentityReflector.newCellIdentityGsm(this.lac, this.cid, this.arfcn, this.bsic, this.mccStr, this.mncStr, this.alphal, this.alphas, this.additionalPlmns);
    }

    private static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse integer from string: " + str, e);
        }
    }

    @ForType(value=CellIdentityGsm.class)
    private static interface CellIdentityGsmReflector {
        @Constructor
        public CellIdentityGsm newCellIdentityGsm();

        @Constructor
        public CellIdentityGsm newCellIdentityGsm(int var1, int var2, int var3, int var4);

        @Constructor
        public CellIdentityGsm newCellIdentityGsm(int var1, int var2, int var3, int var4, int var5, int var6);

        @Constructor
        public CellIdentityGsm newCellIdentityGsm(int var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8);

        @Constructor
        public CellIdentityGsm newCellIdentityGsm(int var1, int var2, int var3, int var4, String var5, String var6, String var7, String var8, Collection<String> var9);
    }
}

