/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Dialog;
import android.app.VoiceInteractor;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.voice.VoiceInteractionSession;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=VoiceInteractionSession.class)
public class ShadowVoiceInteractionSession {
    private final List<Intent> assistantActivityIntents = new ArrayList<Intent>();
    private final List<Intent> voiceActivityIntents = new ArrayList<Intent>();
    private boolean isFinishing;
    @Nullable
    private RuntimeException startVoiceActivityException;
    @Nullable
    private RuntimeException startAssistantActivityException;
    @RealObject
    private VoiceInteractionSession realSession;

    public void create() {
        try {
            Class<?> serviceClass = Class.forName("com.android.internal.app.IVoiceInteractionManagerService");
            Object service = ReflectionHelpers.createDelegatingProxy(serviceClass, (Object)new FakeVoiceInteractionManagerService());
            Binder token = new Binder();
            ReflectionHelpers.callInstanceMethod((Object)this.realSession, (String)"doCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(serviceClass, (Object)service), ReflectionHelpers.ClassParameter.from(IBinder.class, (Object)token)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Intent getLastAssistantActivityIntent() {
        return (Intent)Iterables.getLast(this.assistantActivityIntents, null);
    }

    public ImmutableList<Intent> getAssistantActivityIntents() {
        return ImmutableList.copyOf(this.assistantActivityIntents);
    }

    @Nullable
    public Intent getLastVoiceActivityIntent() {
        return (Intent)Iterables.getLast(this.voiceActivityIntents, null);
    }

    public ImmutableList<Intent> getVoiceActivityIntents() {
        return ImmutableList.copyOf(this.voiceActivityIntents);
    }

    public boolean isWindowVisible() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realSession, (String)"mWindowVisible");
    }

    public boolean isWindowShowing() {
        Dialog window = (Dialog)ReflectionHelpers.getField((Object)this.realSession, (String)"mWindow");
        return this.isWindowVisible() && window != null && window.isShowing();
    }

    public boolean isUiEnabled() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realSession, (String)"mUiEnabled");
    }

    public boolean isFinishing() {
        return this.isFinishing;
    }

    public void setStartVoiceActivityException(RuntimeException exception) {
        this.startVoiceActivityException = exception;
    }

    public void setStartAssistantActivityException(RuntimeException exception) {
        this.startAssistantActivityException = exception;
    }

    public VoiceInteractionSession.CommandRequest sendCommandRequest(@Nonnull VoiceInteractor.CommandRequest commandRequest, @Nonnull String packageName, int uid) {
        String command = (String)ReflectionHelpers.getField((Object)commandRequest, (String)"mCommand");
        Bundle extras = (Bundle)ReflectionHelpers.getField((Object)commandRequest, (String)"mArgs");
        ShadowVoiceInteractorCallback callback = new ShadowVoiceInteractorCallback(commandRequest);
        VoiceInteractionSession.CommandRequest internalCommandRequest = this.createCommandRequest(packageName, uid, callback, command, extras);
        this.realSession.onRequestCommand(internalCommandRequest);
        return internalCommandRequest;
    }

    private VoiceInteractionSession.CommandRequest createCommandRequest(@Nonnull String packageName, int uid, @Nonnull IVoiceInteractorCallback callback, @Nonnull String command, @Nonnull Bundle extras) {
        VoiceInteractionSession.CommandRequest commandRequest = (VoiceInteractionSession.CommandRequest)ReflectionHelpers.callConstructor(VoiceInteractionSession.CommandRequest.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)packageName), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)uid), ReflectionHelpers.ClassParameter.from(IVoiceInteractorCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(VoiceInteractionSession.class, (Object)this.realSession), ReflectionHelpers.ClassParameter.from(String.class, (Object)command), ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)extras)});
        ReflectionHelpers.callInstanceMethod((Object)this.realSession, (String)"addRequest", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(VoiceInteractionSession.Request.class, (Object)commandRequest)});
        return commandRequest;
    }

    private class FakeVoiceInteractionManagerService {
        private FakeVoiceInteractionManagerService() {
        }

        public boolean showSessionFromSession(IBinder token, Bundle args, int flags) {
            return this.showSessionFromSessionImpl(args, flags);
        }

        public boolean showSessionFromSession(IBinder token, Bundle args, int flags, String attributionTag) {
            return this.showSessionFromSessionImpl(args, flags);
        }

        private boolean showSessionFromSessionImpl(Bundle args, int flags) {
            try {
                Class<?> callbackClass = Class.forName("com.android.internal.app.IVoiceInteractionSessionShowCallback");
                Object callback = ReflectionHelpers.createDeepProxy(callbackClass);
                ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doShow", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)args), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(callbackClass, (Object)callback)});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public boolean hideSessionFromSession(IBinder token) {
            ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doHide", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            return true;
        }

        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType) {
            return this.startVoiceActivityImpl(intent);
        }

        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType, String callingFeatureId) {
            return this.startVoiceActivityImpl(intent);
        }

        private int startVoiceActivityImpl(Intent intent) {
            RuntimeException exception = ShadowVoiceInteractionSession.this.startVoiceActivityException;
            if (exception != null) {
                throw exception;
            }
            ShadowVoiceInteractionSession.this.voiceActivityIntents.add(intent);
            return 0;
        }

        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType) {
            return this.startAssistantActivityImpl(intent);
        }

        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType, String callingFeatureId) {
            return this.startAssistantActivityImpl(intent);
        }

        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType, String callingFeatureId, Bundle bundle) {
            return this.startAssistantActivityImpl(intent);
        }

        private int startAssistantActivityImpl(Intent intent) {
            RuntimeException exception = ShadowVoiceInteractionSession.this.startAssistantActivityException;
            if (exception != null) {
                throw exception;
            }
            ShadowVoiceInteractionSession.this.assistantActivityIntents.add(intent);
            return 0;
        }

        public void finish(IBinder token) {
            ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doDestroy", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ShadowVoiceInteractionSession.this.isFinishing = true;
        }
    }

    private static class ShadowVoiceInteractorCallback
    implements IVoiceInteractorCallback {
        private final VoiceInteractor.CommandRequest commandRequest;

        ShadowVoiceInteractorCallback(VoiceInteractor.CommandRequest commandRequest) {
            this.commandRequest = commandRequest;
        }

        public void deliverConfirmationResult(IVoiceInteractorRequest request, boolean confirmed, Bundle result) throws RemoteException {
        }

        public void deliverPickOptionResult(IVoiceInteractorRequest request, boolean finished, VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) throws RemoteException {
        }

        public void deliverCompleteVoiceResult(IVoiceInteractorRequest request, Bundle result) throws RemoteException {
        }

        public void deliverAbortVoiceResult(IVoiceInteractorRequest request, Bundle result) throws RemoteException {
        }

        public void deliverCommandResult(IVoiceInteractorRequest request, boolean finished, Bundle result) throws RemoteException {
            this.commandRequest.onCommandResult(finished, result);
        }

        public void deliverCancel(IVoiceInteractorRequest request) throws RemoteException {
            this.commandRequest.onCancel();
        }

        public void destroy() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

