/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.UserHandle;
import android.os.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowProcess;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=UserManager.class)
public class ShadowUserManager {
    public static final int DEFAULT_SECONDARY_USER_ID = 10;
    private static final int DEFAULT_MAX_SUPPORTED_USERS = 1;
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_ADMIN = 2;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_DEMO = 512;
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_PROFILE = 4096;
    public static final int FLAG_FULL = 1024;
    public static final int FLAG_SYSTEM = 2048;
    public static final int FLAG_MAIN = 16384;
    private final Object lock = new Object();
    @RealObject
    private UserManager realObject;
    private static UserManagerState userManagerState = new UserManagerState();
    private Context context;

    private Context getContext() {
        return this.context;
    }

    @Implementation
    protected void __constructor__(Context context, IUserManager service) {
        Shadow.invokeConstructor(UserManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IUserManager.class, (Object)service)});
        this.context = context;
    }

    @Implementation
    protected Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = (Bundle)userManagerState.applicationRestrictions.get(packageName);
        return bundle != null ? bundle : new Bundle();
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions) {
        userManagerState.applicationRestrictions.put(packageName, restrictions);
    }

    @Deprecated
    public long addUserProfile(UserHandle userHandle) {
        this.addProfile(UserHandle.myUserId(), userHandle.getIdentifier(), "", 0);
        return (Long)userManagerState.userSerialNumbers.get((Object)userHandle.getIdentifier());
    }

    @Implementation
    protected List<UserHandle> getUserProfiles() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        List profiles = (List)userManagerState.userProfilesListMap.get(UserHandle.myUserId());
        if (profiles != null) {
            return builder.addAll((Iterable)profiles).build();
        }
        for (List profileList : userManagerState.userProfilesListMap.values()) {
            if (!profileList.contains(Process.myUserHandle())) continue;
            return builder.addAll((Iterable)profileList).build();
        }
        return ImmutableList.of((Object)Process.myUserHandle());
    }

    @Implementation
    protected List<UserInfo> getProfiles(int userHandle) {
        if (userManagerState.userProfilesListMap.containsKey(userHandle)) {
            ArrayList<UserInfo> infos = new ArrayList<UserInfo>();
            for (UserHandle profileHandle : (List)userManagerState.userProfilesListMap.get(userHandle)) {
                infos.add((UserInfo)userManagerState.userInfoMap.get(profileHandle.getIdentifier()));
            }
            return infos;
        }
        return ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).getProfiles(userHandle);
    }

    @Implementation(minSdk=30)
    protected List<UserHandle> getEnabledProfiles() {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        for (UserHandle profileHandle : this.getAllProfiles()) {
            if (!((UserInfo)userManagerState.userInfoMap.get(profileHandle.getIdentifier())).isEnabled()) continue;
            userHandles.add(profileHandle);
        }
        return userHandles;
    }

    @Implementation(minSdk=30)
    protected List<UserHandle> getAllProfiles() {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        if (userManagerState.userProfilesListMap.containsKey(this.getContext().getUserId())) {
            userHandles.addAll((Collection)userManagerState.userProfilesListMap.get(this.getContext().getUserId()));
            return userHandles;
        }
        userHandles.add(UserHandle.of((int)this.getContext().getUserId()));
        return userHandles;
    }

    @Implementation
    protected UserInfo getProfileParent(int userId) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("Requires MANAGE_USERS permission");
        }
        UserInfo profile = this.getUserInfo(userId);
        if (profile == null) {
            return null;
        }
        int parentUserId = profile.profileGroupId;
        if (parentUserId == userId || parentUserId == -10000) {
            return null;
        }
        return this.getUserInfo(parentUserId);
    }

    @Implementation(minSdk=30)
    protected UserHandle createProfile(String name, String userType, Set<String> disallowedPackages) {
        int flags = ShadowUserManager.getDefaultUserTypeFlags(userType);
        flags |= 0x1000;
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission() && !this.hasCreateUsersPermission()) {
            throw new SecurityException("You either need MANAGE_USERS or CREATE_USERS permission to create a user with flags: " + flags);
        }
        if (userManagerState.userInfoMap.size() >= ShadowUserManager.getMaxSupportedUsers()) {
            return null;
        }
        int profileId = userManagerState.nextUserId++;
        this.addProfile(this.getContext().getUserId(), profileId, name, flags);
        ((UserInfo)((UserManagerState)ShadowUserManager.userManagerState).userInfoMap.get((Object)Integer.valueOf((int)profileId))).userType = userType;
        return UserHandle.of((int)profileId);
    }

    private static int getDefaultUserTypeFlags(String userType) {
        switch (userType) {
            case "android.os.usertype.profile.MANAGED": {
                return 4128;
            }
            case "android.os.usertype.full.SECONDARY": {
                return 1024;
            }
            case "android.os.usertype.full.GUEST": {
                return 1028;
            }
            case "android.os.usertype.full.DEMO": {
                return 1536;
            }
            case "android.os.usertype.full.RESTRICTED": {
                return 1032;
            }
            case "android.os.usertype.full.SYSTEM": {
                return 3072;
            }
            case "android.os.usertype.system.HEADLESS": {
                return 2048;
            }
        }
        return 0;
    }

    public void addProfile(int userHandle, int profileUserHandle, String profileName, int profileFlags) {
        UserInfo profileUserInfo = new UserInfo(profileUserHandle, profileName, profileFlags);
        this.addProfile(userHandle, profileUserHandle, profileUserInfo);
    }

    public void addProfile(int userHandle, int profileUserHandle, UserInfo profileUserInfo) {
        if (!userManagerState.userSerialNumbers.containsKey((Object)profileUserHandle)) {
            userManagerState.userSerialNumbers.put((Object)profileUserHandle, (Object)profileUserHandle);
        }
        profileUserInfo.profileGroupId = userHandle;
        UserInfo parentUserInfo = this.getUserInfo(userHandle);
        if (parentUserInfo != null) {
            parentUserInfo.profileGroupId = userHandle;
        }
        userManagerState.userInfoMap.put(profileUserHandle, profileUserInfo);
        userManagerState.userProfilesListMap.putIfAbsent(userHandle, new ArrayList());
        List list = (List)userManagerState.userProfilesListMap.get(userHandle);
        UserHandle handle = new UserHandle(profileUserHandle);
        if (!list.contains(handle)) {
            list.add(handle);
        }
    }

    public void setUserUnlocked(boolean userUnlocked) {
        userManagerState.userUnlocked = userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked() {
        return userManagerState.userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_UNLOCKED;
    }

    @Implementation
    protected boolean isManagedProfile() {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        if (userManagerState.managedProfile != null) {
            return userManagerState.managedProfile;
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return this.isManagedProfile(this.getContext().getUserId());
        }
        return false;
    }

    @Implementation(minSdk=24)
    protected boolean isManagedProfile(int userHandle) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        UserInfo info = this.getUserInfo(userHandle);
        return info != null && (info.flags & 0x20) == 32;
    }

    public void enforcePermissionChecks(boolean enforcePermissions) {
        userManagerState.enforcePermissions = enforcePermissions;
    }

    public void setManagedProfile(boolean managedProfile) {
        userManagerState.managedProfile = managedProfile;
    }

    @Implementation(minSdk=31)
    protected boolean isCloneProfile() {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check isCloneProfile");
        }
        if (userManagerState.cloneProfile != null) {
            return userManagerState.cloneProfile;
        }
        UserInfo info = this.getUserInfo(this.getContext().getUserId());
        return info != null && info.isCloneProfile();
    }

    public void setCloneProfile(boolean cloneProfile) {
        userManagerState.cloneProfile = cloneProfile;
    }

    @Implementation(minSdk=30)
    protected boolean isProfile() {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need INTERACT_ACROSS_USERS or MANAGE_USERS permission to: check isProfile");
        }
        return this.getUserInfo(this.getContext().getUserId()).isProfile();
    }

    @Implementation(minSdk=30)
    protected boolean isUserOfType(String userType) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check user type");
        }
        UserInfo info = this.getUserInfo(this.getContext().getUserId());
        return info != null && info.userType != null && info.userType.equals(userType);
    }

    @Implementation(minSdk=30)
    protected boolean isSameProfileGroup(UserHandle user, UserHandle otherUser) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if in the same profile group");
        }
        UserInfo userInfo = (UserInfo)userManagerState.userInfoMap.get(user.getIdentifier());
        UserInfo otherUserInfo = (UserInfo)userManagerState.userInfoMap.get(otherUser.getIdentifier());
        if (userInfo == null || otherUserInfo == null || userInfo.profileGroupId == -10000 || otherUserInfo.profileGroupId == -10000) {
            return false;
        }
        return userInfo.profileGroupId == otherUserInfo.profileGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = (Bundle)userManagerState.userRestrictions.get(userHandle.getIdentifier());
            return bundle != null && bundle.getBoolean(restrictionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setUserRestriction(String key, boolean value, UserHandle userHandle) {
        Bundle bundle = this.getUserRestrictionsForUser(userHandle);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean(key, value);
        }
    }

    @Implementation
    protected void setUserRestriction(String key, boolean value) {
        this.setUserRestriction(key, value, Process.myUserHandle());
    }

    @Deprecated
    public void setUserRestriction(UserHandle userHandle, String restrictionKey, boolean value) {
        this.setUserRestriction(restrictionKey, value, userHandle);
    }

    public void clearUserRestrictions(UserHandle userHandle) {
        userManagerState.userRestrictions.remove(userHandle.getIdentifier());
    }

    @Implementation
    protected Bundle getUserRestrictions(UserHandle userHandle) {
        return new Bundle(this.getUserRestrictionsForUser(userHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getUserRestrictionsForUser(UserHandle userHandle) {
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = (Bundle)userManagerState.userRestrictions.get(userHandle.getIdentifier());
            if (bundle == null) {
                bundle = new Bundle();
                userManagerState.userRestrictions.put(userHandle.getIdentifier(), bundle);
            }
            return bundle;
        }
    }

    @Implementation
    protected long getSerialNumberForUser(UserHandle userHandle) {
        Long result = (Long)userManagerState.userSerialNumbers.get((Object)userHandle.getIdentifier());
        return result == null ? -1L : result;
    }

    public void setSerialNumberForUser(UserHandle userHandle, long serialNumber) {
        userManagerState.userSerialNumbers.put((Object)userHandle.getIdentifier(), (Object)serialNumber);
    }

    @Implementation
    protected UserHandle getUserForSerialNumber(long serialNumber) {
        Integer userHandle = (Integer)userManagerState.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? null : new UserHandle(userHandle.intValue());
    }

    @Implementation
    protected int getUserSerialNumber(int userHandle) {
        Long result = (Long)userManagerState.userSerialNumbers.get((Object)userHandle);
        return result != null ? result.intValue() : -1;
    }

    private String getUserName(int userHandle) {
        UserInfo user = this.getUserInfo(userHandle);
        return user == null ? "" : user.name;
    }

    @Implementation(minSdk=29)
    protected String getUserName() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return this.getUserName(this.getContext().getUserId());
        }
        return this.getUserName(UserHandle.myUserId());
    }

    @Implementation(minSdk=30)
    protected void setUserName(String name) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: rename users");
        }
        UserInfo user = this.getUserInfo(this.getContext().getUserId());
        user.name = name;
    }

    @Implementation(minSdk=29)
    protected Bitmap getUserIcon() {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission() && !this.hasGetAccountsPrivilegedPermission()) {
            throw new SecurityException("You need MANAGE_USERS or GET_ACCOUNTS_PRIVILEGED permissions to: get user icon");
        }
        int userId = UserHandle.myUserId();
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            userId = this.getContext().getUserId();
        }
        return (Bitmap)userManagerState.userIcon.get(userId);
    }

    @Implementation(minSdk=29)
    protected void setUserIcon(Bitmap icon) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: update users");
        }
        int userId = UserHandle.myUserId();
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            userId = this.getContext().getUserId();
        }
        userManagerState.userIcon.put(userId, icon);
    }

    @HiddenApi
    @Implementation
    protected int getUserHandle(int serialNumber) {
        Integer userHandle = (Integer)userManagerState.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? -1 : userHandle;
    }

    @HiddenApi
    @Implementation(minSdk=30)
    protected List<UserHandle> getUserHandles(boolean excludeDying) {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        Iterator iterator = userManagerState.userSerialNumbers.keySet().iterator();
        while (iterator.hasNext()) {
            int id2 = (Integer)iterator.next();
            userHandles.addAll((Collection)userManagerState.userProfilesListMap.get(id2));
        }
        return userHandles;
    }

    @HiddenApi
    @Implementation
    protected static int getMaxSupportedUsers() {
        return userManagerState.maxSupportedUsers;
    }

    public void setMaxSupportedUsers(int maxSupportedUsers) {
        userManagerState.maxSupportedUsers = maxSupportedUsers;
    }

    private boolean hasManageUsersPermission() {
        return this.getContext().getPackageManager().checkPermission("android.permission.MANAGE_USERS", this.getContext().getPackageName()) == 0;
    }

    private boolean hasCreateUsersPermission() {
        return this.getContext().getPackageManager().checkPermission("android.permission.CREATE_USERS", this.getContext().getPackageName()) == 0;
    }

    private boolean hasModifyQuietModePermission() {
        return this.getContext().getPackageManager().checkPermission("android.permission.MODIFY_QUIET_MODE", this.getContext().getPackageName()) == 0;
    }

    private boolean hasGetAccountsPrivilegedPermission() {
        return this.getContext().getPackageManager().checkPermission("android.permission.GET_ACCOUNTS_PRIVILEGED", this.getContext().getPackageName()) == 0;
    }

    private void checkPermissions() {
    }

    @Implementation(minSdk=25)
    protected boolean isDemoUser() {
        return this.getUserInfo(UserHandle.myUserId()).isDemo();
    }

    @Deprecated
    public void setIsDemoUser(boolean isDemoUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isDemoUser ? (userInfo.flags |= 0x200) : (userInfo.flags &= 0xFFFFFDFF);
    }

    @Implementation(minSdk=23)
    protected boolean isSystemUser() {
        if (!userManagerState.isSystemUser) {
            return false;
        }
        return ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).isSystemUser();
    }

    @Deprecated
    public void setIsSystemUser(boolean isSystemUser) {
        userManagerState.isSystemUser = isSystemUser;
    }

    @Deprecated
    public void setIsPrimaryUser(boolean isPrimaryUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isPrimaryUser ? (userInfo.flags |= 1) : (userInfo.flags &= 0xFFFFFFFE);
    }

    @Implementation
    protected boolean isLinkedUser() {
        return this.isRestrictedProfile();
    }

    @Deprecated
    public void setIsLinkedUser(boolean isLinkedUser) {
        this.setIsRestrictedProfile(isLinkedUser);
    }

    @Implementation(minSdk=28)
    protected boolean isRestrictedProfile() {
        return this.getUserInfo(UserHandle.myUserId()).isRestricted();
    }

    @Deprecated
    public void setIsRestrictedProfile(boolean isRestrictedProfile) {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            this.setUserType(isRestrictedProfile ? "android.os.usertype.full.RESTRICTED" : "android.os.usertype.full.SECONDARY");
            return;
        }
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isRestrictedProfile ? (userInfo.flags |= 8) : (userInfo.flags &= 0xFFFFFFF7);
    }

    @Deprecated
    public void setIsGuestUser(boolean isGuestUser) {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            this.setUserType(isGuestUser ? "android.os.usertype.full.GUEST" : "android.os.usertype.full.SECONDARY");
            return;
        }
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isGuestUser ? (userInfo.flags |= 4) : (userInfo.flags &= 0xFFFFFFFB);
    }

    public void setIsUserEnabled(int userId, boolean enabled) {
        UserInfo userInfo = this.getUserInfo(userId);
        userInfo.flags = enabled ? (userInfo.flags &= 0xFFFFFFBF) : (userInfo.flags |= 0x40);
    }

    @Implementation
    protected boolean isUserRunning(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING;
    }

    @Implementation
    protected boolean isUserRunningOrStopping(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_STOPPING;
    }

    @Implementation(minSdk=30)
    protected boolean isUserUnlockingOrUnlocked(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_RUNNING_UNLOCKED;
    }

    public void setUserState(UserHandle handle, UserState state) {
        userManagerState.userState.put(handle.getIdentifier(), state);
    }

    @Implementation(minSdk=24)
    protected boolean isQuietModeEnabled(UserHandle userHandle) {
        if (!this.isManagedProfileWithoutPermission(userHandle)) {
            return false;
        }
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return (info.flags & 0x80) == 128;
    }

    @Implementation(minSdk=29)
    protected boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle) {
        if (userManagerState.enforcePermissions && !this.hasManageUsersPermission() && !this.hasModifyQuietModePermission()) {
            throw new SecurityException("Requires MANAGE_USERS or MODIFY_QUIET_MODE permission");
        }
        Preconditions.checkArgument((boolean)this.isManagedProfileWithoutPermission(userHandle));
        int userProfileHandle = userHandle.getIdentifier();
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        if (enableQuietMode) {
            userManagerState.userState.put(userProfileHandle, UserState.STATE_SHUTDOWN);
            info.flags |= 0x80;
        } else {
            if (userManagerState.profileIsLocked.getOrDefault(userProfileHandle, false).booleanValue()) {
                return false;
            }
            userManagerState.userState.put(userProfileHandle, UserState.STATE_RUNNING_UNLOCKED);
            info.flags &= 0xFFFFFF7F;
        }
        if (enableQuietMode) {
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_UNAVAILABLE", userHandle);
        } else {
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_AVAILABLE", userHandle);
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_UNLOCKED", userHandle);
        }
        return true;
    }

    protected void sendQuietModeBroadcast(String action, UserHandle profileHandle) {
        Intent intent = new Intent(action);
        intent.putExtra("android.intent.extra.USER", (Parcelable)profileHandle);
        intent.setFlags(0x50000000);
        this.getContext().sendBroadcast(intent);
    }

    private boolean isManagedProfileWithoutPermission(UserHandle userHandle) {
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return info != null && (info.flags & 0x20) == 32;
    }

    public void setProfileIsLocked(UserHandle profileHandle, boolean isLocked) {
        userManagerState.profileIsLocked.put(profileHandle.getIdentifier(), isLocked);
    }

    @Implementation(minSdk=24)
    protected long[] getSerialNumbersOfUsers(boolean excludeDying) {
        return this.getUsers().stream().map(userInfo -> this.getUserSerialNumber(userInfo.getUserHandle().getIdentifier())).mapToLong(l -> l.intValue()).toArray();
    }

    @Implementation
    protected List<UserInfo> getUsers() {
        return new ArrayList<UserInfo>(userManagerState.userInfoMap.values());
    }

    @Implementation
    protected UserInfo getUserInfo(int userHandle) {
        return (UserInfo)userManagerState.userInfoMap.get(userHandle);
    }

    @Deprecated
    public void setCanSwitchUser(boolean canSwitchUser) {
        this.setUserSwitchability(canSwitchUser ? 0 : 2);
    }

    @Implementation(minSdk=24)
    protected String getSeedAccountName() {
        return userManagerState.seedAccountName;
    }

    public void setSeedAccountName(String seedAccountName) {
        userManagerState.seedAccountName = seedAccountName;
    }

    @Implementation(minSdk=24)
    protected String getSeedAccountType() {
        return userManagerState.seedAccountType;
    }

    public void setSeedAccountType(String seedAccountType) {
        userManagerState.seedAccountType = seedAccountType;
    }

    @Implementation(minSdk=24)
    protected PersistableBundle getSeedAccountOptions() {
        return userManagerState.seedAccountOptions;
    }

    public void setSeedAccountOptions(PersistableBundle seedAccountOptions) {
        userManagerState.seedAccountOptions = seedAccountOptions;
    }

    @Implementation(minSdk=24)
    protected void clearSeedAccountData() {
        userManagerState.seedAccountName = null;
        userManagerState.seedAccountType = null;
        userManagerState.seedAccountOptions = null;
    }

    @Implementation
    protected boolean removeUser(int userHandle) {
        List list;
        if (!userManagerState.userInfoMap.containsKey(userHandle)) {
            return false;
        }
        userManagerState.userInfoMap.remove(userHandle);
        userManagerState.userPidMap.remove(userHandle);
        userManagerState.userSerialNumbers.remove((Object)userHandle);
        userManagerState.userState.remove(userHandle);
        userManagerState.userRestrictions.remove(userHandle);
        userManagerState.profileIsLocked.remove(userHandle);
        userManagerState.userIcon.remove(userHandle);
        userManagerState.userProfilesListMap.remove(userHandle);
        UserHandle profileHandle = new UserHandle(userHandle);
        Iterator iterator = userManagerState.userProfilesListMap.values().iterator();
        while (iterator.hasNext() && !(list = (List)iterator.next()).remove(profileHandle)) {
        }
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean removeUser(UserHandle user) {
        return this.removeUser(user.getIdentifier());
    }

    @Implementation(minSdk=33)
    protected int removeUserWhenPossible(UserHandle user, boolean overrideDevicePolicy) {
        return this.removeUser(user.getIdentifier()) ? 0 : -1;
    }

    @Implementation(minSdk=24)
    protected static boolean supportsMultipleUsers() {
        return userManagerState.isMultiUserSupported;
    }

    public void setSupportsMultipleUsers(boolean isMultiUserSupported) {
        userManagerState.isMultiUserSupported = isMultiUserSupported;
    }

    public void switchUser(int userId) {
        if (!userManagerState.userInfoMap.containsKey(userId)) {
            throw new UnsupportedOperationException("Must add user before switching to it");
        }
        ShadowProcess.setUid((Integer)userManagerState.userPidMap.get(userId));
        Application application = (Application)this.getContext().getApplicationContext();
        ShadowContextImpl shadowContext = (ShadowContextImpl)Shadow.extract((Object)application.getBaseContext());
        shadowContext.setUserId(userId);
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).setUserId(userId);
        }
    }

    public UserHandle addUser(int id2, String name, int flags) {
        UserHandle userHandle;
        UserHandle userHandle2 = userHandle = id2 == 0 ? Process.myUserHandle() : new UserHandle(id2);
        if (!userManagerState.userSerialNumbers.containsKey((Object)id2)) {
            userManagerState.userSerialNumbers.put((Object)id2, (Object)id2);
        }
        userManagerState.userState.put(id2, UserState.STATE_SHUTDOWN);
        userManagerState.userInfoMap.put(id2, new UserInfo(id2, name, flags));
        if (!userManagerState.userProfilesListMap.containsKey(id2)) {
            userManagerState.userProfilesListMap.put(id2, new ArrayList());
            ((List)userManagerState.userProfilesListMap.get(id2)).add(new UserHandle(id2));
            userManagerState.userPidMap.put(id2, id2 == 0 ? Process.myUid() : id2 * 100000 + ShadowProcess.getRandomApplicationUid());
        }
        return userHandle;
    }

    @Implementation(minSdk=24, maxSdk=29)
    protected boolean canSwitchUsers() {
        return this.getUserSwitchability() == 0;
    }

    @Implementation(minSdk=29)
    protected int getUserSwitchability() {
        return userManagerState.userSwitchability;
    }

    public void setUserSwitchability(int switchability) {
        userManagerState.userSwitchability = switchability;
    }

    @Implementation(minSdk=30)
    protected boolean hasUserRestrictionForUser(String restrictionKey, UserHandle userHandle) {
        return this.hasUserRestriction(restrictionKey, userHandle);
    }

    private void setUserType(String userType) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.userType = userType;
    }

    @Implementation(minSdk=30)
    protected boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle, int flags) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle);
    }

    @Implementation(minSdk=31)
    protected static boolean isHeadlessSystemUserMode() {
        return userManagerState.isHeadlessSystemUserMode;
    }

    public static void setHeadlessSystemUserMode(boolean isEnabled) {
        userManagerState.isHeadlessSystemUserMode = isEnabled;
    }

    @Implementation(minSdk=33)
    protected Bundle getUserRestrictions() {
        return this.getUserRestrictions(UserHandle.getUserHandleForUid((int)Process.myUid()));
    }

    @Implementation(minSdk=33)
    protected boolean hasUserRestrictionForUser(String restrictionKey, int userId) {
        Bundle bundle = this.getUserRestrictions(UserHandle.getUserHandleForUid((int)userId));
        return bundle != null && bundle.getBoolean(restrictionKey);
    }

    @Resetter
    public static void reset() {
        userManagerState = new UserManagerState();
    }

    @Implementation(minSdk=33)
    protected boolean someUserHasAccount(String accountName, String accountType) {
        return userManagerState.userAccounts.contains(new Account(accountName, accountType));
    }

    public void setSomeUserHasAccount(String accountName, String accountType) {
        userManagerState.userAccounts.add(new Account(accountName, accountType));
    }

    public void removeSomeUserHasAccount(String accountName, String accountType) {
        userManagerState.userAccounts.remove(new Account(accountName, accountType));
    }

    public void setUserForeground(boolean foreground) {
        userManagerState.isForegroundUser = foreground;
    }

    @Implementation(minSdk=31)
    protected boolean isUserForeground() {
        return userManagerState.isForegroundUser;
    }

    @Implementation(minSdk=26)
    protected List<UserManager.EnforcingUser> getUserRestrictionSources(String restriction, UserHandle userHandle) {
        ArrayList<UserManager.EnforcingUser> sources = new ArrayList<UserManager.EnforcingUser>();
        if (this.hasUserRestriction(restriction, userHandle)) {
            sources.add(new UserManager.EnforcingUser(userHandle.getIdentifier(), 1));
        }
        return sources;
    }

    static class UserManagerState {
        private int maxSupportedUsers = 1;
        private boolean isMultiUserSupported = false;
        private boolean isHeadlessSystemUserMode = false;
        private Boolean managedProfile;
        private Boolean cloneProfile;
        private boolean userUnlocked = true;
        private boolean isSystemUser = true;
        private volatile boolean isForegroundUser = true;
        private String seedAccountName;
        private String seedAccountType;
        private PersistableBundle seedAccountOptions;
        private boolean enforcePermissions;
        private int userSwitchability = 0;
        private final Set<Account> userAccounts = new HashSet<Account>();
        private final Map<Integer, Integer> userPidMap = new HashMap<Integer, Integer>();
        private final BiMap<Integer, Long> userSerialNumbers = HashBiMap.create();
        private final Map<Integer, UserState> userState = new HashMap<Integer, UserState>();
        private final Map<Integer, UserInfo> userInfoMap = new HashMap<Integer, UserInfo>();
        private final Map<Integer, List<UserHandle>> userProfilesListMap = new HashMap<Integer, List<UserHandle>>();
        private final Map<Integer, Bundle> userRestrictions = new HashMap<Integer, Bundle>();
        private final Map<String, Bundle> applicationRestrictions = new HashMap<String, Bundle>();
        private final Map<Integer, Boolean> profileIsLocked = new HashMap<Integer, Boolean>();
        private final Map<Integer, Bitmap> userIcon = new HashMap<Integer, Bitmap>();
        private int nextUserId = 10;

        public UserManagerState() {
            int id2 = 0;
            String name = "system_user";
            int flags = 16387;
            this.userSerialNumbers.put((Object)id2, (Object)id2);
            this.userState.put(id2, UserState.STATE_SHUTDOWN);
            this.userInfoMap.put(id2, new UserInfo(id2, name, flags));
            this.userProfilesListMap.put(id2, new ArrayList());
            this.userProfilesListMap.get(id2).add(new UserHandle(id2));
            this.userPidMap.put(id2, Process.myUid());
        }
    }

    @ForType(value=UserManager.class)
    static interface UserManagerReflector {
        @Direct
        public List getProfiles(int var1);

        @Direct
        public boolean isSystemUser();

        @Accessor(value="mUserId")
        public void setUserId(int var1);
    }

    public static enum UserState {
        STATE_BOOTING,
        STATE_RUNNING_LOCKED,
        STATE_RUNNING_UNLOCKING,
        STATE_RUNNING_UNLOCKED,
        STATE_STOPPING,
        STATE_SHUTDOWN;

    }
}

