/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.Nullable;
import android.annotation.TargetApi;
import android.content.Intent;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.ParcelFileDescriptor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;

@Implements(value=UsbManager.class)
public class ShadowUsbManager {
    @RealObject
    private UsbManager realUsbManager;
    private static final HashMap<String, List<UsbDevice>> grantedDevicePermissions = new HashMap();
    private static final HashMap<String, List<UsbAccessory>> grantedAccessoryPermissions = new HashMap();
    private static final HashMap<String, UsbDevice> usbDevices = new HashMap();
    private static final HashMap<String, UsbPort> usbPorts = new HashMap();
    private static final HashMap<UsbPort, UsbPortStatus> usbPortStatuses = new HashMap();
    private static UsbAccessory attachedUsbAccessory = null;

    @Resetter
    public static void reset() {
        grantedDevicePermissions.clear();
        grantedAccessoryPermissions.clear();
        usbDevices.clear();
        usbPorts.clear();
        usbPortStatuses.clear();
        attachedUsbAccessory = null;
    }

    @Implementation
    protected boolean hasPermission(UsbDevice device) {
        return this.hasPermissionForPackage(device, RuntimeEnvironment.getApplication().getPackageName());
    }

    public boolean hasPermissionForPackage(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = grantedDevicePermissions.get(packageName);
        return usbDevices != null && usbDevices.contains(device);
    }

    @Implementation
    protected boolean hasPermission(UsbAccessory accessory) {
        return this.hasPermissionForPackage(accessory, RuntimeEnvironment.getApplication().getPackageName());
    }

    public boolean hasPermissionForPackage(UsbAccessory accessory, String packageName) {
        List<UsbAccessory> usbAccessories = grantedAccessoryPermissions.get(packageName);
        return usbAccessories != null && usbAccessories.contains(accessory);
    }

    @Implementation(minSdk=24)
    @HiddenApi
    protected void grantPermission(UsbDevice device) {
        this.grantPermission(device, RuntimeEnvironment.getApplication().getPackageName());
    }

    @Implementation(minSdk=25)
    @HiddenApi
    protected void grantPermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = grantedDevicePermissions.get(packageName);
        if (usbDevices == null) {
            usbDevices = new ArrayList<UsbDevice>();
            grantedDevicePermissions.put(packageName, usbDevices);
        }
        usbDevices.add(device);
    }

    public void grantPermission(UsbAccessory accessory) {
        String packageName = RuntimeEnvironment.getApplication().getPackageName();
        List<UsbAccessory> usbAccessories = grantedAccessoryPermissions.get(packageName);
        if (usbAccessories == null) {
            usbAccessories = new ArrayList<UsbAccessory>();
            grantedAccessoryPermissions.put(packageName, usbAccessories);
        }
        usbAccessories.add(accessory);
    }

    public void revokePermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = grantedDevicePermissions.get(packageName);
        if (usbDevices != null) {
            usbDevices.remove(device);
        }
    }

    public void revokePermission(UsbAccessory accessory, String packageName) {
        List<UsbAccessory> usbAccessories = grantedAccessoryPermissions.get(packageName);
        if (usbAccessories != null) {
            usbAccessories.remove(accessory);
        }
    }

    @Implementation
    protected HashMap<String, UsbDevice> getDeviceList() {
        return new HashMap<String, UsbDevice>(usbDevices);
    }

    @Implementation
    protected UsbAccessory[] getAccessoryList() {
        if (attachedUsbAccessory == null) {
            return null;
        }
        return new UsbAccessory[]{attachedUsbAccessory};
    }

    public void setAttachedUsbAccessory(UsbAccessory usbAccessory) {
        attachedUsbAccessory = usbAccessory;
    }

    public void addOrUpdateUsbDevice(UsbDevice usbDevice, boolean hasPermission) {
        Preconditions.checkNotNull((Object)usbDevice);
        Preconditions.checkNotNull((Object)usbDevice.getDeviceName());
        usbDevices.put(usbDevice.getDeviceName(), usbDevice);
        if (hasPermission) {
            this.grantPermission(usbDevice);
        } else {
            this.revokePermission(usbDevice, RuntimeEnvironment.getApplication().getPackageName());
        }
    }

    public void removeUsbDevice(UsbDevice usbDevice) {
        Preconditions.checkNotNull((Object)usbDevice);
        usbDevices.remove(usbDevice.getDeviceName());
        this.revokePermission(usbDevice, RuntimeEnvironment.getApplication().getPackageName());
    }

    @Implementation(minSdk=23, maxSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.usb.UsbPort[]") Object getPorts() {
        return usbPortStatuses.keySet().toArray(new UsbPort[usbPortStatuses.size()]);
    }

    @Implementation(minSdk=29, methodName="getPorts")
    @HiddenApi
    protected List<?> getPortsFromQ() {
        return new ArrayList<UsbPort>(usbPortStatuses.keySet());
    }

    public void clearPorts() {
        usbPorts.clear();
        usbPortStatuses.clear();
    }

    public void addPort(String portId) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            this.addPort(portId, 3, 2, 2, 0);
            return;
        }
        UsbPort usbPort = (UsbPort)ReflectionHelpers.callConstructor(UsbPort.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)portId), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)((Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"MODE_DUAL")))});
        usbPorts.put(portId, usbPort);
        usbPortStatuses.put(usbPort, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus((Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"MODE_DUAL"), (Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"POWER_ROLE_SINK"), (Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"DATA_ROLE_DEVICE"), 0));
    }

    @TargetApi(value=29)
    public void addPort(String portId, int statusCurrentMode, int statusCurrentPowerRole, int statusCurrentDataRole, int statusSupportedRoleCombinations) {
        Preconditions.checkState((RuntimeEnvironment.getApiLevel() >= 29 ? 1 : 0) != 0);
        UsbPort usbPort = (UsbPort)ShadowUsbManager.createUsbPort(this.realUsbManager, portId, statusCurrentMode);
        usbPorts.put(portId, usbPort);
        usbPortStatuses.put(usbPort, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus(statusCurrentMode, statusCurrentPowerRole, statusCurrentDataRole, statusSupportedRoleCombinations));
    }

    @Nullable
    public Object getPortStatus(String portId) {
        return usbPortStatuses.get(usbPorts.get(portId));
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected @ClassName(value="android.hardware.usb.UsbPortStatus") Object getPortStatus(@ClassName(value="android.hardware.usb.UsbPort") @ClassName(value="android.hardware.usb.UsbPort") Object port) {
        return usbPortStatuses.get(port);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected void setPortRoles(@ClassName(value="android.hardware.usb.UsbPort") @ClassName(value="android.hardware.usb.UsbPort") Object port, int powerRole, int dataRole) {
        UsbPortStatus status = usbPortStatuses.get(port);
        usbPortStatuses.put((UsbPort)port, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus(status.getCurrentMode(), powerRole, dataRole, status.getSupportedRoleCombinations()));
        RuntimeEnvironment.getApplication().sendBroadcast(new Intent("android.hardware.usb.action.USB_PORT_CHANGED"));
    }

    @Implementation
    protected UsbDeviceConnection openDevice(UsbDevice device) {
        return ShadowUsbManager.createUsbDeviceConnection(device);
    }

    @Implementation
    protected ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            File tmpUsbDir = RuntimeEnvironment.getTempDirectory().createIfNotExists("usb-accessory").toFile();
            return ParcelFileDescriptor.open((File)new File(tmpUsbDir, "usb-accessory-file"), (int)0x30000000);
        }
        catch (FileNotFoundException error) {
            throw new RuntimeException("Error shadowing openAccessory", error);
        }
    }

    private static Object createUsbPortStatus(int currentMode, int currentPowerRole, int currentDataRole, int supportedRoleCombinations) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations, 0, 0);
        }
        return ReflectionHelpers.callConstructor(UsbPortStatus.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentMode), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentPowerRole), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentDataRole), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)supportedRoleCombinations)});
    }

    private static Object createUsbPort(UsbManager usbManager, String id2, int supportedModes) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return new UsbPort(usbManager, id2, supportedModes, 0, false, false);
        }
        return ReflectionHelpers.callConstructor(UsbPort.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(UsbManager.class, (Object)usbManager), ReflectionHelpers.ClassParameter.from(String.class, (Object)id2), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)supportedModes)});
    }

    private static UsbDeviceConnection createUsbDeviceConnection(UsbDevice device) {
        return (UsbDeviceConnection)ReflectionHelpers.callConstructor(UsbDeviceConnection.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(UsbDevice.class, (Object)device)});
    }

    @ForType(value=UsbManager.class)
    public static interface _UsbManagerQ_ {
        public List<UsbPort> getPorts();
    }

    @ForType(value=UsbManager.class)
    public static interface _UsbManager_ {
        public UsbPort[] getPorts();

        public UsbPortStatus getPortStatus(UsbPort var1);

        public void setPortRoles(UsbPort var1, int var2, int var3);
    }
}

