/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowSurfaceTexture;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Surface.class)
public class ShadowSurface {
    private static final AtomicInteger nativeObject = new AtomicInteger();
    private SurfaceTexture surfaceTexture;
    private Canvas canvas;
    @RealObject
    private Surface realSurface;
    @ReflectorObject
    private SurfaceReflector surfaceReflector;
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final AtomicBoolean canvasLocked = new AtomicBoolean(false);

    @Implementation
    protected void __constructor__(SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
        Shadow.invokeConstructor(Surface.class, (Object)this.realSurface, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(SurfaceTexture.class, (Object)surfaceTexture)});
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Implementation
    protected void finalize() throws Throwable {
        CloseGuard closeGuard = this.surfaceReflector.getCloseGuard();
        if (closeGuard != null) {
            closeGuard.close();
        }
        this.surfaceReflector.finalize();
    }

    @Implementation
    protected boolean isValid() {
        return this.valid.get();
    }

    @Implementation
    protected void release() {
        this.valid.set(false);
        this.surfaceReflector.release();
    }

    private void checkNotReleased() {
        if (!this.valid.get()) {
            throw new IllegalStateException("Surface has already been released.");
        }
    }

    private void checkNotLocked() {
        if (this.canvasLocked.get()) {
            throw new IllegalStateException("Surface has already been locked.");
        }
    }

    private void checkNotReleasedOrLocked() {
        this.checkNotReleased();
        this.checkNotLocked();
    }

    @Implementation
    protected Canvas lockCanvas(Rect inOutDirty) {
        this.checkNotReleasedOrLocked();
        this.canvasLocked.set(true);
        if (this.canvas == null) {
            this.canvas = new Canvas();
        }
        return this.canvas;
    }

    @Implementation(minSdk=23)
    protected Canvas lockHardwareCanvas() {
        this.checkNotReleasedOrLocked();
        this.canvasLocked.set(true);
        this.canvas = this.surfaceReflector.lockHardwareCanvas();
        return this.canvas;
    }

    @Implementation
    protected void unlockCanvasAndPost(Canvas canvas) {
        this.checkNotReleased();
        if (!this.canvasLocked.get()) {
            throw new IllegalStateException("Canvas is not locked!");
        }
        if (this.surfaceTexture != null) {
            ((ShadowSurfaceTexture.SurfaceTextureReflector)Reflector.reflector(ShadowSurfaceTexture.SurfaceTextureReflector.class, (Object)this.surfaceTexture)).postEventFromNative(new WeakReference<SurfaceTexture>(this.surfaceTexture));
        }
        if (canvas != null && canvas.isHardwareAccelerated()) {
            this.surfaceReflector.unlockCanvasAndPost(canvas);
        }
        this.canvasLocked.set(false);
    }

    @Implementation
    protected static long nativeCreateFromSurfaceTexture(SurfaceTexture surfaceTexture) {
        return nativeObject.incrementAndGet();
    }

    @Implementation
    protected static long nativeCreateFromSurfaceControl(long surfaceControlNativeObject) {
        return nativeObject.incrementAndGet();
    }

    @Implementation(minSdk=29)
    protected static long nativeGetFromSurfaceControl(long surfaceObject, long surfaceControlNativeObject) {
        return nativeObject.incrementAndGet();
    }

    @Resetter
    public static void reset() {
        nativeObject.set(0);
    }

    @ForType(value=Surface.class)
    static interface SurfaceReflector {
        @Accessor(value="mCloseGuard")
        public CloseGuard getCloseGuard();

        @Direct
        public void finalize();

        @Direct
        public void release();

        @Direct
        public Canvas lockHardwareCanvas();

        @Direct
        public void unlockCanvasAndPost(Canvas var1);
    }
}

