/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.IBinder;
import android.se.omapi.ISecureElementChannel;
import android.se.omapi.ISecureElementListener;
import android.se.omapi.ISecureElementReader;
import android.se.omapi.ISecureElementService;
import android.se.omapi.ISecureElementSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=ISecureElementService.Stub.class, minSdk=28, isInAndroidSdk=false)
public class ShadowSecureElementService {
    private static final List<MockApplet> mockApplets = new ArrayList<MockApplet>(0);

    private ShadowSecureElementService() {
    }

    @Implementation
    protected static ISecureElementService asInterface(IBinder binder) {
        return new SecureElementService();
    }

    @Resetter
    public static void reset() {
        mockApplets.clear();
    }

    public static void addMockApplet(MockApplet applet) {
        if (ShadowSecureElementService.getMockApplet(applet.readerName, applet.aid) != null) {
            throw new IllegalStateException("Applet with that reader name and aid already exists");
        }
        mockApplets.add(applet);
    }

    private static MockApplet getMockApplet(String readerName, byte[] aid) {
        for (MockApplet applet : mockApplets) {
            if (!applet.readerName.equals(readerName) || !Arrays.equals(aid, applet.aid)) continue;
            return applet;
        }
        return null;
    }

    public static class MockApplet {
        private final byte[] aid;
        private final String readerName;
        private byte[] selectResponse = new byte[]{-112, 0};
        private final List<byte[]> adpuRequests = new ArrayList<byte[]>(0);
        private final List<byte[]> adpuResponses = new ArrayList<byte[]>(0);

        public MockApplet(String readerName, byte[] aid) {
            this.readerName = readerName;
            this.aid = aid;
        }

        public void addApduResponse(byte[] apduResponse) {
            this.adpuResponses.add(apduResponse);
        }

        public void setSelectResponse(byte[] selectResponse) {
            this.selectResponse = selectResponse;
        }

        public byte[] getSelectResponse() {
            return this.selectResponse;
        }

        public List<byte[]> getAdpuRequests() {
            return new ArrayList<byte[]>(this.adpuRequests);
        }

        public byte[] processRequestApdu(byte[] request) {
            this.adpuRequests.add(request);
            if (this.adpuResponses.isEmpty()) {
                return null;
            }
            return this.adpuResponses.remove(0);
        }
    }

    private static class SecureElementService
    extends ISecureElementService.Default {
        private SecureElementService() {
        }

        public String[] getReaders() {
            String[] readerNames = new String[mockApplets.size()];
            for (int i = 0; i < mockApplets.size(); ++i) {
                readerNames[i] = ((MockApplet)mockApplets.get(i)).readerName;
            }
            return readerNames;
        }

        public ISecureElementReader getReader(String reader) {
            return new SecureElementReader(reader);
        }

        public boolean[] isNfcEventAllowed(String reader, byte[] aid, String[] packageNames, int userId) {
            throw new RuntimeException("UNIMPLEMENTED");
        }
    }

    private static class SecureElementChannel
    extends ISecureElementChannel.Default {
        private final MockApplet mockApplet;
        private final boolean isBasicChannel;
        private boolean isClosed;

        public SecureElementChannel(MockApplet mockApplet, boolean isBasicChannel) {
            this.mockApplet = mockApplet;
            this.isBasicChannel = isBasicChannel;
        }

        public void close() {
            this.isClosed = true;
            throw new RuntimeException();
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public boolean isBasicChannel() {
            return this.isBasicChannel;
        }

        public byte[] getSelectResponse() {
            return this.mockApplet.getSelectResponse();
        }

        public byte[] transmit(byte[] command) {
            return this.mockApplet.processRequestApdu(command);
        }

        public boolean selectNext() {
            throw new RuntimeException("UNIMPLEMENTED");
        }
    }

    private static class SecureElementSession
    extends ISecureElementSession.Default {
        private final SecureElementReader reader;
        private final List<SecureElementChannel> channels = new ArrayList<SecureElementChannel>(0);
        private boolean isClosed;

        SecureElementSession(SecureElementReader reader) {
            this.reader = reader;
        }

        public byte[] getAtr() {
            throw new RuntimeException();
        }

        public void close() {
            this.isClosed = true;
        }

        public void closeChannels() {
            for (SecureElementChannel channel : this.channels) {
                channel.close();
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public ISecureElementChannel openBasicChannel(byte[] aid, byte p2, ISecureElementListener listener) {
            return this.openChannel(aid, p2, listener, true);
        }

        public ISecureElementChannel openLogicalChannel(byte[] aid, byte p2, ISecureElementListener listener) {
            return this.openChannel(aid, p2, listener, false);
        }

        private ISecureElementChannel openChannel(byte[] aid, byte p2, ISecureElementListener listener, boolean isBasicChannel) {
            MockApplet mockApplet = this.reader.getMockApplet(aid);
            if (mockApplet == null) {
                return null;
            }
            SecureElementChannel channel = new SecureElementChannel(mockApplet, isBasicChannel);
            this.channels.add(channel);
            return channel;
        }
    }

    private static class SecureElementReader
    extends ISecureElementReader.Default {
        private final String name;
        private final List<SecureElementSession> sessions = new ArrayList<SecureElementSession>(0);

        SecureElementReader(String name) {
            this.name = name;
        }

        public boolean isSecureElementPresent() {
            return true;
        }

        public ISecureElementSession openSession() {
            SecureElementSession session = new SecureElementSession(this);
            this.sessions.add(session);
            return session;
        }

        public void closeSessions() {
            for (SecureElementSession session : this.sessions) {
                session.close();
            }
        }

        public boolean reset() {
            this.closeSessions();
            return true;
        }

        private MockApplet getMockApplet(byte[] aid) {
            return ShadowSecureElementService.getMockApplet(this.name, aid);
        }
    }
}

