/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.RoboIntentSender;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=PendingIntent.class)
@SuppressLint(value={"NewApi"})
public class ShadowPendingIntent {
    private static final int NULL_PENDING_INTENT_VALUE = -1;
    @GuardedBy(value="lock")
    private static final List<PendingIntent> createdIntents = new ArrayList<PendingIntent>();
    private static final Object lock = new Object();
    private static final List<PendingIntent> parceledPendingIntents = new ArrayList<PendingIntent>();
    @RealObject
    private PendingIntent realPendingIntent;
    @NonNull
    private Intent[] savedIntents;
    private Context savedContext;
    private Type type;
    private int requestCode;
    private int flags;
    @Nullable
    private Bundle options;
    private String creatorPackage;
    private int creatorUid;
    private boolean canceled;
    @Nullable
    private PendingIntent.OnFinished lastOnFinished;
    static final Parcelable.Creator<PendingIntent> CREATOR = new Parcelable.Creator<PendingIntent>(){

        public PendingIntent createFromParcel(Parcel in) {
            return ShadowPendingIntent.readPendingIntentOrNullFromParcel(in);
        }

        public PendingIntent[] newArray(int size) {
            return new PendingIntent[size];
        }
    };

    @Implementation
    protected static void __staticInitializer__() {
        Shadow.directInitialize(PendingIntent.class);
        ReflectionHelpers.setStaticField(PendingIntent.class, (String)"CREATOR", CREATOR);
    }

    @Implementation
    protected static PendingIntent getActivity(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.ACTIVITY, requestCode, flags, null);
    }

    @Implementation
    protected static PendingIntent getActivity(Context context, int requestCode, @NonNull Intent intent, int flags, Bundle options) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.ACTIVITY, requestCode, flags, options);
    }

    @Implementation
    protected static PendingIntent getActivities(Context context, int requestCode, @NonNull Intent[] intents, int flags) {
        return ShadowPendingIntent.create(context, intents, Type.ACTIVITY, requestCode, flags, null);
    }

    @Implementation
    protected static PendingIntent getActivities(Context context, int requestCode, @NonNull Intent[] intents, int flags, Bundle options) {
        return ShadowPendingIntent.create(context, intents, Type.ACTIVITY, requestCode, flags, options);
    }

    @Implementation
    protected static PendingIntent getBroadcast(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.BROADCAST, requestCode, flags, null);
    }

    @Implementation
    protected static PendingIntent getService(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.SERVICE, requestCode, flags, null);
    }

    @Implementation(minSdk=26)
    protected static PendingIntent getForegroundService(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.FOREGROUND_SERVICE, requestCode, flags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void cancel() {
        Object object = lock;
        synchronized (object) {
            Iterator<PendingIntent> i = createdIntents.iterator();
            while (i.hasNext()) {
                PendingIntent pendingIntent = i.next();
                if (pendingIntent != this.realPendingIntent) continue;
                this.canceled = true;
                i.remove();
                break;
            }
        }
    }

    @Implementation
    protected void send() throws PendingIntent.CanceledException {
        this.send(this.savedContext, 0, null);
    }

    @Implementation
    protected void send(int code) throws PendingIntent.CanceledException {
        this.send(this.savedContext, code, null);
    }

    @Implementation
    protected void send(int code, PendingIntent.OnFinished onFinished, Handler handler) throws PendingIntent.CanceledException {
        this.send(this.savedContext, code, null, onFinished, handler);
    }

    @Implementation
    protected void send(Context context, int code, Intent intent) throws PendingIntent.CanceledException {
        this.send(context, code, intent, null, null);
    }

    @Implementation
    protected void send(Context context, int code, Intent intent, PendingIntent.OnFinished onFinished, Handler handler) throws PendingIntent.CanceledException {
        this.send(context, code, intent, onFinished, handler, null);
    }

    @Implementation
    protected void send(Context context, int code, Intent intent, PendingIntent.OnFinished onFinished, Handler handler, String requiredPermission) throws PendingIntent.CanceledException {
        this.send(context, code, intent, onFinished, handler, requiredPermission, null);
    }

    @Implementation(minSdk=23)
    protected void send(Context context, int code, Intent intent, PendingIntent.OnFinished onFinished, Handler handler, String requiredPermission, Bundle options) throws PendingIntent.CanceledException {
        this.send(context, code, intent, onFinished, handler, requiredPermission, options, 0);
    }

    void send(Context context, int code, Intent intent, PendingIntent.OnFinished onFinished, Handler handler, String requiredPermission, Bundle options, int requestCode) throws PendingIntent.CanceledException {
        Intent[] intentsToSend;
        PendingIntent.OnFinished onFinished2 = this.lastOnFinished = handler == null ? onFinished : (pendingIntent, intent1, resultCode, resultData, resultExtras) -> handler.post(() -> onFinished.onSendFinished(pendingIntent, intent1, resultCode, resultData, resultExtras));
        if (this.canceled) {
            throw new PendingIntent.CanceledException();
        }
        if (intent != null && ShadowPendingIntent.isMutable(this.flags)) {
            intentsToSend = Arrays.copyOf(this.savedIntents, this.savedIntents.length);
            Intent lastIntentCopy = new Intent(intentsToSend[intentsToSend.length - 1]);
            lastIntentCopy.fillIn(intent, this.flags);
            intentsToSend[intentsToSend.length - 1] = lastIntentCopy;
        } else {
            intentsToSend = this.savedIntents;
        }
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        if (this.isActivity()) {
            for (Intent intentToSend : intentsToSend) {
                shadowInstrumentation.execStartActivity(context, (IBinder)null, (IBinder)null, (Activity)null, intentToSend, requestCode, (Bundle)null);
            }
        } else if (this.isBroadcast()) {
            for (Intent intentToSend : intentsToSend) {
                shadowInstrumentation.sendBroadcastWithPermission(intentToSend, requiredPermission, context, options, code);
            }
        } else if (this.isService()) {
            for (Intent intentToSend : intentsToSend) {
                context.startService(intentToSend);
            }
        } else if (this.isForegroundService()) {
            for (Intent intentToSend : intentsToSend) {
                context.startForegroundService(intentToSend);
            }
        }
        if (ShadowPendingIntent.isOneShot(this.flags)) {
            this.cancel();
        }
    }

    @Implementation
    protected IntentSender getIntentSender() {
        return new RoboIntentSender(this.realPendingIntent);
    }

    @Implementation(minSdk=31)
    public boolean isActivity() {
        return this.type == Type.ACTIVITY;
    }

    @Implementation(minSdk=31)
    public boolean isBroadcast() {
        return this.type == Type.BROADCAST;
    }

    @Implementation(minSdk=31)
    public boolean isForegroundService() {
        return this.type == Type.FOREGROUND_SERVICE;
    }

    @Implementation(minSdk=31)
    public boolean isService() {
        return this.type == Type.SERVICE;
    }

    @Implementation(minSdk=31)
    public boolean isImmutable() {
        return (this.flags & 0x4000000) > 0;
    }

    @Implementation
    protected boolean isTargetedToPackage() {
        for (Intent intent : this.savedIntents) {
            if (intent.getPackage() == null || intent.getComponent() == null) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isActivityIntent() {
        return this.type == Type.ACTIVITY;
    }

    @Deprecated
    public boolean isBroadcastIntent() {
        return this.type == Type.BROADCAST;
    }

    @Deprecated
    public boolean isServiceIntent() {
        return this.type == Type.SERVICE;
    }

    @Deprecated
    public boolean isForegroundServiceIntent() {
        return this.type == Type.FOREGROUND_SERVICE;
    }

    public Context getSavedContext() {
        return this.savedContext;
    }

    public Intent getSavedIntent() {
        return this.savedIntents[this.savedIntents.length - 1];
    }

    public Intent[] getSavedIntents() {
        return this.savedIntents;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public int getFlags() {
        return this.flags;
    }

    @Nullable
    public Bundle getOptions() {
        return this.options;
    }

    public boolean callLastOnFinished(Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        if (this.lastOnFinished == null) {
            return false;
        }
        this.lastOnFinished.onSendFinished(this.realPendingIntent, intent, resultCode, resultData, resultExtras);
        return true;
    }

    @Implementation
    protected String getTargetPackage() {
        return this.getCreatorPackage();
    }

    @Implementation
    protected String getCreatorPackage() {
        return this.creatorPackage == null ? RuntimeEnvironment.getApplication().getPackageName() : this.creatorPackage;
    }

    public void setCreatorPackage(String creatorPackage) {
        this.creatorPackage = creatorPackage;
    }

    @Implementation
    protected int getCreatorUid() {
        return this.creatorUid;
    }

    public void setCreatorUid(int uid) {
        this.creatorUid = uid;
    }

    @Implementation
    public boolean equals(Object o) {
        String thatPackageName;
        if (this == o) {
            return true;
        }
        if (o == null || this.realPendingIntent.getClass() != o.getClass()) {
            return false;
        }
        ShadowPendingIntent that = (ShadowPendingIntent)Shadow.extract((Object)((PendingIntent)o));
        String packageName = this.savedContext == null ? null : this.savedContext.getPackageName();
        String string = thatPackageName = that.savedContext == null ? null : that.savedContext.getPackageName();
        if (!Objects.equals(packageName, thatPackageName)) {
            return false;
        }
        if (this.savedIntents.length != that.savedIntents.length) {
            return false;
        }
        for (int i = 0; i < this.savedIntents.length; ++i) {
            if (this.savedIntents[i].filterEquals(that.savedIntents[i])) continue;
            return false;
        }
        return this.requestCode == that.requestCode;
    }

    @Implementation
    public int hashCode() {
        int result;
        int n = result = this.savedIntents != null ? Arrays.hashCode(this.savedIntents) : 0;
        if (this.savedContext != null) {
            String packageName = this.savedContext.getPackageName();
            result = 31 * result + (packageName != null ? packageName.hashCode() : 0);
        }
        result = 31 * result + this.requestCode;
        return result;
    }

    @Implementation
    @Nullable
    public static PendingIntent readPendingIntentOrNullFromParcel(@NonNull Parcel in) {
        int intentIndex = in.readInt();
        if (intentIndex == -1) {
            return null;
        }
        return parceledPendingIntents.get(intentIndex);
    }

    @Implementation
    public static void writePendingIntentOrNullToParcel(@Nullable PendingIntent sender, @NonNull Parcel out) {
        ThreadLocal sOnMarshaledListener;
        PendingIntent.OnMarshaledListener listener;
        if (sender == null) {
            out.writeInt(-1);
            return;
        }
        int index = parceledPendingIntents.size();
        parceledPendingIntents.add(sender);
        out.writeInt(index);
        if (RuntimeEnvironment.getApiLevel() >= 35) {
            ThreadLocal sOnMarshaledListeners = (ThreadLocal)ReflectionHelpers.getStaticField(PendingIntent.class, (String)"sOnMarshaledListener");
            List listeners = (List)sOnMarshaledListeners.get();
            if (listeners != null) {
                for (PendingIntent.OnMarshaledListener listener2 : listeners) {
                    listener2.onMarshaled(sender, out, 0);
                }
            }
        } else if (RuntimeEnvironment.getApiLevel() >= 24 && (listener = (PendingIntent.OnMarshaledListener)(sOnMarshaledListener = (ThreadLocal)ReflectionHelpers.getStaticField(PendingIntent.class, (String)"sOnMarshaledListener")).get()) != null) {
            listener.onMarshaled(sender, out, 0);
        }
    }

    @Implementation
    protected void writeToParcel(Parcel out, int flags) {
        ShadowPendingIntent.writePendingIntentOrNullToParcel(this.realPendingIntent, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PendingIntent create(Context context, Intent[] intents, Type type, int requestCode, int flags, @Nullable Bundle options) {
        Object object = lock;
        synchronized (object) {
            ShadowPendingIntent shadowPendingIntent;
            Objects.requireNonNull(intents, "intents may not be null");
            PendingIntent pendingIntent = ShadowPendingIntent.getCreatedIntentFor(type, intents, requestCode, flags);
            if ((flags & 0x20000000) != 0) {
                return pendingIntent;
            }
            if (pendingIntent != null && (flags & 0x8000000) != 0) {
                ShadowPendingIntent shadowPendingIntent2 = (ShadowPendingIntent)Shadow.extract((Object)pendingIntent);
                Intent intent = shadowPendingIntent2.getSavedIntent();
                Bundle extras = intent.getExtras();
                if (extras != null) {
                    extras.clear();
                }
                intent.putExtras(intents[intents.length - 1]);
                return pendingIntent;
            }
            if (pendingIntent != null && (flags & 0x10000000) != 0) {
                shadowPendingIntent = (ShadowPendingIntent)Shadow.extract((Object)pendingIntent);
                shadowPendingIntent.cancel();
                pendingIntent = null;
            }
            if (pendingIntent == null) {
                pendingIntent = (PendingIntent)ReflectionHelpers.callConstructor(PendingIntent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                ((PendingIntentReflector)Reflector.reflector(PendingIntentReflector.class, (Object)pendingIntent)).setTarget((IIntentSender)ReflectionHelpers.createNullProxy(IIntentSender.class));
                shadowPendingIntent = (ShadowPendingIntent)Shadow.extract((Object)pendingIntent);
                shadowPendingIntent.savedIntents = intents;
                shadowPendingIntent.type = type;
                shadowPendingIntent.savedContext = context;
                shadowPendingIntent.requestCode = requestCode;
                shadowPendingIntent.flags = flags;
                shadowPendingIntent.options = options;
                createdIntents.add(pendingIntent);
            }
            return pendingIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PendingIntent getCreatedIntentFor(Type type, Intent[] intents, int requestCode, int flags) {
        Object object = lock;
        synchronized (object) {
            for (PendingIntent createdIntent : createdIntents) {
                ShadowPendingIntent shadowPendingIntent = (ShadowPendingIntent)Shadow.extract((Object)createdIntent);
                if (ShadowPendingIntent.isOneShot(shadowPendingIntent.flags) != ShadowPendingIntent.isOneShot(flags) || ShadowPendingIntent.isMutable(shadowPendingIntent.flags) != ShadowPendingIntent.isMutable(flags) || shadowPendingIntent.type != type || shadowPendingIntent.requestCode != requestCode) continue;
                Intent savedIntent = shadowPendingIntent.getSavedIntent();
                Intent targetIntent = intents[intents.length - 1];
                if (!(savedIntent == null ? targetIntent == null : savedIntent.filterEquals(targetIntent))) continue;
                return createdIntent;
            }
            return null;
        }
    }

    private static boolean isOneShot(int flags) {
        return (flags & 0x40000000) != 0;
    }

    private static boolean isMutable(int flags) {
        return (flags & 0x4000000) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            createdIntents.clear();
            parceledPendingIntents.clear();
        }
    }

    private static enum Type {
        ACTIVITY,
        BROADCAST,
        SERVICE,
        FOREGROUND_SERVICE;

    }

    @ForType(value=PendingIntent.class)
    static interface PendingIntentReflector {
        @Accessor(value="mTarget")
        public void setTarget(IIntentSender var1);
    }
}

