/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BadParcelableException;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Parcel.class)
public class ShadowParcel {
    protected static final String TAG = "Parcel";
    @RealObject
    private Parcel realObject;
    private static final NativeObjRegistry<ByteBuffer> NATIVE_BYTE_BUFFER_REGISTRY = new NativeObjRegistry(ByteBuffer.class);
    private static final HashMap<ClassLoader, HashMap<String, Pair<Parcelable.Creator<?>, Class<?>>>> pairedCreators = new HashMap();

    @HiddenApi
    @Implementation
    public Parcelable.Creator<?> readParcelableCreator(ClassLoader loader) {
        Parcelable.Creator creator;
        String name = this.realObject.readString();
        if (name == null) {
            return null;
        }
        try {
            ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
            Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
            if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                throw new BadParcelableException("Parcelable protocol requires that the class implements Parcelable");
            }
            Field f = parcelableClass.getField("CREATOR");
            f.setAccessible(true);
            if ((f.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            Class<?> creatorType = f.getType();
            if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f.get(null);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Illegal access when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Class not found when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name);
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        return creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=33)
    protected <T> Parcelable.Creator<T> readParcelableCreatorInternal(ClassLoader loader, Class<T> clazz) {
        Class<?> parcelableClass;
        Parcelable.Creator creator;
        Pair<Parcelable.Creator<?>, Class<?>> creatorAndParcelableClass;
        String name = this.realObject.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Pair<Parcelable.Creator<?>, Class<?>>>> hashMap = pairedCreators;
        synchronized (hashMap) {
            HashMap<String, Pair<Parcelable.Creator<?>, Class<?>>> map = pairedCreators.get(loader);
            if (map == null) {
                pairedCreators.put(loader, new HashMap());
                creatorAndParcelableClass = null;
            } else {
                creatorAndParcelableClass = map.get(name);
            }
        }
        if (creatorAndParcelableClass != null) {
            creator = (Parcelable.Creator)creatorAndParcelableClass.first;
            parcelableClass = (Class<?>)creatorAndParcelableClass.second;
            if (clazz != null && !clazz.isAssignableFrom(parcelableClass)) {
                throw this.newBadTypeParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            return creator;
        }
        try {
            ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
            parcelableClass = Class.forName(name, false, parcelableClassLoader);
            if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                throw new BadParcelableException("Parcelable protocol requires subclassing from Parcelable on class " + name);
            }
            if (clazz != null && !clazz.isAssignableFrom(parcelableClass)) {
                throw this.newBadTypeParcelableException("Parcelable creator " + name + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
            Field f = parcelableClass.getField("CREATOR");
            f.setAccessible(true);
            if ((f.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            Class<?> creatorType = f.getType();
            if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f.get(null);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Illegal access when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Class not found when unmarshalling: " + name), (Throwable)e);
            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name, (Throwable)e);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        HashMap<ClassLoader, HashMap<String, Pair<Parcelable.Creator<?>, Class<?>>>> hashMap2 = pairedCreators;
        synchronized (hashMap2) {
            pairedCreators.get(loader).put(name, Pair.create((Object)creator, parcelableClass));
        }
        return creator;
    }

    private BadParcelableException newBadTypeParcelableException(String message) {
        try {
            return (BadParcelableException)ReflectionHelpers.callConstructor(Class.forName("android.os.BadTypeParcelableException"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)message)});
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    @Implementation
    protected void writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.realObject.writeInt(-1);
            return;
        }
        long nativePtr = (Long)ReflectionHelpers.getField((Object)this.realObject, (String)"mNativePtr");
        ShadowParcel.nativeWriteByteArray(nativePtr, b, offset, len);
    }

    @Implementation
    protected static int nativeDataSize(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).dataSize();
    }

    @Implementation
    protected static int nativeDataAvail(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).dataAvailable();
    }

    @Implementation
    protected static int nativeDataPosition(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).dataPosition();
    }

    @Implementation
    protected static int nativeDataCapacity(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).dataCapacity();
    }

    @Implementation
    protected static void nativeSetDataSize(long nativePtr, int size) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).setDataSize(size);
    }

    @Implementation
    protected static void nativeSetDataPosition(long nativePtr, int pos) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).setDataPosition(pos);
    }

    @Implementation
    protected static void nativeSetDataCapacity(long nativePtr, int size) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).setDataCapacityAtLeast(size);
    }

    @Implementation
    protected static void nativeWriteByteArray(long nativePtr, byte[] b, int offset, int len) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeByteArray(b, offset, len);
    }

    @Implementation(minSdk=23)
    protected void writeBlob(byte[] b, int offset, int len) {
        if (b == null) {
            this.realObject.writeInt(-1);
            return;
        }
        ShadowParcel.throwsIfOutOfBounds(b.length, offset, len);
        long nativePtr = (Long)ReflectionHelpers.getField((Object)this.realObject, (String)"mNativePtr");
        ShadowParcel.nativeWriteBlob(nativePtr, b, offset, len);
    }

    private static void throwsIfOutOfBounds(int len, int offset, int count) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative length: " + len);
        }
        if ((offset | count) < 0 || offset > len - count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Implementation
    protected static void nativeWriteBlob(long nativePtr, byte[] b, int offset, int len) {
        ShadowParcel.nativeWriteByteArray(nativePtr, b, offset, len);
    }

    @Implementation
    protected static int nativeWriteInt(long nativePtr, int val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeInt(val);
        return 0;
    }

    @Implementation
    protected static int nativeWriteLong(long nativePtr, long val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeLong(val);
        return 0;
    }

    @Implementation
    protected static int nativeWriteFloat(long nativePtr, float val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeFloat(val);
        return 0;
    }

    @Implementation
    protected static int nativeWriteDouble(long nativePtr, double val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeDouble(val);
        return 0;
    }

    @Implementation(maxSdk=29)
    protected static void nativeWriteString(long nativePtr, String val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeString(val);
    }

    @Implementation
    protected static void nativeWriteStrongBinder(long nativePtr, IBinder val) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeStrongBinder(val);
    }

    @Implementation
    protected static byte[] nativeCreateByteArray(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).createByteArray();
    }

    @Implementation
    protected static byte[] nativeReadBlob(long nativePtr) {
        return ShadowParcel.nativeCreateByteArray(nativePtr);
    }

    @Implementation(minSdk=27)
    protected static boolean nativeReadByteArray(long nativePtr, byte[] dest, int destLen) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readByteArray(dest, destLen);
    }

    @Implementation
    protected static int nativeReadInt(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readInt();
    }

    @Implementation
    protected static long nativeReadLong(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readLong();
    }

    @Implementation
    protected static float nativeReadFloat(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readFloat();
    }

    @Implementation
    protected static double nativeReadDouble(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readDouble();
    }

    @Implementation(maxSdk=29)
    protected static String nativeReadString(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readString();
    }

    @Implementation
    protected static IBinder nativeReadStrongBinder(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readStrongBinder();
    }

    @Implementation
    @HiddenApi
    public static long nativeCreate() {
        return NATIVE_BYTE_BUFFER_REGISTRY.register((Object)new ByteBuffer());
    }

    @Implementation
    protected static void nativeFreeBuffer(long nativePtr) {
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).clear();
    }

    @Implementation
    protected static void nativeDestroy(long nativePtr) {
        NATIVE_BYTE_BUFFER_REGISTRY.unregister(nativePtr);
    }

    @Implementation
    protected static byte[] nativeMarshall(long nativePtr) {
        return ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).toByteArray();
    }

    @Implementation
    protected static void nativeUnmarshall(long nativePtr, byte[] data, int offset, int length) {
        NATIVE_BYTE_BUFFER_REGISTRY.update(nativePtr, (Object)ByteBuffer.fromByteArray(data, offset, length));
    }

    @Implementation
    protected static void nativeAppendFrom(long thisNativePtr, long otherNativePtr, int offset, int length) {
        ByteBuffer thisByteBuffer = (ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(thisNativePtr);
        ByteBuffer otherByteBuffer = (ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(otherNativePtr);
        thisByteBuffer.appendFrom(otherByteBuffer, offset, length);
    }

    @Implementation
    protected static void nativeWriteInterfaceToken(long nativePtr, String interfaceName) {
        ShadowParcel.nativeWriteInt(nativePtr, 0);
        ShadowParcel.nativeWriteString(nativePtr, interfaceName);
    }

    @Implementation
    protected static void nativeEnforceInterface(long nativePtr, String interfaceName) {
        ShadowParcel.nativeReadInt(nativePtr);
        String actualInterfaceName = ShadowParcel.nativeReadString(nativePtr);
        if (!Objects.equals(interfaceName, actualInterfaceName)) {
            throw new SecurityException("Binder invocation to an incorrect interface");
        }
    }

    @Implementation(maxSdk=28)
    protected static FileDescriptor openFileDescriptor(String file, int mode) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, mode == 0x10000000 ? "r" : "rw");
        return randomAccessFile.getFD();
    }

    @Implementation(minSdk=23)
    protected static long nativeWriteFileDescriptor(long nativePtr, FileDescriptor val) {
        int fd = (Integer)ReflectionHelpers.getField((Object)val, (String)"fd");
        ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).writeInt(fd);
        return ShadowParcel.nativeDataPosition(nativePtr);
    }

    @Implementation(minSdk=23)
    protected static FileDescriptor nativeReadFileDescriptor(long nativePtr) {
        int fd = ((ByteBuffer)NATIVE_BYTE_BUFFER_REGISTRY.getNativeObject(nativePtr)).readInt();
        return (FileDescriptor)ReflectionHelpers.callConstructor(FileDescriptor.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)fd)});
    }

    @Implementation(minSdk=30)
    protected static void nativeWriteString8(long nativePtr, String val) {
        ShadowParcel.nativeWriteString(nativePtr, val);
    }

    @Implementation(minSdk=30)
    protected static void nativeWriteString16(long nativePtr, String val) {
        ShadowParcel.nativeWriteString(nativePtr, val);
    }

    @Implementation(minSdk=30)
    protected static String nativeReadString8(long nativePtr) {
        return ShadowParcel.nativeReadString(nativePtr);
    }

    @Implementation(minSdk=30)
    protected static String nativeReadString16(long nativePtr) {
        return ShadowParcel.nativeReadString(nativePtr);
    }

    @Resetter
    public static void reset() {
        pairedCreators.clear();
    }

    private static class ByteBuffer {
        private static final int INT_SIZE_BYTES = 4;
        private static final int LONG_OR_DOUBLE_SIZE_BYTES = 8;
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private FakeEncodedItem[] data;
        private int dataPosition;
        private int dataSize;
        private boolean failNextReadIfPastEnd;

        ByteBuffer() {
            this.clear();
        }

        public void clear() {
            this.data = new FakeEncodedItem[0];
            this.dataPosition = 0;
            this.dataSize = 0;
            this.failNextReadIfPastEnd = false;
        }

        public byte[] createByteArray() {
            int length = this.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            Object current = this.peek();
            if (current instanceof Byte) {
                return this.readLegacyByteArray(length);
            }
            if (this.readZeroes(this.alignToInt(length))) {
                return new byte[length];
            }
            byte[] result = this.readValue(EMPTY_BYTE_ARRAY, byte[].class, false);
            if (result.length != length) {
                throw new UnreliableBehaviorError(String.format(Locale.US, "Byte array's length prefix is %d but real length is %d", length, result.length));
            }
            return result;
        }

        private byte[] readLegacyByteArray(int length) {
            byte[] result = new byte[length];
            for (int i = 0; i < length; ++i) {
                result[i] = this.readPrimitive(1, (byte)0, Byte.class);
            }
            return result;
        }

        public boolean readByteArray(byte[] dest, int destLen) {
            byte[] result = this.createByteArray();
            if (result == null || destLen != result.length) {
                return false;
            }
            System.arraycopy(result, 0, dest, 0, destLen);
            return true;
        }

        public void writeByteArray(byte[] b, int offset, int length) {
            this.writeInt(length);
            if (length != 0) {
                this.writeValue(length, Arrays.copyOfRange(b, offset, offset + length));
            }
        }

        public void writeInt(int i) {
            this.writeValue(4, i);
        }

        public int readInt() {
            return this.readPrimitive(4, 0, Integer.class);
        }

        public void writeLong(long l) {
            this.writeValue(8, l);
        }

        public long readLong() {
            return this.readPrimitive(8, 0L, Long.class);
        }

        public void writeFloat(float f) {
            this.writeValue(4, Float.valueOf(f));
        }

        public float readFloat() {
            return this.readPrimitive(4, Float.valueOf(0.0f), Float.class).floatValue();
        }

        public void writeDouble(double d) {
            this.writeValue(8, d);
        }

        public double readDouble() {
            return this.readPrimitive(8, 0.0, Double.class);
        }

        public void writeString(String s) {
            int nullTerminatedChars = s != null ? s.length() + 1 : 0;
            int sizeBytes = 4 + nullTerminatedChars * 2;
            this.writeValue(sizeBytes, s);
        }

        public String readString() {
            if (this.readZeroes(8)) {
                return "";
            }
            return this.readValue(null, String.class, true);
        }

        public void writeStrongBinder(IBinder b) {
            int length = 20;
            this.writeValue(length, b);
        }

        public IBinder readStrongBinder() {
            return this.readValue(null, IBinder.class, true);
        }

        public void appendFrom(ByteBuffer other, int offset, int length) {
            int oldSize = this.dataSize;
            if (this.dataPosition != this.dataSize) {
                throw new UnreliableBehaviorError("Real Android parcels behave unreliably if appendFrom is called from any position other than the end");
            }
            this.setDataSize(oldSize + length);
            System.arraycopy(other.data, offset, this.data, this.dataPosition, length);
            this.dataPosition += length;
            this.failNextReadIfPastEnd = true;
        }

        private static boolean isEncodedAsAllZeroBytes(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.longValue() == 0L && number.doubleValue() == 0.0;
            }
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                return ByteBuffer.isAllZeroes(array, 0, array.length);
            }
            return false;
        }

        private static boolean isAllZeroes(byte[] array, int offset, int length) {
            for (int i = offset; i < length; ++i) {
                if (array[i] == 0) continue;
                return false;
            }
            return true;
        }

        public static ByteBuffer fromByteArray(byte[] array, int offset, int length) {
            ByteBuffer byteBuffer = new ByteBuffer();
            if (ByteBuffer.isAllZeroes(array, offset, length)) {
                byteBuffer.setDataSize(length);
                byteBuffer.writeItem(new FakeEncodedItem(length, new byte[length]));
                return byteBuffer;
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(array, offset, length);
                ObjectInputStream ois = new ObjectInputStream(bis);
                int numElements = ois.readInt();
                for (int i = 0; i < numElements; ++i) {
                    int sizeOf = ois.readInt();
                    Object value = ois.readObject();
                    byteBuffer.writeItem(new FakeEncodedItem(sizeOf, value));
                }
                return byteBuffer;
            }
            catch (Exception e) {
                throw new UnreliableBehaviorError("ShadowParcel unable to unmarshall its custom format", e);
            }
        }

        public byte[] toByteArray() {
            int oldDataPosition = this.dataPosition;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                ArrayList<FakeEncodedItem> entries = new ArrayList<FakeEncodedItem>();
                this.dataPosition = 0;
                while (this.dataPosition < this.dataSize) {
                    entries.add(this.readNextItem(Object.class));
                }
                oos.writeInt(entries.size());
                for (FakeEncodedItem item : entries) {
                    oos.writeInt(item.sizeBytes);
                    oos.writeObject(item.value);
                }
                oos.flush();
                Object object = bos.toByteArray();
                return object;
            }
            catch (IOException e) {
                throw new UnreliableBehaviorError("ErrorProne unable to serialize its custom format", e);
            }
            finally {
                this.dataPosition = oldDataPosition;
            }
        }

        public int dataAvailable() {
            return this.dataSize() - this.dataPosition();
        }

        public int dataCapacity() {
            return this.data.length;
        }

        public int dataPosition() {
            return this.dataPosition;
        }

        public int dataSize() {
            return this.dataSize;
        }

        public void setDataPosition(int pos) {
            if (pos > this.dataSize) {
                throw new UnreliableBehaviorError(pos + " greater than dataSize " + this.dataSize);
            }
            this.dataPosition = pos;
            this.failNextReadIfPastEnd = false;
        }

        public void setDataSize(int size) {
            if (size < this.dataSize) {
                Arrays.fill(this.data, size, this.dataSize, null);
            }
            this.setDataCapacityAtLeast(size);
            this.dataSize = size;
            if (this.dataPosition >= this.dataSize) {
                this.dataPosition = this.dataSize;
            }
        }

        public void setDataCapacityAtLeast(int newCapacity) {
            if (newCapacity > this.data.length) {
                FakeEncodedItem[] newData = new FakeEncodedItem[newCapacity];
                this.dataSize = Math.min(this.dataSize, newCapacity);
                this.dataPosition = Math.min(this.dataPosition, this.dataSize);
                System.arraycopy(this.data, 0, newData, 0, this.dataSize);
                this.data = newData;
            }
        }

        private int alignToInt(int unpaddedSizeBytes) {
            return (unpaddedSizeBytes + 3) / 4 * 4;
        }

        private void checkConsistentReadAndIncrementPosition(Class<?> clazz, FakeEncodedItem item) {
            int endPosition = this.dataPosition + item.sizeBytes;
            for (int i = this.dataPosition; i < endPosition; ++i) {
                FakeEncodedItem foundItemItem;
                FakeEncodedItem fakeEncodedItem = foundItemItem = i < this.dataSize ? this.data[i] : null;
                if (foundItemItem == item) continue;
                throw new UnreliableBehaviorError(clazz, this.dataPosition, item, String.format(Locale.US, "but [%s] interrupts it at position %d", foundItemItem == null ? "uninitialized data or the end of the buffer" : foundItemItem.value, i));
            }
            this.dataPosition = Math.min(this.dataSize, this.dataPosition + item.sizeBytes);
        }

        private Object peek() {
            return this.dataPosition < this.dataSize && this.data[this.dataPosition] != null ? this.data[this.dataPosition].value : null;
        }

        private <T> FakeEncodedItem readNextItem(Class<T> clazz) {
            FakeEncodedItem item = this.data[this.dataPosition];
            if (item == null) {
                throw new UnreliableBehaviorError("Reading uninitialized data at position " + this.dataPosition);
            }
            this.checkConsistentReadAndIncrementPosition(clazz, item);
            return item;
        }

        private <T> T readValue(T pastEndValue, Class<T> clazz, boolean allowNull) {
            if (this.dataPosition >= this.dataSize) {
                if (this.failNextReadIfPastEnd) {
                    throw new UnreliableBehaviorError("Did you forget to setDataPosition(0) before reading the parcel?");
                }
                return pastEndValue;
            }
            int startPosition = this.dataPosition;
            FakeEncodedItem item = this.readNextItem(clazz);
            if (item == null) {
                return pastEndValue;
            }
            if (item.value == null && allowNull) {
                return null;
            }
            if (clazz.isInstance(item.value)) {
                return clazz.cast(item.value);
            }
            throw new RuntimeException((Throwable)((Object)new UnreliableBehaviorError(clazz, startPosition, item, "and it is non-portable to reinterpret it")));
        }

        private boolean readZeroes(int bytes) {
            int endPosition = this.dataPosition + bytes;
            if (endPosition > this.dataSize) {
                return false;
            }
            for (int i = this.dataPosition; i < endPosition; ++i) {
                if (this.data[i] != null && this.data[i].isEncodedAsAllZeroBytes) continue;
                return false;
            }
            this.dataPosition = endPosition;
            return true;
        }

        private <T> T readPrimitive(int defaultSizeBytes, T defaultValue, Class<T> clazz) {
            if (this.readZeroes(defaultSizeBytes)) {
                return defaultValue;
            }
            return this.readValue(defaultValue, clazz, false);
        }

        private void writeItem(FakeEncodedItem item) {
            int endPosition = this.dataPosition + item.sizeBytes;
            if (endPosition > this.data.length) {
                this.setDataCapacityAtLeast(endPosition * 3 / 2);
            }
            if (endPosition > this.dataSize) {
                this.failNextReadIfPastEnd = true;
                this.dataSize = endPosition;
            }
            Arrays.fill(this.data, this.dataPosition, endPosition, item);
            this.dataPosition = endPosition;
        }

        private void writeValue(int unpaddedSizeBytes, Object o) {
            this.writeItem(new FakeEncodedItem(this.alignToInt(unpaddedSizeBytes), o));
        }

        private static class FakeEncodedItem
        implements Serializable {
            final int sizeBytes;
            final Object value;
            final boolean isEncodedAsAllZeroBytes;

            FakeEncodedItem(int sizeBytes, Object value) {
                this.sizeBytes = sizeBytes;
                this.value = value;
                this.isEncodedAsAllZeroBytes = ByteBuffer.isEncodedAsAllZeroBytes(value);
            }
        }
    }

    static class UnreliableBehaviorError
    extends AssertionError {
        UnreliableBehaviorError(String message) {
            super((Object)message);
        }

        UnreliableBehaviorError(String message, Throwable cause) {
            super(message, cause);
        }

        UnreliableBehaviorError(Class<?> clazz, int position, ByteBuffer.FakeEncodedItem item, String extraMessage) {
            super((Object)String.format(Locale.US, "Looking for %s at position %d, found %s [%s] taking %d bytes, %s", clazz.getSimpleName(), position, item.value == null ? "null" : item.value.getClass().getSimpleName(), item.value, item.sizeBytes, extraMessage));
        }
    }
}

