/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import com.google.errorprone.annotations.DoNotCall;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.RegionNatives;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowRegion;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Region.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeRegion {
    RegionNatives regionNatives = new RegionNatives();
    @RealObject
    Region realRegion;

    @Implementation(minSdk=26, maxSdk=34)
    protected void __constructor__(long ni) {
        Shadow.invokeConstructor(Region.class, (Object)this.realRegion, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ni)});
        this.regionNatives.mNativeRegion = ni;
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected void __constructor__(int left, int top, int right, int bottom) {
        Shadow.invokeConstructor(Region.class, (Object)this.realRegion, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)left), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)top), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)right), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)bottom)});
        this.regionNatives.mNativeRegion = ((RegionReflector)Reflector.reflector(RegionReflector.class, (Object)this.realRegion)).getNativeRegion();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected void __constructor__(Rect rect) {
        Shadow.invokeConstructor(Region.class, (Object)this.realRegion, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Rect.class, (Object)rect)});
        this.regionNatives.mNativeRegion = ((RegionReflector)Reflector.reflector(RegionReflector.class, (Object)this.realRegion)).getNativeRegion();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeEquals(long nativeR1, long nativeR2) {
        return RegionNatives.nativeEquals((long)nativeR1, (long)nativeR2);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nativeConstructor() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return RegionNatives.nativeConstructor();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nativeDestructor(long nativeRegion) {
        RegionNatives.nativeDestructor((long)nativeRegion);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nativeSetRegion(long nativeDst, long nativeSrc) {
        RegionNatives.nativeSetRegion((long)nativeDst, (long)nativeSrc);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeSetRect(long nativeDst, int left, int top, int right, int bottom) {
        return RegionNatives.nativeSetRect((long)nativeDst, (int)left, (int)top, (int)right, (int)bottom);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeSetPath(long nativeDst, long nativePath, long nativeClip) {
        return RegionNatives.nativeSetPath((long)nativeDst, (long)nativePath, (long)nativeClip);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeGetBounds(long nativeRegion, Rect rect) {
        return RegionNatives.nativeGetBounds((long)nativeRegion, (Rect)rect);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeGetBoundaryPath(long nativeRegion, long nativePath) {
        return RegionNatives.nativeGetBoundaryPath((long)nativeRegion, (long)nativePath);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeOp(long nativeDst, int left, int top, int right, int bottom, int op) {
        return RegionNatives.nativeOp((long)nativeDst, (int)left, (int)top, (int)right, (int)bottom, (int)op);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeOp(long nativeDst, Rect rect, long nativeRegion, int op) {
        return RegionNatives.nativeOp((long)nativeDst, (Rect)rect, (long)nativeRegion, (int)op);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeOp(long nativeDst, long nativeRegion1, long nativeRegion2, int op) {
        return RegionNatives.nativeOp((long)nativeDst, (long)nativeRegion1, (long)nativeRegion2, (int)op);
    }

    @Implementation(minSdk=26, maxSdk=34)
    @DoNotCall(value="Always throws java.lang.UnsupportedOperationException")
    protected static long nativeCreateFromParcel(Parcel p) {
        throw new UnsupportedOperationException();
    }

    @Implementation(minSdk=26, maxSdk=34)
    @DoNotCall(value="Always throws java.lang.UnsupportedOperationException")
    protected static boolean nativeWriteToParcel(long nativeRegion, Parcel p) {
        throw new UnsupportedOperationException();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static String nativeToString(long nativeRegion) {
        return RegionNatives.nativeToString((long)nativeRegion);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean isEmpty() {
        return this.regionNatives.isEmpty();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean isRect() {
        return this.regionNatives.isRect();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean isComplex() {
        return this.regionNatives.isComplex();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean contains(int x, int y) {
        return this.regionNatives.contains(x, y);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean quickContains(int left, int top, int right, int bottom) {
        return this.regionNatives.quickContains(left, top, right, bottom);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean quickReject(int left, int top, int right, int bottom) {
        return this.regionNatives.quickReject(left, top, right, bottom);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected boolean quickReject(Region rgn) {
        return this.regionNatives.quickReject(rgn);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected void translate(int dx, int dy, Region dst) {
        this.regionNatives.translate(dx, dy, dst);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected void scale(float scale, Region dst) {
        this.regionNatives.scale(scale, dst);
    }

    @ForType(value=Region.class)
    static interface RegionReflector {
        @Accessor(value="mNativeRegion")
        public long getNativeRegion();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowRegion.class, ShadowNativeRegion.class);
        }
    }
}

