/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.XmlBlock;
import android.util.TypedValue;
import dalvik.system.VMRuntime;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowVMRuntime;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AssetManager.class, minSdk=35, callNativeMethodsByDefault=true, shadowPicker=ShadowAssetManager.Picker.class)
public class ShadowNativeAssetManager
extends ShadowAssetManager {
    @ReflectorObject
    private AssetManagerReflector assetManagerReflector;

    @Override
    Collection<Path> getAllAssetDirs() {
        throw new UnsupportedOperationException();
    }

    @Override
    long getNativePtr() {
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected void applyStyle(long themePtr, int defStyleAttr, int defStyleRes, XmlBlock.Parser parser, int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Objects.requireNonNull(inAttrs, "inAttrs");
        PerfStatsCollector.getInstance().measure("native applyStyle", () -> {
            ShadowVMRuntime shadowVmRuntime = (ShadowVMRuntime)Shadow.extract((Object)VMRuntime.getRuntime());
            int[] outValues = (int[])shadowVmRuntime.getObjectForAddress(outValuesAddress);
            int[] outIndices = (int[])shadowVmRuntime.getObjectForAddress(outIndicesAddress);
            ShadowNativeAssetManager shadowNativeAssetManager = this;
            synchronized (shadowNativeAssetManager) {
                this.assetManagerReflector.ensureValidLocked();
                long xmlParserPtr = parser != null ? ((XmlBlockParserReflector)Reflector.reflector(XmlBlockParserReflector.class, (Object)parser)).getParseState() : 0L;
                ReflectionHelpers.callStaticMethod(AssetManager.class, (String)Shadow.directNativeMethodName((String)AssetManager.class.getName(), (String)"nativeApplyStyleWithArray"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.assetManagerReflector.getObject()), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)themePtr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)defStyleAttr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)defStyleRes), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)xmlParserPtr), ReflectionHelpers.ClassParameter.from(int[].class, (Object)inAttrs), ReflectionHelpers.ClassParameter.from(int[].class, (Object)outValues), ReflectionHelpers.ClassParameter.from(int[].class, (Object)outIndices)});
            }
        });
    }

    @Implementation
    protected static int nativeGetResourceValue(long ptr, int resid, short density, TypedValue typed_value, boolean resolve_references) {
        return (Integer)PerfStatsCollector.getInstance().measure("native nativeGetResourceValue", () -> (Integer)ReflectionHelpers.callStaticMethod(AssetManager.class, (String)Shadow.directNativeMethodName((String)AssetManager.class.getName(), (String)"nativeGetResourceValue"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ptr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)resid), ReflectionHelpers.ClassParameter.from(Short.TYPE, (Object)density), ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)typed_value), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)resolve_references)}));
    }

    @ForType(value=AssetManager.class)
    static interface AssetManagerReflector {
        @Accessor(value="mObject")
        public long getObject();

        public void ensureValidLocked();
    }

    @ForType(value=XmlBlock.Parser.class)
    static interface XmlBlockParserReflector {
        @Accessor(value="mParseState")
        public long getParseState();
    }
}

