/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.internal.DisplayConfig;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.util.Consumer;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Display.class)
public class ShadowDisplay {
    @RealObject
    Display realObject;
    private Float refreshRate;
    private Float scaledDensity;

    public static Display getDefaultDisplay() {
        WindowManager windowManager = (WindowManager)RuntimeEnvironment.getApplication().getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    @Deprecated
    @Implementation
    protected void getMetrics(DisplayMetrics outMetrics) {
        ((_Display_)Reflector.reflector(_Display_.class, (Object)this.realObject)).getMetrics(outMetrics);
        if (this.scaledDensity != null) {
            outMetrics.scaledDensity = this.scaledDensity.floatValue();
        }
    }

    @Deprecated
    @Implementation
    protected void getRealMetrics(DisplayMetrics outMetrics) {
        ((_Display_)Reflector.reflector(_Display_.class, (Object)this.realObject)).getRealMetrics(outMetrics);
        if (this.scaledDensity != null) {
            outMetrics.scaledDensity = this.scaledDensity.floatValue();
        }
    }

    @Deprecated
    public void setScaledDensity(float scaledDensity) {
        this.scaledDensity = Float.valueOf(scaledDensity);
    }

    @Deprecated
    @Implementation
    protected float getRefreshRate() {
        if (this.refreshRate != null) {
            return this.refreshRate.floatValue();
        }
        float realRefreshRate = ((_Display_)Reflector.reflector(_Display_.class, (Object)this.realObject)).getRefreshRate();
        if ((double)realRefreshRate < 0.1) {
            realRefreshRate = 60.0f;
        }
        return realRefreshRate;
    }

    public void setDensity(float density) {
        this.setDensityDpi((int)(density * 160.0f));
    }

    public void setDensityDpi(int densityDpi) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.logicalDensityDpi = densityDpi;
        }));
    }

    public void setXdpi(float xdpi) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.physicalXDpi = xdpi;
        }));
    }

    public void setYdpi(float ydpi) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.physicalYDpi = ydpi;
        }));
    }

    public void setName(String name) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.name = name;
        }));
    }

    public void setFlags(int flags) {
        ((_Display_)Reflector.reflector(_Display_.class, (Object)this.realObject)).setFlags(flags);
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.flags = flags;
        }));
    }

    public void setWidth(int width) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.appWidth = width;
        }));
    }

    public void setHeight(int height) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.appHeight = height;
        }));
    }

    public void setRealWidth(int width) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.logicalWidth = width;
        }));
    }

    public void setRealHeight(int height) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.logicalHeight = height;
        }));
    }

    public void setRefreshRate(float refreshRate) {
        this.refreshRate = Float.valueOf(refreshRate);
    }

    public void setRotation(int rotation) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.rotation = rotation;
        }));
    }

    public void setState(int state) {
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
            di.state = state;
        }));
    }

    public void setDisplayHdrCapabilities(int displayId, float maxLuminance, float maxAverageLuminance, float minLuminance, int ... supportedHdrTypes) {
        if (Build.VERSION.SDK_INT < 24) {
            throw new UnsupportedOperationException("HDR capabilities are not supported below Android N");
        }
        if (RuntimeEnvironment.getApiLevel() > 33) {
            ((DisplayModeReflector)Reflector.reflector(DisplayModeReflector.class, (Object)this.realObject.getMode())).setSupportedHdrTypes(supportedHdrTypes);
        }
        ShadowDisplayManager.changeDisplay(displayId, (Consumer<DisplayConfig>)((Consumer)displayConfig -> {
            displayConfig.hdrCapabilities = new Display.HdrCapabilities(supportedHdrTypes, maxLuminance, maxAverageLuminance, minLuminance);
        }));
    }

    public void setHdrSdrRatio(float hdrSdrRatio) {
        if (Build.VERSION.SDK_INT < 34) {
            throw new UnsupportedOperationException("setHdrSdrRatio is not supported below Android U");
        }
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)displayConfig -> {
            displayConfig.hdrSdrRatio = hdrSdrRatio;
        }));
    }

    public void setDisplayCutout(Object displayCutout) {
        if (Build.VERSION.SDK_INT < 29) {
            throw new UnsupportedOperationException("Display cutouts are not supported below Android Q");
        }
        ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)displayConfig -> {
            displayConfig.displayCutout = displayCutout;
        }));
    }

    @ForType(value=Display.class)
    static interface _Display_ {
        @Direct
        public void getMetrics(DisplayMetrics var1);

        @Direct
        public void getRealMetrics(DisplayMetrics var1);

        @Direct
        public float getRefreshRate();

        @Accessor(value="mFlags")
        public void setFlags(int var1);
    }

    @ForType(value=Display.Mode.class)
    static interface DisplayModeReflector {
        @Accessor(value="mSupportedHdrTypes")
        public void setSupportedHdrTypes(int[] var1);
    }
}

