/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.BiometricManager;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.hardware.biometrics.BiometricManager", minSdk=29, isInAndroidSdk=false)
public class ShadowBiometricManager {
    protected static boolean biometricServiceConnected = true;
    private static int authenticatorType = 0;
    @RealObject
    private BiometricManager realBiometricManager;

    @Resetter
    public static void reset() {
        biometricServiceConnected = true;
        authenticatorType = 0;
    }

    @Implementation
    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    protected int canAuthenticate() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return ((BiometricManagerReflector)Reflector.reflector(BiometricManagerReflector.class, (Object)this.realBiometricManager)).canAuthenticate();
        }
        int biometricResult = this.canAuthenticateInternal(0, 255);
        if (biometricServiceConnected) {
            return 0;
        }
        if (biometricResult != 0) {
            return biometricResult;
        }
        boolean hasBiometrics = (Boolean)ReflectionHelpers.callStaticMethod(BiometricManager.class, (String)"hasBiometrics", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.getApplication().getApplicationContext())});
        if (!hasBiometrics) {
            return 12;
        }
        return 1;
    }

    @Implementation(minSdk=30)
    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    protected int canAuthenticate(int authenticators) {
        return this.canAuthenticateInternal(0, authenticators);
    }

    @Implementation(minSdk=30)
    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    protected int canAuthenticate(int userId, int authenticators) {
        return this.canAuthenticateInternal(userId, authenticators);
    }

    private int canAuthenticateInternal(int userId, int authenticators) {
        if (authenticatorType == 15 && biometricServiceConnected) {
            return 0;
        }
        if ((authenticatorType & 0x8000) == 32768) {
            return 0;
        }
        if (authenticatorType != 0) {
            return authenticatorType;
        }
        if (!biometricServiceConnected) {
            return 12;
        }
        return 0;
    }

    public void setCanAuthenticate(boolean flag) {
        biometricServiceConnected = flag;
    }

    public void setAuthenticatorType(int type) {
        authenticatorType = type;
    }

    @ForType(value=BiometricManager.class)
    static interface BiometricManagerReflector {
        @Direct
        public int canAuthenticate();
    }
}

