/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import com.google.common.base.Preconditions;
import org.robolectric.util.ReflectionHelpers;

public class SensorEventBuilder {
    private float[] values;
    private int accuracy = 0;
    private long timestampNs = 0L;
    private Sensor sourceSensor = null;

    private SensorEventBuilder() {
    }

    public static SensorEventBuilder newBuilder() {
        return new SensorEventBuilder();
    }

    public SensorEventBuilder setValues(@NonNull float[] value) {
        this.values = value;
        return this;
    }

    public SensorEventBuilder setSensor(@NonNull Sensor value) {
        this.sourceSensor = value;
        return this;
    }

    public SensorEventBuilder setTimestamp(long value) {
        this.timestampNs = value;
        return this;
    }

    public SensorEventBuilder setAccuracy(int value) {
        this.accuracy = value;
        return this;
    }

    public SensorEvent build() {
        Preconditions.checkArgument((this.values != null && this.values.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.sourceSensor != null ? 1 : 0) != 0);
        SensorEvent sensorEvent = (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.values.length)});
        System.arraycopy(this.values, 0, sensorEvent.values, 0, this.values.length);
        sensorEvent.accuracy = this.accuracy;
        sensorEvent.timestamp = this.timestampNs;
        sensorEvent.sensor = this.sourceSensor;
        return sensorEvent;
    }
}

