/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.util.concurrent;

import android.annotation.NonNull;
import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.robolectric.android.util.concurrent.PausedExecutorService;

@Beta
public class InlineExecutorService
implements ExecutorService {
    private final PausedExecutorService delegateService = new PausedExecutorService();

    @Override
    public void shutdown() {
        this.delegateService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegateService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegateService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegateService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegateService.awaitTermination(l, timeUnit);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        Future<T> future = this.delegateService.submit(task);
        this.delegateService.runAll();
        return future;
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Runnable task, T result) {
        Future<T> future = this.delegateService.submit(task, result);
        this.delegateService.runAll();
        return future;
    }

    @Override
    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        Future<?> future = this.delegateService.submit(task);
        this.delegateService.runAll();
        return future;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.delegateService.execute(command);
        this.delegateService.runAll();
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegateService.invokeAll(tasks);
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return this.delegateService.invokeAll(tasks, timeout, unit);
    }

    @Override
    @NonNull
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        return this.delegateService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.delegateService.invokeAny(tasks, timeout, unit);
    }
}

