/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public final class StreamConfigurationMapBuilder {
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private final HashMap<Integer, Collection<Size>> inputFormatWithSupportedSize = new HashMap();
    private final HashMap<Integer, Collection<Size>> outputFormatWithSupportedSize = new HashMap();

    public static StreamConfigurationMapBuilder newBuilder() {
        return new StreamConfigurationMapBuilder();
    }

    public StreamConfigurationMapBuilder addOutputSize(int format, Size outputSize) {
        if (!this.outputFormatWithSupportedSize.containsKey(format)) {
            ArrayList outputSizes = new ArrayList();
            this.outputFormatWithSupportedSize.put(format, outputSizes);
        }
        this.outputFormatWithSupportedSize.get(format).add(outputSize);
        return this;
    }

    public StreamConfigurationMapBuilder addInputSize(int format, Size inputSize) {
        if (!this.inputFormatWithSupportedSize.containsKey(format)) {
            ArrayList inputSizes = new ArrayList();
            this.inputFormatWithSupportedSize.put(format, inputSizes);
        }
        this.inputFormatWithSupportedSize.get(format).add(inputSize);
        return this;
    }

    public StreamConfigurationMapBuilder addOutputSize(Size outputSize) {
        this.addOutputSize(34, outputSize);
        return this;
    }

    public StreamConfigurationMap build() {
        SparseIntArray outputFormats;
        ArrayList<StreamConfiguration> configsList = new ArrayList<StreamConfiguration>();
        for (Map.Entry<Integer, Collection<Size>> entry : this.outputFormatWithSupportedSize.entrySet()) {
            for (Size size : entry.getValue()) {
                configsList.add(new StreamConfiguration(entry.getKey().intValue(), size.getWidth(), size.getHeight(), false));
            }
        }
        for (Map.Entry<Integer, Collection<Size>> entry : this.inputFormatWithSupportedSize.entrySet()) {
            for (Size size : entry.getValue()) {
                configsList.add(new StreamConfiguration(entry.getKey().intValue(), size.getWidth(), size.getHeight(), true));
            }
        }
        StreamConfiguration[] configs = new StreamConfiguration[configsList.size()];
        configsList.toArray(configs);
        StreamConfigurationMap map = (StreamConfigurationMap)ReflectionHelpers.callConstructor(StreamConfigurationMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mConfigurations", (Object)configs);
        if (RuntimeEnvironment.getApiLevel() < 23) {
            outputFormats = new HashMap();
            for (int format : this.outputFormatWithSupportedSize.keySet()) {
                outputFormats.put(format, this.outputFormatWithSupportedSize.get(format).size());
            }
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mOutputFormats", (Object)outputFormats);
        } else {
            outputFormats = new SparseIntArray();
            for (int format : this.outputFormatWithSupportedSize.keySet()) {
                outputFormats.put(format, this.outputFormatWithSupportedSize.get(format).size());
            }
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mOutputFormats", (Object)outputFormats);
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mAllOutputFormats", (Object)outputFormats);
            SparseIntArray sparseIntArray = new SparseIntArray();
            for (int format : this.inputFormatWithSupportedSize.keySet()) {
                sparseIntArray.put(format, this.inputFormatWithSupportedSize.get(format).size());
            }
            ReflectionHelpers.setField(StreamConfigurationMap.class, (Object)map, (String)"mInputFormats", (Object)sparseIntArray);
        }
        return map;
    }

    private StreamConfigurationMapBuilder() {
    }
}

