/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.IWifiScannerListener;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiScanner;
import android.os.Build;
import android.os.RemoteException;
import android.util.SparseArray;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=WifiScanner.class, isInAndroidSdk=false)
public class ShadowWifiScanner {
    @RealObject
    protected WifiScanner realWifiScanner;
    private List<ScanResult> scanResults = new ArrayList<ScanResult>();

    public void setScanResults(List<ScanResult> scanResults) {
        this.scanResults = scanResults;
        if (Build.VERSION.SDK_INT >= 34) {
            this.notifyScanListenersU();
        } else {
            this.notifyScanListeners();
        }
    }

    @Implementation(minSdk=30)
    protected List<ScanResult> getSingleScanResults() {
        return this.scanResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyScanListenersU() {
        Iterator listenerMapLock = ((WifiScannerReflector)Reflector.reflector(WifiScannerReflector.class, (Object)this.realWifiScanner)).getListenerMapLock();
        Map<WifiScanner.ActionListener, IWifiScannerListener.Stub> listenerMap = ((WifiScannerReflector)Reflector.reflector(WifiScannerReflector.class, (Object)this.realWifiScanner)).getListenerMap();
        ArrayList<IWifiScannerListener.Stub> listeners = null;
        Iterator iterator = listenerMapLock;
        synchronized (iterator) {
            listeners = new ArrayList<IWifiScannerListener.Stub>(listenerMap.values());
        }
        for (IWifiScannerListener.Stub listener : listeners) {
            try {
                listener.onResults(this.buildScanData());
            }
            catch (RemoteException e) {
                throw new RuntimeException("Failed to notify scan listeners", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyScanListeners() {
        Object listenerMapLock = ((WifiScannerReflector)Reflector.reflector(WifiScannerReflector.class, (Object)this.realWifiScanner)).getListenerMapLock();
        SparseArray listenerMap = null;
        SparseArray executorMap = null;
        Object object = listenerMapLock;
        synchronized (object) {
            listenerMap = ((WifiScannerReflector)Reflector.reflector(WifiScannerReflector.class, (Object)this.realWifiScanner)).getListenerSparseArray().clone();
            if (Build.VERSION.SDK_INT >= 30) {
                executorMap = ((WifiScannerReflector)Reflector.reflector(WifiScannerReflector.class, (Object)this.realWifiScanner)).getExecutorSparseArray().clone();
            }
        }
        for (int i = 0; i < listenerMap.size(); ++i) {
            int key = listenerMap.keyAt(i);
            Object value = listenerMap.valueAt(i);
            Executor executor = null;
            if (executorMap != null) {
                executor = (Executor)executorMap.get(key);
            }
            if (executor == null) {
                executor = MoreExecutors.directExecutor();
            }
            if (!(value instanceof WifiScanner.ScanListener)) continue;
            WifiScanner.ScanListener listener = (WifiScanner.ScanListener)value;
            executor.execute(() -> listener.onResults(this.buildScanData()));
        }
    }

    private WifiScanner.ScanData[] buildScanData() {
        return new WifiScanner.ScanData[]{new WifiScanner.ScanData(0, 0, this.scanResults.toArray(new ScanResult[0]))};
    }

    @ForType(value=WifiScanner.class)
    static interface WifiScannerReflector {
        @Accessor(value="mListenerMapLock")
        public Object getListenerMapLock();

        @Accessor(value="mListenerMap")
        public Map<WifiScanner.ActionListener, IWifiScannerListener.Stub> getListenerMap();

        @Accessor(value="mListenerMap")
        public SparseArray<Object> getListenerSparseArray();

        @Accessor(value="mExecutorMap")
        public SparseArray<Executor> getExecutorSparseArray();
    }
}

