/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.VirtualDevice;
import android.companion.virtual.VirtualDeviceManager;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensorDirectChannelCallback;
import android.content.Context;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.VirtualKeyboard;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouse;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualTouchscreen;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.IBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowVirtualSensor;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=VirtualDeviceManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowVirtualDeviceManager {
    private static final List<VirtualDeviceManager.VirtualDevice> mVirtualDevices = new ArrayList<VirtualDeviceManager.VirtualDevice>();
    private Context context;
    private static IVirtualDeviceManager service;

    @Implementation
    protected void __constructor__(IVirtualDeviceManager service, Context context) {
        this.context = context;
        ShadowVirtualDeviceManager.service = service;
    }

    @Implementation
    protected VirtualDeviceManager.VirtualDevice createVirtualDevice(int associationId, VirtualDeviceParams params) {
        VirtualDeviceManager.VirtualDevice device = (VirtualDeviceManager.VirtualDevice)ReflectionHelpers.callConstructor(VirtualDeviceManager.VirtualDevice.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IVirtualDeviceManager.class, (Object)service), ReflectionHelpers.ClassParameter.from(Context.class, (Object)this.context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)associationId), ReflectionHelpers.ClassParameter.from(VirtualDeviceParams.class, (Object)params)});
        mVirtualDevices.add(device);
        return device;
    }

    @Implementation
    protected List<VirtualDevice> getVirtualDevices() {
        return mVirtualDevices.stream().map(virtualDevice -> {
            VirtualDeviceReflector accessor = (VirtualDeviceReflector)Reflector.reflector(VirtualDeviceReflector.class);
            String deviceName = ((ShadowVirtualDevice)Shadow.extract((Object)virtualDevice)).getParams().getName();
            try {
                VirtualDevice.class.getDeclaredConstructor(Integer.TYPE, String.class);
                return accessor.newInstance(virtualDevice.getDeviceId(), deviceName);
            }
            catch (NoSuchMethodException e) {
                DeviceManagerVirtualDeviceReflector virtualDeviceReflector = (DeviceManagerVirtualDeviceReflector)Reflector.reflector(DeviceManagerVirtualDeviceReflector.class, (Object)virtualDevice);
                return accessor.newInstanceV((IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), virtualDevice.getDeviceId(), virtualDeviceReflector.getPersistentDeviceId(), deviceName);
            }
        }).collect(Collectors.toList());
    }

    @Implementation
    protected int getDevicePolicy(int deviceId, int policyType) {
        return mVirtualDevices.stream().filter(virtualDevice -> virtualDevice.getDeviceId() == deviceId).findFirst().map(virtualDevice -> ((ShadowVirtualDevice)Shadow.extract((Object)virtualDevice)).getParams().getDevicePolicy(policyType)).orElse(0);
    }

    @Implementation
    protected boolean isValidVirtualDeviceId(int deviceId) {
        return mVirtualDevices.stream().anyMatch(virtualDevice -> virtualDevice.getDeviceId() == deviceId);
    }

    @Implements(value=VirtualDeviceManager.VirtualDevice.class, minSdk=34, isInAndroidSdk=false)
    public static class ShadowVirtualDevice {
        private static final AtomicInteger nextDeviceId = new AtomicInteger(1);
        @RealObject
        VirtualDeviceManager.VirtualDevice realVirtualDevice;
        private VirtualDeviceParams params;
        private int deviceId;
        private String persistentDeviceId;
        private PendingIntent pendingIntent;
        private Integer pendingIntentResultCode = 0;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private Context context;
        private int associationId;

        @Implementation
        protected void __constructor__(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) {
            Shadow.invokeConstructor(VirtualDeviceManager.VirtualDevice.class, (Object)this.realVirtualDevice, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IVirtualDeviceManager.class, (Object)service), ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)associationId), ReflectionHelpers.ClassParameter.from(VirtualDeviceParams.class, (Object)params)});
            this.params = params;
            this.deviceId = nextDeviceId.getAndIncrement();
            this.context = context;
            this.associationId = associationId;
            this.persistentDeviceId = "companion:" + associationId;
        }

        @Implementation
        protected int getDeviceId() {
            return this.deviceId;
        }

        @Implementation
        protected Context createContext() {
            return this.context.createDeviceContext(this.deviceId);
        }

        @Implementation(minSdk=35)
        @Nullable
        protected String getPersistentDeviceId() {
            return this.persistentDeviceId;
        }

        @Implementation
        protected void close() {
            this.isClosed.set(true);
        }

        public boolean isClosed() {
            return this.isClosed.get();
        }

        VirtualDeviceParams getParams() {
            return this.params;
        }

        @Implementation
        protected List<VirtualSensor> getVirtualSensorList() {
            if (this.params.getVirtualSensorConfigs() == null) {
                return new ArrayList<VirtualSensor>();
            }
            return this.params.getVirtualSensorConfigs().stream().map(config -> {
                VirtualSensor sensor = new VirtualSensor(config.hashCode(), config.getType(), config.getName(), null, null);
                ShadowVirtualSensor shadowSensor = (ShadowVirtualSensor)Shadow.extract((Object)sensor);
                shadowSensor.setDeviceId(this.deviceId);
                return sensor;
            }).collect(Collectors.toList());
        }

        @Implementation
        protected void launchPendingIntent(int displayId, @NonNull PendingIntent pendingIntent, @NonNull Executor executor, @NonNull IntConsumer listener) {
            this.pendingIntent = pendingIntent;
            executor.execute(() -> listener.accept(this.pendingIntentResultCode));
        }

        @Implementation
        protected VirtualMouse createVirtualMouse(@NonNull VirtualDisplay display, @NonNull String inputDeviceName, int vendorId, int productId) {
            return this.createVirtualMouse(((VirtualMouseConfig.Builder)new VirtualMouseConfig.Builder().setInputDeviceName(inputDeviceName)).build());
        }

        @Implementation
        protected VirtualMouse createVirtualMouse(@NonNull VirtualMouseConfig config) {
            Binder token = new Binder("android.hardware.input.VirtualMouse:" + config.getInputDeviceName());
            VirtualMouseReflector accessor = (VirtualMouseReflector)Reflector.reflector(VirtualMouseReflector.class);
            if (RuntimeEnvironment.getApiLevel() <= 34) {
                return accessor.newInstance((IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
            }
            return accessor.newInstanceV(config, (IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
        }

        @Implementation
        protected void setShowPointerIcon(boolean showPointerIcon) {
        }

        @Implementation
        protected VirtualTouchscreen createVirtualTouchscreen(@NonNull VirtualDisplay display, @NonNull String inputDeviceName, int vendorId, int productId) {
            int displayWidth = 720;
            int displayHeight = 1280;
            return this.createVirtualTouchscreen(((VirtualTouchscreenConfig.Builder)new VirtualTouchscreenConfig.Builder(displayWidth, displayHeight).setInputDeviceName(inputDeviceName)).build());
        }

        @Implementation
        protected VirtualTouchscreen createVirtualTouchscreen(@NonNull VirtualTouchscreenConfig config) {
            Binder token = new Binder("android.hardware.input.VirtualTouchscreen:" + config.getInputDeviceName());
            VirtualTouchscreenReflector accessor = (VirtualTouchscreenReflector)Reflector.reflector(VirtualTouchscreenReflector.class);
            if (RuntimeEnvironment.getApiLevel() <= 34) {
                return accessor.newInstance((IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
            }
            return accessor.newInstanceV(config, (IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
        }

        @Implementation
        protected VirtualKeyboard createVirtualKeyboard(@NonNull VirtualKeyboardConfig config) {
            Binder token = new Binder("android.hardware.input.VirtualKeyboard:" + config.getInputDeviceName());
            VirtualKeyboardReflector accessor = (VirtualKeyboardReflector)Reflector.reflector(VirtualKeyboardReflector.class);
            if (RuntimeEnvironment.getApiLevel() <= 34) {
                return accessor.newInstance((IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
            }
            return accessor.newInstanceV(config, (IVirtualDevice)ReflectionHelpers.createNullProxy(IVirtualDevice.class), (IBinder)token);
        }

        @Implementation
        protected VirtualDisplay createVirtualDisplay(@NonNull VirtualDisplayConfig config, @Nullable Executor executor, @Nullable VirtualDisplay.Callback callback) {
            return DisplayManagerGlobal.getInstance().createVirtualDisplay(this.context, null, config, callback, executor);
        }

        public void setPendingIntentCallbackResultCode(int resultCode) {
            this.pendingIntentResultCode = resultCode;
        }

        public PendingIntent getLastLaunchedPendingIntent() {
            return this.pendingIntent;
        }

        public VirtualSensorCallback getVirtualSensorCallback() {
            return this.params.getVirtualSensorCallback() == null ? null : ((VirtualSensorCallbackDelegateReflector)Reflector.reflector(VirtualSensorCallbackDelegateReflector.class, (Object)this.params.getVirtualSensorCallback())).getCallback();
        }

        public VirtualSensorDirectChannelCallback getVirtualSensorDirectChannelCallback() {
            return this.params.getVirtualSensorCallback() == null ? null : ((VirtualSensorCallbackDelegateReflector)Reflector.reflector(VirtualSensorCallbackDelegateReflector.class, (Object)this.params.getVirtualSensorCallback())).getDirectChannelCallback();
        }

        @Resetter
        public static void reset() {
            nextDeviceId.set(1);
            mVirtualDevices.clear();
            service = null;
        }
    }

    @ForType(value=VirtualDevice.class)
    private static interface VirtualDeviceReflector {
        @Constructor
        public VirtualDevice newInstanceV(IVirtualDevice var1, int var2, String var3, String var4);

        @Constructor
        public VirtualDevice newInstance(int var1, String var2);
    }

    @ForType(value=VirtualDeviceManager.VirtualDevice.class)
    private static interface DeviceManagerVirtualDeviceReflector {
        public String getPersistentDeviceId();
    }

    @ForType(value=VirtualKeyboard.class)
    private static interface VirtualKeyboardReflector {
        @Constructor
        public VirtualKeyboard newInstanceV(VirtualKeyboardConfig var1, IVirtualDevice var2, IBinder var3);

        @Constructor
        public VirtualKeyboard newInstance(IVirtualDevice var1, IBinder var2);
    }

    @ForType(value=VirtualTouchscreen.class)
    private static interface VirtualTouchscreenReflector {
        @Constructor
        public VirtualTouchscreen newInstanceV(VirtualTouchscreenConfig var1, IVirtualDevice var2, IBinder var3);

        @Constructor
        public VirtualTouchscreen newInstance(IVirtualDevice var1, IBinder var2);
    }

    @ForType(value=VirtualMouse.class)
    private static interface VirtualMouseReflector {
        @Constructor
        public VirtualMouse newInstanceV(VirtualMouseConfig var1, IVirtualDevice var2, IBinder var3);

        @Constructor
        public VirtualMouse newInstance(IVirtualDevice var1, IBinder var2);
    }

    @ForType(className="android.companion.virtual.VirtualDeviceParams$Builder$VirtualSensorCallbackDelegate")
    private static interface VirtualSensorCallbackDelegateReflector {
        @Accessor(value="mCallback")
        public VirtualSensorCallback getCallback();

        @Accessor(value="mDirectChannelCallback")
        public VirtualSensorDirectChannelCallback getDirectChannelCallback();
    }
}

