/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.google.common.base.Preconditions;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=VMRuntime.class, isInAndroidSdk=false)
public class ShadowVMRuntime {
    private final Map<Object, ByteBuffer> realNonMovableArrays = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Long, WeakReference<Object>> nonMovableArraysReverse = Collections.synchronizedMap(new HashMap());
    private final Map<Object, Long> fakeNonMovableArrays = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicLong nextFakeArrayPointer = new AtomicLong();
    private static Method addressMethod;
    private static boolean is64Bit;
    @Nullable
    private static String currentInstructionSet;

    @Implementation
    public Object newUnpaddedArray(Class<?> klass, int size) {
        return Array.newInstance(klass, size);
    }

    @Implementation
    public Object newNonMovableArray(Class<?> type, int size) {
        Preconditions.checkArgument((type == Integer.TYPE || type == Float.TYPE ? 1 : 0) != 0, (String)"unsupported type %s", (Object)type.getName());
        Object arrayInstance = Array.newInstance(type, size);
        if (type == Float.TYPE && size == 8) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4 * size);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.realNonMovableArrays.put(arrayInstance, byteBuffer);
            this.nonMovableArraysReverse.put(this.getAddressOfDirectByteBuffer(byteBuffer), new WeakReference<Object>(arrayInstance));
        } else {
            long fakePointer = this.nextFakeArrayPointer.incrementAndGet();
            this.fakeNonMovableArrays.put(arrayInstance, fakePointer);
            this.nonMovableArraysReverse.put(fakePointer, new WeakReference<Object>(arrayInstance));
        }
        return arrayInstance;
    }

    @Implementation
    public long addressOf(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Preconditions.checkArgument((boolean)obj.getClass().isArray(), (Object)"addressOf(Object) is only supported for array objects");
        Class<?> arrayClass = obj.getClass().getComponentType();
        Preconditions.checkArgument((boolean)arrayClass.isPrimitive(), (Object)"addressOf(Object) is only supported for primitive array objects");
        if (arrayClass == Float.TYPE && Array.getLength(obj) == 8) {
            ByteBuffer byteBuffer = this.realNonMovableArrays.get(obj);
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Trying to get address of unknown object");
            }
            return this.getAddressOfDirectByteBuffer(byteBuffer);
        }
        Long address = this.fakeNonMovableArrays.get(obj);
        if (address == null) {
            throw new IllegalArgumentException("Trying to get address of unknown object");
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAddressOfDirectByteBuffer(ByteBuffer byteBuffer) {
        Class<ShadowVMRuntime> clazz = ShadowVMRuntime.class;
        synchronized (ShadowVMRuntime.class) {
            if (addressMethod == null) {
                try {
                    addressMethod = Class.forName("java.nio.DirectByteBuffer").getMethod("address", new Class[0]);
                    addressMethod.setAccessible(true);
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError("Error accessing address method", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                return (Long)addressMethod.invoke((Object)byteBuffer, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError("Error invoking address method", e);
            }
        }
    }

    @Nullable
    Object getObjectForAddress(long address) {
        WeakReference<Object> weakReference = this.nonMovableArraysReverse.get(address);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    @Implementation
    protected boolean is64Bit() {
        return is64Bit;
    }

    public static void setIs64Bit(boolean is64Bit) {
        ShadowVMRuntime.is64Bit = is64Bit;
    }

    @Implementation
    protected static String getCurrentInstructionSet() {
        return currentInstructionSet;
    }

    public static void setCurrentInstructionSet(@Nullable String currentInstructionSet) {
        ShadowVMRuntime.currentInstructionSet = currentInstructionSet;
    }

    ByteBuffer getBackingBuffer(long address) {
        Object array = this.getObjectForAddress(address);
        if (array == null) {
            return null;
        }
        return this.realNonMovableArrays.get(array);
    }

    @Resetter
    public static void reset() {
        is64Bit = true;
        currentInstructionSet = null;
    }

    @Implementation(minSdk=29)
    protected static int getNotifyNativeInterval() {
        return 384;
    }

    static {
        is64Bit = true;
        currentInstructionSet = null;
    }
}

