/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.StatsManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=StatsManager.class, isInAndroidSdk=false, minSdk=28)
public class ShadowStatsManager {
    private static final Map<Long, byte[]> reportDataMap = new HashMap<Long, byte[]>();
    private static byte[] statsMetadata = new byte[0];
    private static final Map<Long, byte[]> configDataMap = new HashMap<Long, byte[]>();

    @Resetter
    public static void reset() {
        reportDataMap.clear();
        statsMetadata = new byte[0];
        configDataMap.clear();
    }

    public static void addReportData(long configKey, byte[] data) {
        reportDataMap.put(configKey, data);
    }

    public static void setStatsMetadata(byte[] metadata) {
        statsMetadata = metadata;
    }

    public static byte[] getConfigData(long configKey) {
        return configDataMap.getOrDefault(configKey, new byte[0]);
    }

    @Implementation
    protected byte[] getReports(long configKey) {
        byte[] data = reportDataMap.getOrDefault(configKey, new byte[0]);
        reportDataMap.remove(configKey);
        return data;
    }

    @Implementation
    protected byte[] getStatsMetadata() {
        return statsMetadata;
    }

    @Implementation
    protected void addConfig(long configKey, byte[] config) {
        configDataMap.put(configKey, config);
    }

    @Implementation
    protected void removeConfig(long configKey) {
        configDataMap.remove(configKey);
    }
}

