/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Parcel;
import android.os.Parcelable;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SigningInfo.class, minSdk=28)
public class ShadowSigningInfo {
    public static final Parcelable.Creator<SigningInfo> CREATOR = new Parcelable.Creator<SigningInfo>(){

        public SigningInfo createFromParcel(Parcel in) {
            SigningInfo signingInfo = (SigningInfo)Shadow.newInstanceOf(SigningInfo.class);
            Shadows.shadowOf(signingInfo).setSignatures((Signature[])in.createTypedArray(Signature.CREATOR));
            Shadows.shadowOf(signingInfo).setPastSigningCertificates((Signature[])in.createTypedArray(Signature.CREATOR));
            return signingInfo;
        }

        public SigningInfo[] newArray(int size) {
            return new SigningInfo[size];
        }
    };
    private Signature[] signatures;
    private Signature[] pastSigningCertificates;

    public void setSignatures(Signature[] signatures) {
        this.signatures = signatures;
    }

    public void setPastSigningCertificates(Signature[] pastSigningCertificates) {
        this.pastSigningCertificates = pastSigningCertificates;
    }

    @Implementation
    protected boolean hasMultipleSigners() {
        return this.signatures != null && this.signatures.length > 1;
    }

    @Implementation
    protected boolean hasPastSigningCertificates() {
        return this.signatures != null && this.pastSigningCertificates != null;
    }

    @Implementation
    protected Signature[] getSigningCertificateHistory() {
        if (this.hasMultipleSigners()) {
            return null;
        }
        if (!this.hasPastSigningCertificates()) {
            return this.signatures;
        }
        return this.pastSigningCertificates;
    }

    @Implementation
    protected Signature[] getApkContentsSigners() {
        return this.signatures;
    }

    @Implementation
    public void writeToParcel(Parcel parcel, int flags) {
        ReflectionHelpers.setStaticField(SigningInfo.class, (String)"CREATOR", CREATOR);
        parcel.writeTypedArray((Parcelable[])this.signatures, flags);
        parcel.writeTypedArray((Parcelable[])this.pastSigningCertificates, flags);
    }
}

