/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothSocket.class)
public class ShadowBluetoothSocket {
    private final PipedOutputStream inputStreamFeeder = new PipedOutputStream();
    private final PipedInputStream outputStreamSink = new PipedInputStream();
    private OutputStream outputStream;
    private final InputStream inputStream;
    private SocketState state = SocketState.INIT;

    public ShadowBluetoothSocket() {
        try {
            this.outputStream = new PipedOutputStream(this.outputStreamSink);
            this.inputStream = new PipedInputStream(this.inputStreamFeeder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOutputStream(PipedOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public PipedOutputStream getInputStreamFeeder() {
        return this.inputStreamFeeder;
    }

    public PipedInputStream getOutputStreamSink() {
        return this.outputStreamSink;
    }

    @Implementation
    protected InputStream getInputStream() {
        return this.inputStream;
    }

    @Implementation
    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Implementation
    protected boolean isConnected() {
        return this.state == SocketState.CONNECTED;
    }

    @Implementation
    protected void connect() throws IOException {
        if (this.state == SocketState.CLOSED) {
            throw new IOException("socket closed");
        }
        this.state = SocketState.CONNECTED;
    }

    @Implementation
    protected void close() throws IOException {
        this.state = SocketState.CLOSED;
    }

    private static enum SocketState {
        INIT,
        CONNECTED,
        CLOSED;

    }
}

