/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.AutoValue_ShadowBluetoothLeScanner_ScanParams;

@Implements(value=BluetoothLeScanner.class)
public class ShadowBluetoothLeScanner {
    private List<ScanParams> activeScanParams = new ArrayList<ScanParams>();
    private final Set<ScanResult> scanResults = new HashSet<ScanResult>();

    @Implementation
    protected void startScan(List<ScanFilter> filters, ScanSettings settings, ScanCallback callback) {
        Preconditions.checkNotNull((Object)callback);
        if (filters != null) {
            filters = Collections.unmodifiableList(filters);
        }
        this.activeScanParams.add(ScanParams.create(filters, settings, callback));
        for (ScanResult scanResult : this.scanResults) {
            if (filters != null && !filters.stream().anyMatch(f -> f.matches(scanResult))) continue;
            callback.onScanResult(1, scanResult);
        }
    }

    @Implementation(minSdk=26)
    protected int startScan(List<ScanFilter> filters, ScanSettings settings, PendingIntent pendingIntent) {
        if (filters != null) {
            filters = Collections.unmodifiableList(filters);
        }
        this.activeScanParams.add(ScanParams.create(filters, settings, pendingIntent));
        return 0;
    }

    @Implementation
    protected void stopScan(ScanCallback callback) {
        this.activeScanParams = Lists.newArrayList((Iterable)Iterables.filter(this.activeScanParams, input -> !Objects.equals(callback, input.scanCallback())));
    }

    @Implementation(minSdk=26)
    protected void stopScan(PendingIntent pendingIntent) {
        this.activeScanParams = Lists.newArrayList((Iterable)Iterables.filter(this.activeScanParams, input -> !Objects.equals(pendingIntent, input.pendingIntent())));
    }

    public Set<ScanCallback> getScanCallbacks() {
        ArrayList<ScanCallback> scanCallbacks = new ArrayList<ScanCallback>();
        for (ScanParams scanParams : this.activeScanParams) {
            if (scanParams.scanCallback() == null) continue;
            scanCallbacks.add(scanParams.scanCallback());
        }
        return Collections.unmodifiableSet(new HashSet(scanCallbacks));
    }

    public List<ScanParams> getActiveScans() {
        return Collections.unmodifiableList(this.activeScanParams);
    }

    public void addScanResult(ScanResult scanResult) {
        Preconditions.checkNotNull((Object)scanResult);
        this.scanResults.add(scanResult);
    }

    @AutoValue
    public static abstract class ScanParams {
        public abstract ImmutableList<ScanFilter> scanFilters();

        @Nullable
        public abstract ScanSettings scanSettings();

        @Nullable
        public abstract PendingIntent pendingIntent();

        @Nullable
        public abstract ScanCallback scanCallback();

        static ScanParams create(List<ScanFilter> filters, ScanSettings settings, ScanCallback scanCallback) {
            ImmutableList filtersCopy = filters == null ? ImmutableList.of() : ImmutableList.copyOf(filters);
            return new AutoValue_ShadowBluetoothLeScanner_ScanParams((ImmutableList<ScanFilter>)filtersCopy, settings, null, scanCallback);
        }

        static ScanParams create(List<ScanFilter> filters, ScanSettings settings, PendingIntent pendingIntent) {
            ImmutableList filtersCopy = filters == null ? ImmutableList.of() : ImmutableList.copyOf(filters);
            return new AutoValue_ShadowBluetoothLeScanner_ScanParams((ImmutableList<ScanFilter>)filtersCopy, settings, pendingIntent, null);
        }
    }
}

