/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowLegacyBitmap;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BitmapDrawable.class)
public class ShadowBitmapDrawable
extends ShadowDrawable {
    String drawableCreateFromStreamSource;
    String drawableCreateFromPath;
    @RealObject
    private BitmapDrawable realBitmapDrawable;

    @Implementation
    protected void draw(Canvas canvas) {
        if (ShadowView.useRealGraphics()) {
            ((BitmapDrawableReflector)Reflector.reflector(BitmapDrawableReflector.class, (Object)this.realBitmapDrawable)).draw(canvas);
        } else {
            Bitmap bitmap = this.realBitmapDrawable.getBitmap();
            if (bitmap == null) {
                return;
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.realBitmapDrawable.getPaint());
        }
    }

    @Override
    protected void setCreatedFromResId(int createdFromResId, String resourceName) {
        super.setCreatedFromResId(createdFromResId, resourceName);
        Bitmap bitmap = this.realBitmapDrawable.getBitmap();
        if (bitmap != null && Shadow.extract((Object)bitmap) instanceof ShadowLegacyBitmap) {
            ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
            if (shadowBitmap.createdFromResId == -1) {
                shadowBitmap.setCreatedFromResId(createdFromResId, resourceName);
            }
        }
    }

    @Override
    @Deprecated
    public int getCreatedFromResId() {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)this.realBitmapDrawable.getBitmap());
        return shadowBitmap.getCreatedFromResId();
    }

    public String getSource() {
        return this.drawableCreateFromStreamSource;
    }

    public String getPath() {
        return this.drawableCreateFromPath;
    }

    @ForType(value=BitmapDrawable.class)
    static interface BitmapDrawableReflector {
        @Direct
        public void draw(Canvas var1);
    }
}

