/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.admin.EnforcingAdmin;
import android.app.admin.PolicyState;
import android.app.admin.PolicyValue;
import java.util.LinkedHashMap;
import java.util.Map;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class PolicyStateBuilder {
    private Map<EnforcingAdmin, PolicyValue<?>> policiesSetByAdmins = new LinkedHashMap();
    private PolicyValue<?> currentResolvedPolicy;
    private PolicyState<?> policyState = ((PolicyStateReflector)Reflector.reflector(PolicyStateReflector.class)).newPolicyState();

    private PolicyStateBuilder() {
    }

    public static PolicyStateBuilder newBuilder() {
        return new PolicyStateBuilder();
    }

    public PolicyStateBuilder setPolicy(EnforcingAdmin enforcingAdmin, PolicyValue<?> value) {
        this.policiesSetByAdmins.put(enforcingAdmin, value);
        return this;
    }

    public PolicyStateBuilder setCurrentResolvedPolicy(PolicyValue<?> currentResolvedPolicy) {
        this.currentResolvedPolicy = currentResolvedPolicy;
        return this;
    }

    public PolicyState<?> build() {
        ((PolicyStateReflector)Reflector.reflector(PolicyStateReflector.class, this.policyState)).setPoliciesSetByAdmins(this.policiesSetByAdmins);
        ((PolicyStateReflector)Reflector.reflector(PolicyStateReflector.class, this.policyState)).setCurrentResolvedPolicy(this.currentResolvedPolicy);
        return this.policyState;
    }

    @ForType(value=PolicyState.class)
    private static interface PolicyStateReflector {
        @Constructor
        public PolicyState<?> newPolicyState();

        @Accessor(value="mPoliciesSetByAdmins")
        public void setPoliciesSetByAdmins(Map<EnforcingAdmin, PolicyValue<?>> var1);

        @Accessor(value="mCurrentResolvedPolicy")
        public void setCurrentResolvedPolicy(PolicyValue<?> var1);
    }
}

