/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.nio.ByteBuffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.shadows.ShadowBaseStringBlock;

@Implements(className="android.content.res.StringBlock", isInAndroidSdk=false, shadowPicker=ShadowBaseStringBlock.Picker.class)
public class ShadowStringBlock
extends ShadowBaseStringBlock {
    @RealObject
    Object realObject;

    @Implementation
    protected static long nativeCreate(byte[] data, int offset, int size) {
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected static int nativeGetSize(long nativeId) {
        return ResStringPool.getNativeObject((long)nativeId).size();
    }

    @Implementation
    protected static String nativeGetString(long nativeId, int index) {
        return ResStringPool.getNativeObject((long)nativeId).stringAt(index);
    }

    @Implementation
    protected static int[] nativeGetStyle(long obj, int idx) {
        ResStringPool osb = ResStringPool.getNativeObject((long)obj);
        ResourceTypes.ResStringPool_span spans = osb.styleAt(idx);
        if (spans == null) {
            return null;
        }
        ResourceTypes.ResStringPool_span pos = spans;
        int num = 0;
        while (pos.name.index != -1) {
            ++num;
            pos = new ResourceTypes.ResStringPool_span(pos.myBuf(), pos.myOffset() + 12);
        }
        if (num == 0) {
            return null;
        }
        int[] array = new int[num * 12 / 4];
        if (array == null) {
            return null;
        }
        num = 0;
        int numInts = 3;
        while (spans.name.index != -1) {
            ShadowStringBlock.setIntArrayRegion(array, num, 3, spans);
            spans = new ResourceTypes.ResStringPool_span(spans.myBuf(), spans.myOffset() + 12);
            ++num;
        }
        return array;
    }

    private static void setIntArrayRegion(int[] array, int num, int numInts, ResourceTypes.ResStringPool_span spans) {
        ByteBuffer buf = spans.myBuf();
        int startOffset = spans.myOffset();
        int start = num * numInts;
        for (int i = 0; i < numInts; ++i) {
            array[start + i] = buf.getInt(startOffset + i * 4);
        }
    }

    @Implementation
    protected static void nativeDestroy(long obj) {
        throw new UnsupportedOperationException();
    }

    @Resetter
    public static void reset() {
    }
}

