/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Sensor.class)
public class ShadowSensor {
    @RealObject
    private Sensor realSensor;
    private float maximumRange = 0.0f;

    public static Sensor newInstance(int type) {
        Sensor sensor = (Sensor)Shadow.newInstanceOf(Sensor.class);
        ((_Sensor_)Reflector.reflector(_Sensor_.class, (Object)sensor)).setTypeCompat(type);
        return sensor;
    }

    public void setWakeUpFlag(boolean wakeup) {
        int wakeUpSensorMask = ((_Sensor_)Reflector.reflector(_Sensor_.class)).getWakeUpSensorFlag();
        if (wakeup) {
            this.setMask(wakeUpSensorMask);
        } else {
            this.clearMask(wakeUpSensorMask);
        }
    }

    public void setMaximumRange(float range) {
        this.maximumRange = range;
    }

    @Implementation
    protected float getMaximumRange() {
        return this.maximumRange;
    }

    public void setMinDelay(int delay) {
        ((_Sensor_)Reflector.reflector(_Sensor_.class, (Object)this.realSensor)).setMinDelay(delay);
    }

    private void setMask(int mask) {
        _Sensor_ _sensor_ = (_Sensor_)Reflector.reflector(_Sensor_.class, (Object)this.realSensor);
        _sensor_.setFlags(_sensor_.getFlags() | mask);
    }

    private void clearMask(int mask) {
        _Sensor_ _sensor_ = (_Sensor_)Reflector.reflector(_Sensor_.class, (Object)this.realSensor);
        _sensor_.setFlags(_sensor_.getFlags() & ~mask);
    }

    @ForType(value=Sensor.class)
    static interface _Sensor_ {
        @Accessor(value="mType")
        public void setTypeField(int var1);

        public void setType(int var1);

        default public void setTypeCompat(int type) {
            if (RuntimeEnvironment.getApiLevel() >= 23) {
                this.setType(type);
            } else {
                this.setTypeField(type);
            }
        }

        @Accessor(value="mFlags")
        public int getFlags();

        @Accessor(value="mFlags")
        public void setFlags(int var1);

        @Accessor(value="mMinDelay")
        public void setMinDelay(int var1);

        @Static
        @Accessor(value="SENSOR_FLAG_WAKE_UP_SENSOR")
        public int getWakeUpSensorFlag();
    }
}

