/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.safetycenter.SafetyCenterManager;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=SafetyCenterManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowSafetyCenterManager {
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static final Map<String, SafetySourceData> dataById = new HashMap<String, SafetySourceData>();
    @GuardedBy(value="lock")
    private static final Map<String, SafetyEvent> eventsById = new HashMap<String, SafetyEvent>();
    @GuardedBy(value="lock")
    private static final Map<String, SafetySourceErrorDetails> errorsById = new HashMap<String, SafetySourceErrorDetails>();
    @GuardedBy(value="lock")
    private static final Set<String> throwForId = new HashSet<String>();
    @GuardedBy(value="lock")
    private static boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean isSafetyCenterEnabled() {
        Object object = lock;
        synchronized (object) {
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setSafetySourceData(@NonNull String safetySourceId, @Nullable SafetySourceData safetySourceData, @NonNull SafetyEvent safetyEvent) {
        Object object = lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return;
            }
            ShadowSafetyCenterManager.maybeThrowForId(safetySourceId);
            dataById.put(safetySourceId, safetySourceData);
            eventsById.put(safetySourceId, safetyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected SafetySourceData getSafetySourceData(@NonNull String safetySourceId) {
        Object object = lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return null;
            }
            ShadowSafetyCenterManager.maybeThrowForId(safetySourceId);
            return dataById.get(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void reportSafetySourceError(@NonNull String safetySourceId, @NonNull SafetySourceErrorDetails safetySourceErrorDetails) {
        Object object = lock;
        synchronized (object) {
            if (!this.isSafetyCenterEnabled()) {
                return;
            }
            ShadowSafetyCenterManager.maybeThrowForId(safetySourceId);
            errorsById.put(safetySourceId, safetySourceErrorDetails);
        }
    }

    @GuardedBy(value="lock")
    private static void maybeThrowForId(String safetySourceId) {
        if (throwForId.contains(safetySourceId)) {
            throw new IllegalArgumentException(String.format("%s is invalid", safetySourceId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSafetyCenterEnabled(boolean enabled) {
        Object object = lock;
        synchronized (object) {
            ShadowSafetyCenterManager.enabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwOnSafetySourceId(@NonNull String safetySourceId) {
        Object object = lock;
        synchronized (object) {
            throwForId.add(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafetyEvent getLastSafetyEvent(@NonNull String safetySourceId) {
        Object object = lock;
        synchronized (object) {
            return eventsById.get(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafetySourceErrorDetails getLastSafetySourceError(@NonNull String safetySourceId) {
        Object object = lock;
        synchronized (object) {
            return errorsById.get(safetySourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            dataById.clear();
            eventsById.clear();
            errorsById.clear();
            throwForId.clear();
            enabled = false;
        }
    }
}

