/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.role.IRoleManager;
import android.app.role.RoleManager;
import android.content.Context;
import android.content.pm.PackageManager;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=RoleManager.class, minSdk=29)
public class ShadowRoleManager {
    @RealObject
    protected RoleManager roleManager;
    private static final String[] DEFAULT_APPLICATION_ROLES = new String[]{"android.app.role.ASSISTANT", "android.app.role.BROWSER", "android.app.role.CALL_REDIRECTION", "android.app.role.CALL_SCREENING", "android.app.role.DIALER", "android.app.role.HOME", "android.app.role.SMS"};
    private Context context;
    private static final Map<String, String> roleToHolder = new HashMap<String, String>();

    @Implementation(maxSdk=30)
    protected void __constructor__(Context context) {
        this.context = context;
        Shadow.invokeConstructor(RoleManager.class, (Object)this.roleManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation(minSdk=31)
    protected void __constructor__(Context context, IRoleManager service) {
        this.context = context;
        Shadow.invokeConstructor(RoleManager.class, (Object)this.roleManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IRoleManager.class, (Object)service)});
    }

    @Implementation
    protected boolean isRoleHeld(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return this.context.getPackageName().equals(roleToHolder.get(roleName));
    }

    public void addHeldRole(@NonNull String roleName) {
        this.addAvailableRole(roleName);
        roleToHolder.put(roleName, this.context.getPackageName());
    }

    public void removeHeldRole(@NonNull String roleName) {
        Preconditions.checkArgument((boolean)this.isRoleHeld(roleName), (Object)"the supplied roleName was never added.");
        roleToHolder.put(roleName, null);
    }

    @Implementation
    protected boolean isRoleAvailable(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return roleToHolder.containsKey(roleName);
    }

    public void addAvailableRole(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        if (!this.isRoleAvailable(roleName)) {
            roleToHolder.put(roleName, null);
        }
    }

    public void removeAvailableRole(@NonNull String roleName) {
        Preconditions.checkArgument((boolean)roleToHolder.containsKey(roleName), (Object)"the supplied roleName was never added.");
        roleToHolder.remove(roleName);
    }

    @Implementation(minSdk=34)
    @Nullable
    protected String getDefaultApplication(@NonNull String roleName) {
        return roleToHolder.get(roleName);
    }

    @Implementation(minSdk=34)
    protected void setDefaultApplication(@NonNull String roleName, @Nullable String packageName, int flags, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Preconditions.checkArgument((boolean)Arrays.asList(DEFAULT_APPLICATION_ROLES).contains(roleName), (Object)"the supplied roleName in not a default app.");
        try {
            this.context.getPackageManager().getPackageInfo(packageName, 0);
            if (this.isRoleAvailable(roleName)) {
                roleToHolder.put(roleName, packageName);
                executor.execute(() -> callback.accept(true));
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        executor.execute(() -> callback.accept(false));
    }

    @Resetter
    public static void reset() {
        roleToHolder.clear();
    }
}

