/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.WorkSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=PowerManager.class)
public class ShadowPowerManager {
    @RealObject
    private PowerManager realPowerManager;
    private static boolean isInteractive = true;
    private static boolean isPowerSaveMode = false;
    private static boolean isDeviceIdleMode = false;
    private static boolean isLightDeviceIdleMode = false;
    @Nullable
    private static Duration batteryDischargePrediction = null;
    private static boolean isBatteryDischargePredictionPersonalized = false;
    private static int locationMode = 2;
    private static final List<String> rebootReasons = new ArrayList<String>();
    private static final Map<String, Boolean> ignoringBatteryOptimizations = new HashMap<String, Boolean>();
    private static int thermalStatus = 0;
    private static final Set<Object> thermalListeners = new HashSet<Object>();
    private static final Set<String> ambientDisplaySuppressionTokens = Collections.synchronizedSet(new HashSet());
    private static volatile boolean isAmbientDisplayAvailable = true;
    private static volatile boolean isRebootingUserspaceSupported = false;
    private static volatile boolean adaptivePowerSaveEnabled = false;
    private static PowerManager.WakeLock latestWakeLock;
    private static boolean lowPowerStandbyEnabled;
    private static boolean lowPowerStandbySupported;
    private static boolean exemptFromLowPowerStandby;
    private static final Set<String> allowedFeatures;
    private Map<Integer, Boolean> supportedWakeLockLevels = new HashMap<Integer, Boolean>();

    @Implementation
    protected PowerManager.WakeLock newWakeLock(int flags, String tag) {
        PowerManager.WakeLock wl = (PowerManager.WakeLock)Shadow.newInstanceOf(PowerManager.WakeLock.class);
        ((ShadowWakeLock)Shadow.extract((Object)wl)).setTag(tag);
        latestWakeLock = wl;
        return wl;
    }

    @Implementation
    protected boolean isScreenOn() {
        return isInteractive;
    }

    @Deprecated
    public void setIsScreenOn(boolean screenOn) {
        this.setIsInteractive(screenOn);
    }

    @Implementation
    protected boolean isInteractive() {
        return isInteractive;
    }

    @Deprecated
    public void setIsInteractive(boolean interactive) {
        isInteractive = interactive;
    }

    public void turnScreenOn(boolean screenOn) {
        if (isInteractive != screenOn) {
            isInteractive = screenOn;
            this.getContext().sendBroadcast(new Intent(screenOn ? "android.intent.action.SCREEN_ON" : "android.intent.action.SCREEN_OFF"));
        }
    }

    @Implementation
    protected boolean isPowerSaveMode() {
        return isPowerSaveMode;
    }

    public void setIsPowerSaveMode(boolean powerSaveMode) {
        isPowerSaveMode = powerSaveMode;
    }

    @Implementation
    protected boolean isWakeLockLevelSupported(int level) {
        return this.supportedWakeLockLevels.containsKey(level) ? this.supportedWakeLockLevels.get(level) : false;
    }

    public void setIsWakeLockLevelSupported(int level, boolean supported) {
        this.supportedWakeLockLevels.put(level, supported);
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceIdleMode() {
        return isDeviceIdleMode;
    }

    public void setIsDeviceIdleMode(boolean isDeviceIdleMode) {
        ShadowPowerManager.isDeviceIdleMode = isDeviceIdleMode;
        this.getContext().sendBroadcast(new Intent("android.os.action.DEVICE_IDLE_MODE_CHANGED"));
    }

    @Implementation(minSdk=24)
    protected boolean isLightDeviceIdleMode() {
        return isLightDeviceIdleMode;
    }

    public void setIsLightDeviceIdleMode(boolean lightDeviceIdleMode) {
        isLightDeviceIdleMode = lightDeviceIdleMode;
    }

    @Implementation(minSdk=33)
    protected boolean isDeviceLightIdleMode() {
        return this.isLightDeviceIdleMode();
    }

    public void setIsDeviceLightIdleMode(boolean lightDeviceIdleMode) {
        this.setIsLightDeviceIdleMode(lightDeviceIdleMode);
    }

    @Implementation(minSdk=28)
    protected int getLocationPowerSaveMode() {
        if (!this.isPowerSaveMode()) {
            return 0;
        }
        return locationMode;
    }

    public void setLocationPowerSaveMode(int locationMode) {
        Preconditions.checkState((locationMode >= 0 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be at least 0");
        Preconditions.checkState((locationMode <= 4 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be no more than 4");
        ShadowPowerManager.locationMode = locationMode;
    }

    @Implementation(minSdk=29)
    protected int getCurrentThermalStatus() {
        return thermalStatus;
    }

    @Implementation(minSdk=29)
    protected void addThermalStatusListener(@ClassName(value="android.os.PowerManager$OnThermalStatusChangedListener") @ClassName(value="android.os.PowerManager$OnThermalStatusChangedListener") Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        thermalListeners.add(listener);
    }

    public ImmutableSet<Object> getThermalStatusListeners() {
        return ImmutableSet.copyOf(thermalListeners);
    }

    @Implementation(minSdk=29)
    protected void removeThermalStatusListener(@ClassName(value="android.os.PowerManager$OnThermalStatusChangedListener") @ClassName(value="android.os.PowerManager$OnThermalStatusChangedListener") Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        thermalListeners.remove(listener);
    }

    public void setCurrentThermalStatus(int thermalStatus) {
        Preconditions.checkState((thermalStatus >= 0 ? 1 : 0) != 0, (Object)"Thermal status must be at least 0");
        Preconditions.checkState((thermalStatus <= 6 ? 1 : 0) != 0, (Object)"Thermal status must be no more than 6");
        ShadowPowerManager.thermalStatus = thermalStatus;
        for (Object listener : thermalListeners) {
            ((PowerManager.OnThermalStatusChangedListener)listener).onThermalStatusChanged(thermalStatus);
        }
    }

    @Resetter
    public static void reset() {
        isInteractive = true;
        isPowerSaveMode = false;
        isDeviceIdleMode = false;
        isLightDeviceIdleMode = false;
        batteryDischargePrediction = null;
        isBatteryDischargePredictionPersonalized = false;
        locationMode = 2;
        rebootReasons.clear();
        ignoringBatteryOptimizations.clear();
        thermalStatus = 0;
        thermalListeners.clear();
        ambientDisplaySuppressionTokens.clear();
        isAmbientDisplayAvailable = true;
        isRebootingUserspaceSupported = false;
        adaptivePowerSaveEnabled = false;
        latestWakeLock = null;
        lowPowerStandbyEnabled = false;
        lowPowerStandbySupported = false;
        exemptFromLowPowerStandby = false;
        allowedFeatures.clear();
        ShadowPowerManager.clearWakeLocks();
    }

    public static PowerManager.WakeLock getLatestWakeLock() {
        return latestWakeLock;
    }

    public static void clearWakeLocks() {
        latestWakeLock = null;
    }

    @Deprecated
    static void addWakeLock(PowerManager.WakeLock wl) {
        latestWakeLock = wl;
    }

    @Implementation(minSdk=23)
    protected boolean isIgnoringBatteryOptimizations(String packageName) {
        Boolean result = ignoringBatteryOptimizations.get(packageName);
        return result == null ? false : result;
    }

    public void setIgnoringBatteryOptimizations(String packageName, boolean value) {
        ignoringBatteryOptimizations.put(packageName, value);
    }

    @SystemApi
    @Implementation(minSdk=31)
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    protected void setBatteryDischargePrediction(@NonNull Duration timeRemaining, boolean isPersonalized) {
        batteryDischargePrediction = timeRemaining;
        isBatteryDischargePredictionPersonalized = isPersonalized;
    }

    @Implementation(minSdk=31)
    @Nullable
    protected Duration getBatteryDischargePrediction() {
        return batteryDischargePrediction;
    }

    @Implementation(minSdk=31)
    protected boolean isBatteryDischargePredictionPersonalized() {
        return isBatteryDischargePredictionPersonalized;
    }

    @Implementation
    protected void reboot(@Nullable String reason) {
        if (RuntimeEnvironment.getApiLevel() >= 30 && "userspace".equals(reason) && !this.isRebootingUserspaceSupported()) {
            throw new UnsupportedOperationException("Attempted userspace reboot on a device that doesn't support it");
        }
        rebootReasons.add(reason);
    }

    public int getTimesRebooted() {
        return rebootReasons.size();
    }

    public List<String> getRebootReasons() {
        return new ArrayList<String>(rebootReasons);
    }

    public void setAmbientDisplayAvailable(boolean available) {
        isAmbientDisplayAvailable = available;
    }

    public void setIsRebootingUserspaceSupported(boolean supported) {
        isRebootingUserspaceSupported = supported;
    }

    @Implementation(minSdk=30)
    protected boolean isAmbientDisplayAvailable() {
        return isAmbientDisplayAvailable;
    }

    @Implementation(minSdk=30)
    protected void suppressAmbientDisplay(String token, boolean suppress) {
        String suppressionToken = Binder.getCallingUid() + "_" + token;
        if (suppress) {
            ambientDisplaySuppressionTokens.add(suppressionToken);
        } else {
            ambientDisplaySuppressionTokens.remove(suppressionToken);
        }
    }

    @Implementation(minSdk=30)
    protected boolean isAmbientDisplaySuppressed() {
        return !ambientDisplaySuppressionTokens.isEmpty();
    }

    @Implementation(minSdk=30)
    protected boolean isRebootingUserspaceSupported() {
        return isRebootingUserspaceSupported;
    }

    @Implementation(minSdk=29)
    @SystemApi
    protected boolean setAdaptivePowerSaveEnabled(boolean enabled) {
        boolean changed = adaptivePowerSaveEnabled != enabled;
        adaptivePowerSaveEnabled = enabled;
        return changed;
    }

    public boolean getAdaptivePowerSaveEnabled() {
        return adaptivePowerSaveEnabled;
    }

    private Context getContext() {
        return ((ReflectorPowerManager)Reflector.reflector(ReflectorPowerManager.class, (Object)this.realPowerManager)).getContext();
    }

    @Implementation(minSdk=33)
    protected boolean isLowPowerStandbySupported() {
        return lowPowerStandbySupported;
    }

    @TargetApi(value=33)
    public void setLowPowerStandbySupported(boolean lowPowerStandbySupported) {
        ShadowPowerManager.lowPowerStandbySupported = lowPowerStandbySupported;
    }

    @Implementation(minSdk=33)
    protected boolean isLowPowerStandbyEnabled() {
        return lowPowerStandbySupported && lowPowerStandbyEnabled;
    }

    @Implementation(minSdk=33)
    public void setLowPowerStandbyEnabled(boolean lowPowerStandbyEnabled) {
        ShadowPowerManager.lowPowerStandbyEnabled = lowPowerStandbyEnabled;
    }

    @Implementation(minSdk=34)
    protected boolean isAllowedInLowPowerStandby(String feature) {
        if (!lowPowerStandbySupported) {
            return true;
        }
        return allowedFeatures.contains(feature);
    }

    @TargetApi(value=34)
    public void addAllowedInLowPowerStandby(String feature) {
        allowedFeatures.add(feature);
    }

    @Implementation(minSdk=34)
    protected boolean isExemptFromLowPowerStandby() {
        if (!lowPowerStandbySupported) {
            return true;
        }
        return exemptFromLowPowerStandby;
    }

    @TargetApi(value=34)
    public void setExemptFromLowPowerStandby(boolean exemptFromLowPowerStandby) {
        ShadowPowerManager.exemptFromLowPowerStandby = exemptFromLowPowerStandby;
    }

    @Implementation(minSdk=34)
    protected @ClassName(value="android.os.PowerManager$LowPowerStandbyPortsLock") Object newLowPowerStandbyPortsLock(List<PowerManager.LowPowerStandbyPortDescription> ports) {
        PowerManager.LowPowerStandbyPortsLock lock = (PowerManager.LowPowerStandbyPortsLock)Shadow.newInstanceOf(PowerManager.LowPowerStandbyPortsLock.class);
        ((ShadowLowPowerStandbyPortsLock)Shadow.extract((Object)lock)).setPorts(ports);
        return lock;
    }

    static {
        lowPowerStandbyEnabled = false;
        lowPowerStandbySupported = false;
        exemptFromLowPowerStandby = false;
        allowedFeatures = new HashSet<String>();
    }

    @Implements(value=PowerManager.WakeLock.class)
    public static class ShadowWakeLock {
        private boolean refCounted = true;
        private WorkSource workSource = null;
        private int timesHeld = 0;
        private String tag = null;
        private List<Optional<Long>> timeoutTimestampList = new ArrayList<Optional<Long>>();

        private void acquireInternal(Optional<Long> timeoutOptional) {
            ++this.timesHeld;
            this.timeoutTimestampList.add(timeoutOptional);
        }

        private void refreshTimeoutTimestampList() {
            this.timeoutTimestampList = this.timeoutTimestampList.stream().filter(o -> !o.isPresent() || (Long)o.get() >= SystemClock.elapsedRealtime()).collect(Collectors.toCollection(ArrayList::new));
        }

        @Implementation
        protected void acquire() {
            this.acquireInternal(Optional.empty());
        }

        @Implementation
        protected synchronized void acquire(long timeout) {
            Long timeoutMillis = timeout + SystemClock.elapsedRealtime();
            if (timeoutMillis > 0L) {
                this.acquireInternal(Optional.of(timeoutMillis));
            } else {
                this.acquireInternal(Optional.empty());
            }
        }

        @Implementation
        protected synchronized void release(int flags) {
            this.refreshTimeoutTimestampList();
            Optional<Optional> wakeLockOptional = this.timeoutTimestampList.stream().min(Comparator.comparing(arg -> arg.orElse(Long.MAX_VALUE), (leftProperty, rightProperty) -> leftProperty - rightProperty > 0L ? 1 : -1));
            if (wakeLockOptional.isEmpty()) {
                if (this.refCounted) {
                    throw new RuntimeException("WakeLock under-locked");
                }
                return;
            }
            Optional wakeLock = wakeLockOptional.get();
            if (this.refCounted) {
                this.timeoutTimestampList.remove(wakeLock);
            } else {
                this.timeoutTimestampList = new ArrayList<Optional<Long>>();
            }
        }

        @Implementation
        protected synchronized boolean isHeld() {
            this.refreshTimeoutTimestampList();
            return !this.timeoutTimestampList.isEmpty();
        }

        public boolean isReferenceCounted() {
            return this.refCounted;
        }

        @Implementation
        protected void setReferenceCounted(boolean value) {
            this.refCounted = value;
        }

        @Implementation
        protected synchronized void setWorkSource(WorkSource ws) {
            this.workSource = ws;
        }

        public synchronized WorkSource getWorkSource() {
            return this.workSource;
        }

        public int getTimesHeld() {
            return this.timesHeld;
        }

        @HiddenApi
        @Implementation(minSdk=26)
        public String getTag() {
            return this.tag;
        }

        @Implementation(minSdk=22)
        protected void setTag(String tag) {
            this.tag = tag;
        }
    }

    @ForType(value=PowerManager.class)
    private static interface ReflectorPowerManager {
        @Accessor(value="mContext")
        public Context getContext();
    }

    @Implements(value=PowerManager.LowPowerStandbyPortsLock.class, minSdk=34, isInAndroidSdk=false)
    public static class ShadowLowPowerStandbyPortsLock {
        private List<PowerManager.LowPowerStandbyPortDescription> ports;
        private boolean isAcquired = false;
        private int acquireCount = 0;

        @Implementation(minSdk=34)
        protected void acquire() {
            this.isAcquired = true;
            ++this.acquireCount;
        }

        @Implementation(minSdk=34)
        protected void release() {
            this.isAcquired = false;
        }

        public boolean isAcquired() {
            return this.isAcquired;
        }

        public int getAcquireCount() {
            return this.acquireCount;
        }

        public void setPorts(List<PowerManager.LowPowerStandbyPortDescription> ports) {
            this.ports = ports;
        }

        public List<PowerManager.LowPowerStandbyPortDescription> getPorts() {
            return this.ports;
        }
    }
}

