/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ParcelFileDescriptor.class)
@SuppressLint(value={"NewApi"})
public class ShadowParcelFileDescriptor {
    private static final String PIPE_TMP_DIR = "ShadowParcelFileDescriptor";
    private static final String PIPE_FILE_NAME = "pipe";
    private static final Map<Integer, RandomAccessFile> filesInTransitById = Collections.synchronizedMap(new HashMap());
    private static final AtomicInteger NEXT_FILE_ID = new AtomicInteger();
    private RandomAccessFile file;
    private int fileIdPledgedOnClose;
    private int lazyFileId;
    private boolean closed;
    private Handler handler;
    private ParcelFileDescriptor.OnCloseListener onCloseListener;
    @RealObject
    private ParcelFileDescriptor realParcelFd;
    @RealObject
    private ParcelFileDescriptor realObject;
    static final Parcelable.Creator<ParcelFileDescriptor> CREATOR = new Parcelable.Creator<ParcelFileDescriptor>(){

        public ParcelFileDescriptor createFromParcel(Parcel source) {
            int fileId = source.readInt();
            ParcelFileDescriptor result = ShadowParcelFileDescriptor.newParcelFileDescriptor();
            ShadowParcelFileDescriptor shadowResult = (ShadowParcelFileDescriptor)Shadow.extract((Object)result);
            shadowResult.lazyFileId = fileId;
            return result;
        }

        public ParcelFileDescriptor[] newArray(int size) {
            return new ParcelFileDescriptor[size];
        }
    };

    @Implementation
    protected static void __staticInitializer__() {
        Shadow.directInitialize(ParcelFileDescriptor.class);
        ReflectionHelpers.setStaticField(ParcelFileDescriptor.class, (String)"CREATOR", CREATOR);
    }

    @Resetter
    public static void reset() {
        filesInTransitById.clear();
    }

    @Implementation
    protected void __constructor__(ParcelFileDescriptor wrapped) {
        Shadow.invokeConstructor(ParcelFileDescriptor.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ParcelFileDescriptor.class, (Object)wrapped)});
        if (wrapped != null) {
            ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)wrapped);
            this.file = shadowParcelFileDescriptor.file;
        }
    }

    @Implementation
    protected void writeToParcel(Parcel out, int flags) {
        if (this.fileIdPledgedOnClose == 0) {
            this.fileIdPledgedOnClose = this.lazyFileId != 0 ? this.lazyFileId : NEXT_FILE_ID.incrementAndGet();
        }
        out.writeInt(this.fileIdPledgedOnClose);
        if ((flags & 1) != 0) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static ParcelFileDescriptor newParcelFileDescriptor() {
        return new ParcelFileDescriptor(new FileDescriptor());
    }

    @Implementation
    protected static ParcelFileDescriptor open(File file, int mode) throws FileNotFoundException {
        ParcelFileDescriptor pfd = ShadowParcelFileDescriptor.newParcelFileDescriptor();
        ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)pfd);
        shadowParcelFileDescriptor.file = new RandomAccessFile(file, ShadowParcelFileDescriptor.getFileMode(mode));
        if ((mode & 0x4000000) != 0) {
            try {
                shadowParcelFileDescriptor.file.setLength(0L);
            }
            catch (IOException ioe) {
                FileNotFoundException fnfe = new FileNotFoundException("Unable to truncate");
                fnfe.initCause(ioe);
                throw fnfe;
            }
        }
        if ((mode & 0x2000000) != 0) {
            try {
                shadowParcelFileDescriptor.file.seek(shadowParcelFileDescriptor.file.length());
            }
            catch (IOException ioe) {
                FileNotFoundException fnfe = new FileNotFoundException("Unable to append");
                fnfe.initCause(ioe);
                throw fnfe;
            }
        }
        return pfd;
    }

    @Implementation
    protected static ParcelFileDescriptor open(File file, int mode, Handler handler, ParcelFileDescriptor.OnCloseListener listener) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        ParcelFileDescriptor pfd = ShadowParcelFileDescriptor.open(file, mode);
        ShadowParcelFileDescriptor shadowParcelFileDescriptor = (ShadowParcelFileDescriptor)Shadow.extract((Object)pfd);
        shadowParcelFileDescriptor.handler = handler;
        shadowParcelFileDescriptor.onCloseListener = listener;
        return pfd;
    }

    private static String getFileMode(int mode) {
        if ((mode & 0x8000000) != 0) {
            return "rw";
        }
        switch (mode & 0x30000000) {
            case 0x10000000: {
                return "r";
            }
            case 0x20000000: 
            case 0x30000000: {
                return "rw";
            }
        }
        return "rw";
    }

    @Implementation
    protected static ParcelFileDescriptor[] createPipe() throws IOException {
        File file = new File(RuntimeEnvironment.getTempDirectory().createIfNotExists(PIPE_TMP_DIR).toFile(), "pipe-" + UUID.randomUUID());
        if (!file.createNewFile()) {
            throw new IOException("Cannot create pipe file: " + file.getAbsolutePath());
        }
        ParcelFileDescriptor readSide = ShadowParcelFileDescriptor.open(file, 0x10000000);
        ParcelFileDescriptor writeSide = ShadowParcelFileDescriptor.open(file, 0x30000000);
        file.deleteOnExit();
        return new ParcelFileDescriptor[]{readSide, writeSide};
    }

    @Implementation
    protected static ParcelFileDescriptor[] createReliablePipe() throws IOException {
        return ShadowParcelFileDescriptor.createPipe();
    }

    private RandomAccessFile getFile() {
        if (this.file == null && this.lazyFileId != 0) {
            this.file = filesInTransitById.remove(this.lazyFileId);
            this.lazyFileId = 0;
            if (this.file == null) {
                throw new FileDescriptorFromParcelUnavailableException();
            }
        }
        return this.file;
    }

    @Implementation
    protected FileDescriptor getFileDescriptor() {
        try {
            RandomAccessFile file = this.getFile();
            if (file != null) {
                return file.getFD();
            }
            return ((ParcelFileDescriptorReflector)Reflector.reflector(ParcelFileDescriptorReflector.class, (Object)this.realParcelFd)).getFileDescriptor();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected long getStatSize() {
        try {
            return this.getFile().length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Implementation
    protected int getFd() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        try {
            return (Integer)ReflectionHelpers.getField((Object)this.getFile().getFD(), (String)"fd");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.file != null) {
            if (this.fileIdPledgedOnClose != 0) {
                filesInTransitById.put(this.fileIdPledgedOnClose, this.file);
                this.fileIdPledgedOnClose = 0;
                File tempFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
                this.file = new RandomAccessFile(tempFile, "rw");
                tempFile.delete();
            }
            this.file.close();
        }
        ((ParcelFileDescriptorReflector)Reflector.reflector(ParcelFileDescriptorReflector.class, (Object)this.realParcelFd)).close();
        this.closed = true;
        if (this.handler != null && this.onCloseListener != null) {
            this.handler.post(() -> this.onCloseListener.onClose(null));
        }
    }

    @Implementation
    protected ParcelFileDescriptor dup() throws IOException {
        return new ParcelFileDescriptor(this.realParcelFd);
    }

    @Implementation
    protected static ParcelFileDescriptor dup(FileDescriptor fileDescriptor) throws IOException {
        File dupFile = new File(RuntimeEnvironment.getTempDirectory().createIfNotExists(PIPE_TMP_DIR).toFile(), "dupfd-" + UUID.randomUUID());
        FileInputStream fileInputStream = new FileInputStream(fileDescriptor);
        FileOutputStream fileOutputStream = new FileOutputStream(dupFile);
        FileChannel sourceChannel = fileInputStream.getChannel();
        long originalPosition = sourceChannel.position();
        sourceChannel.position(0L);
        ByteStreams.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        sourceChannel.position(originalPosition);
        RandomAccessFile randomAccessFile = new RandomAccessFile(dupFile, "rw");
        return new ParcelFileDescriptor(randomAccessFile.getFD());
    }

    static class FileDescriptorFromParcelUnavailableException
    extends RuntimeException {
        FileDescriptorFromParcelUnavailableException() {
            super("ParcelFileDescriptors created from a Parcel refer to the same content as the ParcelFileDescriptor that originally wrote it. Robolectric has the unfortunate limitation that only one of these instances can be functional at a time. Try closing the original ParcelFileDescriptor before using any duplicates created via the Parcelable API.");
        }
    }

    @ForType(value=ParcelFileDescriptor.class)
    static interface ParcelFileDescriptorReflector {
        @Direct
        public void close();

        @Direct
        public FileDescriptor getFileDescriptor();
    }
}

