/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManager;
import android.os.UserHandle;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=OverlayManager.class, minSdk=34, isInAndroidSdk=false)
public final class ShadowOverlayManager {
    private final Map<String, OverlayInfo> overlaysByPackageName = new HashMap<String, OverlayInfo>();
    @RealObject
    private OverlayManager realOverlayManager;

    public void addOverlayInfo(OverlayInfo overlayInfo) {
        this.overlaysByPackageName.put(overlayInfo.packageName, overlayInfo);
    }

    public void removeOverlayInfo(String packageName) {
        this.overlaysByPackageName.remove(packageName);
    }

    @Implementation
    @Nullable
    protected OverlayInfo getOverlayInfo(@NonNull String packageName, @NonNull UserHandle userHandle) {
        return this.overlaysByPackageName.get(packageName);
    }

    @Implementation
    protected void setEnabled(@NonNull String packageName, boolean enable, @NonNull UserHandle user) {
        this.checkPermission();
        OverlayInfo overlay = this.overlaysByPackageName.get(packageName);
        if (overlay == null) {
            throw new IllegalStateException("setEnabled failed; overlay name " + packageName + " not found");
        }
        if (!overlay.isMutable) {
            throw new IllegalStateException("setEnabled failed; overlay name " + packageName + " is not mutable");
        }
        int state = enable ? 3 : 2;
        this.addOverlayInfo(new OverlayInfo(overlay, state));
    }

    private void checkPermission() {
        Context context = ((OverlayManagerReflector)Reflector.reflector(OverlayManagerReflector.class, (Object)this.realOverlayManager)).getContext();
        if (context.checkSelfPermission("android.permission.CHANGE_OVERLAY_PACKAGES") != 0) {
            throw new SecurityException("Missing required permission: android.permission.CHANGE_OVERLAY_PACKAGES");
        }
    }

    @ForType(value=OverlayManager.class)
    static interface OverlayManagerReflector {
        @Accessor(value="mContext")
        public Context getContext();
    }
}

