/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.BaseCanvas;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.BaseCanvasNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowCanvas;
import org.robolectric.shadows.ShadowNativeTypeface;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BaseCanvas.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeBaseCanvas
extends ShadowCanvas {
    @RealObject
    BaseCanvas realBaseCanvas;

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawBitmap(long nativeCanvas, long bitmapHandle, float left, float top, long nativePaintOrZero, int canvasDensity, int screenDensity, int bitmapDensity) {
        BaseCanvasNatives.nDrawBitmap((long)nativeCanvas, (long)bitmapHandle, (float)left, (float)top, (long)nativePaintOrZero, (int)canvasDensity, (int)screenDensity, (int)bitmapDensity);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawBitmap(long nativeCanvas, long bitmapHandle, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, long nativePaintOrZero, int screenDensity, int bitmapDensity) {
        BaseCanvasNatives.nDrawBitmap((long)nativeCanvas, (long)bitmapHandle, (float)srcLeft, (float)srcTop, (float)srcRight, (float)srcBottom, (float)dstLeft, (float)dstTop, (float)dstRight, (float)dstBottom, (long)nativePaintOrZero, (int)screenDensity, (int)bitmapDensity);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawBitmap(long nativeCanvas, int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, long nativePaintOrZero) {
        BaseCanvasNatives.nDrawBitmap((long)nativeCanvas, (int[])colors, (int)offset, (int)stride, (float)x, (float)y, (int)width, (int)height, (boolean)hasAlpha, (long)nativePaintOrZero);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nDrawBitmap(long nativeCanvas, Bitmap bitmap, float left, float top, long nativePaintOrZero, int canvasDensity, int screenDensity, int bitmapDensity) {
        BaseCanvasNatives.nDrawBitmap((long)nativeCanvas, (long)bitmap.getNativeInstance(), (float)left, (float)top, (long)nativePaintOrZero, (int)canvasDensity, (int)screenDensity, (int)bitmapDensity);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nDrawBitmap(long nativeCanvas, Bitmap bitmap, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, long nativePaintOrZero, int screenDensity, int bitmapDensity) {
        BaseCanvasNatives.nDrawBitmap((long)nativeCanvas, (long)bitmap.getNativeInstance(), (float)srcLeft, (float)srcTop, (float)srcRight, (float)srcBottom, (float)dstLeft, (float)dstTop, (float)dstRight, (float)dstBottom, (long)nativePaintOrZero, (int)screenDensity, (int)bitmapDensity);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawColor(long nativeCanvas, int color, int mode) {
        BaseCanvasNatives.nDrawColor((long)nativeCanvas, (int)color, (int)mode);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawColor(long nativeCanvas, long nativeColorSpace, long color, int mode) {
        BaseCanvasNatives.nDrawColor((long)nativeCanvas, (long)nativeColorSpace, (long)color, (int)mode);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawPaint(long nativeCanvas, long nativePaint) {
        BaseCanvasNatives.nDrawPaint((long)nativeCanvas, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawPoint(long canvasHandle, float x, float y, long paintHandle) {
        BaseCanvasNatives.nDrawPoint((long)canvasHandle, (float)x, (float)y, (long)paintHandle);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawPoints(long canvasHandle, float[] pts, int offset, int count, long paintHandle) {
        BaseCanvasNatives.nDrawPoints((long)canvasHandle, (float[])pts, (int)offset, (int)count, (long)paintHandle);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawLine(long nativeCanvas, float startX, float startY, float stopX, float stopY, long nativePaint) {
        BaseCanvasNatives.nDrawLine((long)nativeCanvas, (float)startX, (float)startY, (float)stopX, (float)stopY, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawLines(long canvasHandle, float[] pts, int offset, int count, long paintHandle) {
        BaseCanvasNatives.nDrawLines((long)canvasHandle, (float[])pts, (int)offset, (int)count, (long)paintHandle);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawRect(long nativeCanvas, float left, float top, float right, float bottom, long nativePaint) {
        BaseCanvasNatives.nDrawRect((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawOval(long nativeCanvas, float left, float top, float right, float bottom, long nativePaint) {
        BaseCanvasNatives.nDrawOval((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawCircle(long nativeCanvas, float cx, float cy, float radius, long nativePaint) {
        BaseCanvasNatives.nDrawCircle((long)nativeCanvas, (float)cx, (float)cy, (float)radius, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawArc(long nativeCanvas, float left, float top, float right, float bottom, float startAngle, float sweep, boolean useCenter, long nativePaint) {
        BaseCanvasNatives.nDrawArc((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom, (float)startAngle, (float)sweep, (boolean)useCenter, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawRoundRect(long nativeCanvas, float left, float top, float right, float bottom, float rx, float ry, long nativePaint) {
        BaseCanvasNatives.nDrawRoundRect((long)nativeCanvas, (float)left, (float)top, (float)right, (float)bottom, (float)rx, (float)ry, (long)nativePaint);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawDoubleRoundRect(long nativeCanvas, float outerLeft, float outerTop, float outerRight, float outerBottom, float outerRx, float outerRy, float innerLeft, float innerTop, float innerRight, float innerBottom, float innerRx, float innerRy, long nativePaint) {
        BaseCanvasNatives.nDrawDoubleRoundRect((long)nativeCanvas, (float)outerLeft, (float)outerTop, (float)outerRight, (float)outerBottom, (float)outerRx, (float)outerRy, (float)innerLeft, (float)innerTop, (float)innerRight, (float)innerBottom, (float)innerRx, (float)innerRy, (long)nativePaint);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawDoubleRoundRect(long nativeCanvas, float outerLeft, float outerTop, float outerRight, float outerBottom, float[] outerRadii, float innerLeft, float innerTop, float innerRight, float innerBottom, float[] innerRadii, long nativePaint) {
        BaseCanvasNatives.nDrawDoubleRoundRect((long)nativeCanvas, (float)outerLeft, (float)outerTop, (float)outerRight, (float)outerBottom, (float[])outerRadii, (float)innerLeft, (float)innerTop, (float)innerRight, (float)innerBottom, (float[])innerRadii, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawPath(long nativeCanvas, long nativePath, long nativePaint) {
        BaseCanvasNatives.nDrawPath((long)nativeCanvas, (long)nativePath, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawRegion(long nativeCanvas, long nativeRegion, long nativePaint) {
        BaseCanvasNatives.nDrawRegion((long)nativeCanvas, (long)nativeRegion, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawNinePatch(long nativeCanvas, long nativeBitmap, long ninePatch, float dstLeft, float dstTop, float dstRight, float dstBottom, long nativePaintOrZero, int screenDensity, int bitmapDensity) {
        BaseCanvasNatives.nDrawNinePatch((long)nativeCanvas, (long)nativeBitmap, (long)ninePatch, (float)dstLeft, (float)dstTop, (float)dstRight, (float)dstBottom, (long)nativePaintOrZero, (int)screenDensity, (int)bitmapDensity);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawBitmapMatrix(long nativeCanvas, long bitmapHandle, long nativeMatrix, long nativePaint) {
        BaseCanvasNatives.nDrawBitmapMatrix((long)nativeCanvas, (long)bitmapHandle, (long)nativeMatrix, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nDrawBitmapMatrix(long nativeCanvas, Bitmap bitmap, long nativeMatrix, long nativePaint) {
        BaseCanvasNatives.nDrawBitmapMatrix((long)nativeCanvas, (long)bitmap.getNativeInstance(), (long)nativeMatrix, (long)nativePaint);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nDrawBitmapMesh(long nativeCanvas, long bitmapHandle, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, long nativePaint) {
        BaseCanvasNatives.nDrawBitmapMesh((long)nativeCanvas, (long)bitmapHandle, (int)meshWidth, (int)meshHeight, (float[])verts, (int)vertOffset, (int[])colors, (int)colorOffset, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nDrawBitmapMesh(long nativeCanvas, Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, long nativePaint) {
        BaseCanvasNatives.nDrawBitmapMesh((long)nativeCanvas, (long)bitmap.getNativeInstance(), (int)meshWidth, (int)meshHeight, (float[])verts, (int)vertOffset, (int[])colors, (int)colorOffset, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawVertices(long nativeCanvas, int mode, int n, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, long nativePaint) {
        BaseCanvasNatives.nDrawVertices((long)nativeCanvas, (int)mode, (int)n, (float[])verts, (int)vertOffset, (float[])texs, (int)texOffset, (int[])colors, (int)colorOffset, (short[])indices, (int)indexOffset, (int)indexCount, (long)nativePaint);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nDrawGlyphs(long nativeCanvas, int[] glyphIds, float[] positions, int glyphIdStart, int positionStart, int glyphCount, long nativeFont, long nativePaint) {
        BaseCanvasNatives.nDrawGlyphs((long)nativeCanvas, (int[])glyphIds, (float[])positions, (int)glyphIdStart, (int)positionStart, (int)glyphCount, (long)nativeFont, (long)nativePaint);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nDrawText(long nativeCanvas, char[] text, int index, int count, float x, float y, int flags, long nativePaint) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawText((long)nativeCanvas, (char[])text, (int)index, (int)count, (float)x, (float)y, (int)flags, (long)nativePaint);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nDrawText(long nativeCanvas, String text, int start, int end, float x, float y, int flags, long nativePaint) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawText((long)nativeCanvas, (String)text, (int)start, (int)end, (float)x, (float)y, (int)flags, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nDrawText(long nativeCanvas, char[] text, int index, int count, float x, float y, int flags, long nativePaint, long nativeTypeface) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawText((long)nativeCanvas, (char[])text, (int)index, (int)count, (float)x, (float)y, (int)flags, (long)nativePaint, (long)nativeTypeface);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nDrawText(long nativeCanvas, String text, int start, int end, float x, float y, int flags, long nativePaint, long nativeTypeface) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawText((long)nativeCanvas, (String)text, (int)start, (int)end, (float)x, (float)y, (int)flags, (long)nativePaint, (long)nativeTypeface);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nDrawTextRun(long nativeCanvas, String text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, long nativePaint) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextRun((long)nativeCanvas, (String)text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (float)x, (float)y, (boolean)isRtl, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nDrawTextRun(long nativeCanvas, char[] text, int start, int count, int contextStart, int contextCount, float x, float y, boolean isRtl, long nativePaint, long nativeTypefaceOrPrecomputedText) {
        ShadowNativeTypeface.ensureInitialized();
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            BaseCanvasNatives.nDrawTextRun((long)nativeCanvas, (char[])text, (int)start, (int)count, (int)contextStart, (int)contextCount, (float)x, (float)y, (boolean)isRtl, (long)nativePaint, (long)nativeTypefaceOrPrecomputedText);
        } else {
            BaseCanvasNatives.nDrawTextRunTypeface((long)nativeCanvas, (char[])text, (int)start, (int)count, (int)contextStart, (int)contextCount, (float)x, (float)y, (boolean)isRtl, (long)nativePaint, (long)nativeTypefaceOrPrecomputedText);
        }
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nDrawTextRun(long nativeCanvas, String text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, long nativePaint, long nativeTypeface) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextRun((long)nativeCanvas, (String)text, (int)start, (int)end, (int)contextStart, (int)contextEnd, (float)x, (float)y, (boolean)isRtl, (long)nativePaint, (long)nativeTypeface);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nDrawTextOnPath(long nativeCanvas, char[] text, int index, int count, long nativePath, float hOffset, float vOffset, int bidiFlags, long nativePaint) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextOnPath((long)nativeCanvas, (char[])text, (int)index, (int)count, (long)nativePath, (float)hOffset, (float)vOffset, (int)bidiFlags, (long)nativePaint);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static void nDrawTextOnPath(long nativeCanvas, String text, long nativePath, float hOffset, float vOffset, int flags, long nativePaint) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextOnPath((long)nativeCanvas, (String)text, (long)nativePath, (float)hOffset, (float)vOffset, (int)flags, (long)nativePaint);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nDrawTextOnPath(long nativeCanvas, char[] text, int index, int count, long nativePath, float hOffset, float vOffset, int bidiFlags, long nativePaint, long nativeTypeface) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextOnPath((long)nativeCanvas, (char[])text, (int)index, (int)count, (long)nativePath, (float)hOffset, (float)vOffset, (int)bidiFlags, (long)nativePaint, (long)nativeTypeface);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nDrawTextOnPath(long nativeCanvas, String text, long nativePath, float hOffset, float vOffset, int flags, long nativePaint, long nativeTypeface) {
        ShadowNativeTypeface.ensureInitialized();
        BaseCanvasNatives.nDrawTextOnPath((long)nativeCanvas, (String)text, (long)nativePath, (float)hOffset, (float)vOffset, (int)flags, (long)nativePaint, (long)nativeTypeface);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static void nPunchHole(long renderer, float left, float top, float right, float bottom, float rx, float ry) {
        BaseCanvasNatives.nPunchHole((long)renderer, (float)left, (float)top, (float)right, (float)bottom, (float)rx, (float)ry);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static void nPunchHole(long renderer, float left, float top, float right, float bottom, float rx, float ry, float alpha) {
        ShadowNativeBaseCanvas.nPunchHole(renderer, left, top, right, bottom, rx, ry);
    }

    long getNativeCanvas() {
        return ((BaseCanvasReflector)Reflector.reflector(BaseCanvasReflector.class, (Object)this.realBaseCanvas)).getNativeCanvas();
    }

    @Override
    public void appendDescription(String s) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getPathPaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getCirclePaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getArcPaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public boolean hasDrawnPath() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public boolean hasDrawnCircle() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public Paint getDrawnPathPaint(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public Path getDrawnPath(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.CirclePaintHistoryEvent getDrawnCircle(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.ArcPaintHistoryEvent getDrawnArc(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public void resetCanvasHistory() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public Paint getDrawnPaint() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public void setHeight(int height) {
        throw new UnsupportedOperationException("setHeight is not supported in native Canvas");
    }

    @Override
    public void setWidth(int width) {
        throw new UnsupportedOperationException("setWidth is not supported in native Canvas");
    }

    @Override
    public ShadowCanvas.TextHistoryEvent getDrawnTextEvent(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getTextHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.RectPaintHistoryEvent getDrawnRect(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.RectPaintHistoryEvent getLastDrawnRect() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getRectPaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.RoundRectPaintHistoryEvent getDrawnRoundRect(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.RoundRectPaintHistoryEvent getLastDrawnRoundRect() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getRoundRectPaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.LinePaintHistoryEvent getDrawnLine(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getLinePaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public int getOvalPaintHistoryCount() {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @Override
    public ShadowCanvas.OvalPaintHistoryEvent getDrawnOval(int i) {
        throw new UnsupportedOperationException("Legacy ShadowCanvas description APIs are not supported");
    }

    @ForType(value=BaseCanvas.class)
    static interface BaseCanvasReflector {
        @Accessor(value="mNativeCanvasWrapper")
        public long getNativeCanvas();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(null, ShadowNativeBaseCanvas.class);
        }
    }
}

