/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.ApkAssets;
import android.content.res.loader.AssetsProvider;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApkAssets;
import org.robolectric.shadows.ShadowArscApkAssets9;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ApkAssets.class, minSdk=35, callNativeMethodsByDefault=true, shadowPicker=ShadowApkAssets.Picker.class, isInAndroidSdk=false)
public class ShadowNativeApkAssets
extends ShadowApkAssets {
    private static final Map<String, Long> cachedApkAssetsPtrs = new HashMap<String, Long>();

    @Implementation
    protected static long nativeLoad(int format, String path, int flags, AssetsProvider asset) {
        boolean system = false;
        if (path.equals(ShadowArscApkAssets9.FRAMEWORK_APK_PATH)) {
            path = RuntimeEnvironment.getAndroidFrameworkJarPath().toString();
            system = true;
        }
        if (cachedApkAssetsPtrs.containsKey(path)) {
            return cachedApkAssetsPtrs.get(path);
        }
        String adjustedPath = path;
        return (Long)PerfStatsCollector.getInstance().measure("load native " + (system ? "framework" : "app") + " resources", () -> {
            long ptr = (Long)ReflectionHelpers.callStaticMethod(ApkAssets.class, (String)Shadow.directNativeMethodName((String)ApkAssets.class.getName(), (String)"nativeLoad"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)format), ReflectionHelpers.ClassParameter.from(String.class, (Object)adjustedPath), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(AssetsProvider.class, (Object)asset)});
            if (ptr > 0L) {
                cachedApkAssetsPtrs.put(adjustedPath, ptr);
            }
            return ptr;
        });
    }

    @Implementation
    protected static void nativeDestroy(long ptr) {
    }
}

