/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.BluetoothConnectionManager;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=BluetoothGatt.class)
public class ShadowBluetoothGatt {
    private static final String NULL_CALLBACK_MSG = "BluetoothGattCallback can not be null.";
    private BluetoothGattCallback bluetoothGattCallback;
    private int connectionPriority = 0;
    private boolean isConnected = false;
    private boolean isClosed = false;
    private byte[] writtenBytes;
    private byte[] readBytes;
    private final Set<BluetoothGattService> discoverableServices = new HashSet<BluetoothGattService>();
    private final ArrayList<BluetoothGattService> services = new ArrayList();
    private final Set<BluetoothGattCharacteristic> characteristicNotificationEnableSet = new HashSet<BluetoothGattCharacteristic>();
    @RealObject
    private BluetoothGatt realBluetoothGatt;
    @ReflectorObject
    protected BluetoothGattReflector bluetoothGattReflector;

    @SuppressLint(value={"PrivateApi"})
    public static BluetoothGatt newInstance(BluetoothDevice device) {
        try {
            Class<?> iBluetoothGattClass = Shadow.class.getClassLoader().loadClass("android.bluetooth.IBluetoothGatt");
            int apiLevel = RuntimeEnvironment.getApiLevel();
            BluetoothGatt bluetoothGatt = apiLevel > 30 ? (BluetoothGatt)Shadow.newInstance(BluetoothGatt.class, (Class[])new Class[]{iBluetoothGattClass, BluetoothDevice.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Class.forName("android.content.AttributionSource")}, (Object[])new Object[]{null, device, 0, false, 0, null}) : (apiLevel >= 27 ? (BluetoothGatt)Shadow.newInstance(BluetoothGatt.class, (Class[])new Class[]{iBluetoothGattClass, BluetoothDevice.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE}, (Object[])new Object[]{null, device, 0, false, 0}) : (apiLevel >= 26 ? (BluetoothGatt)Shadow.newInstance(BluetoothGatt.class, (Class[])new Class[]{iBluetoothGattClass, BluetoothDevice.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{null, device, 0, 0}) : (BluetoothGatt)Shadow.newInstance(BluetoothGatt.class, (Class[])new Class[]{Context.class, iBluetoothGattClass, BluetoothDevice.class, Integer.TYPE}, (Object[])new Object[]{RuntimeEnvironment.getApplication(), null, device, 0})));
            PerfStatsCollector.getInstance().incrementCount("constructShadowBluetoothGatt");
            return bluetoothGatt;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected boolean connect() {
        if (this.getGattCallback() != null) {
            this.isConnected = true;
            this.getGattCallback().onConnectionStateChange(this.realBluetoothGatt, 0, 2);
            return true;
        }
        return false;
    }

    @Implementation
    protected void disconnect() {
        this.bluetoothGattReflector.disconnect();
        if (this.isCallbackAppropriate()) {
            this.getGattCallback().onConnectionStateChange(this.realBluetoothGatt, 0, 0);
        }
        this.isConnected = false;
    }

    @Implementation
    protected void close() {
        this.bluetoothGattReflector.close();
        this.isClosed = true;
        this.isConnected = false;
    }

    @Implementation(minSdk=26)
    protected boolean requestConnectionPriority(int priority) {
        if (priority == 1 || priority == 0 || priority == 2) {
            this.connectionPriority = priority;
            return true;
        }
        throw new IllegalArgumentException("connection priority not within valid range");
    }

    @Implementation(minSdk=26)
    protected boolean requestMtu(int mtu) {
        if (this.bluetoothGattCallback == null) {
            return false;
        }
        this.bluetoothGattCallback.onMtuChanged(this.realBluetoothGatt, mtu, 0);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean discoverServices() {
        this.services.clear();
        if (!this.discoverableServices.isEmpty()) {
            this.services.addAll(this.discoverableServices);
            if (this.getGattCallback() != null) {
                this.getGattCallback().onServicesDiscovered(this.realBluetoothGatt, 0);
                return true;
            }
        }
        return false;
    }

    @Implementation(minSdk=26)
    protected List<BluetoothGattService> getServices() {
        return new ArrayList<BluetoothGattService>(this.services);
    }

    @Implementation(minSdk=26)
    @Nullable
    protected BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.services) {
            if (!service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    @Implementation(minSdk=26)
    protected boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enable) {
        return this.characteristicNotificationEnableSet.contains(characteristic);
    }

    @Implementation(minSdk=26)
    protected boolean writeDescriptor(BluetoothGattDescriptor descriptor) {
        if (this.getGattCallback() == null) {
            throw new IllegalStateException(NULL_CALLBACK_MSG);
        }
        if (descriptor.getCharacteristic() == null || descriptor.getCharacteristic().getService() == null) {
            return false;
        }
        this.writtenBytes = descriptor.getValue();
        this.bluetoothGattCallback.onDescriptorWrite(this.realBluetoothGatt, descriptor, 0);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        return this.writeIncomingCharacteristic(characteristic);
    }

    @Implementation(minSdk=33)
    protected int writeCharacteristic(BluetoothGattCharacteristic characteristic, byte[] value, int writeType) {
        characteristic.setValue(value);
        boolean writeSuccessCode = this.writeIncomingCharacteristic(characteristic);
        if (writeSuccessCode) {
            return 0;
        }
        return 257;
    }

    public boolean writeIncomingCharacteristic(BluetoothGattCharacteristic characteristic) {
        if (this.getGattCallback() == null) {
            throw new IllegalStateException(NULL_CALLBACK_MSG);
        }
        if (characteristic.getService() == null || (characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        this.writtenBytes = characteristic.getValue();
        this.bluetoothGattCallback.onCharacteristicWrite(this.realBluetoothGatt, characteristic, 0);
        return true;
    }

    public boolean readIncomingCharacteristic(BluetoothGattCharacteristic characteristic) {
        if (this.getGattCallback() == null) {
            throw new IllegalStateException(NULL_CALLBACK_MSG);
        }
        if ((characteristic.getProperties() & 2) == 0 || characteristic.getService() == null) {
            return false;
        }
        this.readBytes = characteristic.getValue();
        this.bluetoothGattCallback.onCharacteristicRead(this.realBluetoothGatt, characteristic, 0);
        return true;
    }

    public void allowCharacteristicNotification(BluetoothGattCharacteristic characteristic) {
        this.characteristicNotificationEnableSet.add(characteristic);
    }

    public void disallowCharacteristicNotification(BluetoothGattCharacteristic characteristic) {
        this.characteristicNotificationEnableSet.remove(characteristic);
    }

    public void addDiscoverableService(BluetoothGattService service) {
        this.discoverableServices.add(service);
    }

    public void removeDiscoverableService(BluetoothGattService service) {
        this.discoverableServices.remove(service);
    }

    public BluetoothGattCallback getGattCallback() {
        return this.bluetoothGattCallback;
    }

    public void setGattCallback(BluetoothGattCallback bluetoothGattCallback) {
        this.bluetoothGattCallback = bluetoothGattCallback;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getConnectionPriority() {
        return this.connectionPriority;
    }

    public byte[] getLatestWrittenBytes() {
        return this.writtenBytes;
    }

    public byte[] getLatestReadBytes() {
        return this.readBytes;
    }

    public BluetoothConnectionManager getBluetoothConnectionManager() {
        return BluetoothConnectionManager.getInstance();
    }

    public void notifyConnection(String remoteAddress) {
        BluetoothConnectionManager.getInstance().registerGattClientConnection(remoteAddress);
        this.isConnected = true;
        if (this.isCallbackAppropriate()) {
            this.getGattCallback().onConnectionStateChange(this.realBluetoothGatt, 0, 2);
        }
    }

    public void notifyDisconnection(String remoteAddress) {
        BluetoothConnectionManager.getInstance().unregisterGattClientConnection(remoteAddress);
        if (this.isCallbackAppropriate()) {
            this.getGattCallback().onConnectionStateChange(this.realBluetoothGatt, 0, 0);
        }
        this.isConnected = false;
    }

    private boolean isCallbackAppropriate() {
        return this.getGattCallback() != null && this.isConnected;
    }

    @ForType(value=BluetoothGatt.class)
    private static interface BluetoothGattReflector {
        @Direct
        public void disconnect();

        @Direct
        public void close();
    }
}

