/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.ArrayMap;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AccessibilityManager.class)
public class ShadowAccessibilityManager {
    private static AccessibilityManager sInstance;
    private static final Object sInstanceSync;
    @RealObject
    AccessibilityManager realAccessibilityManager;
    private static final List<AccessibilityEvent> sentAccessibilityEvents;
    private static boolean enabled;
    private static List<AccessibilityServiceInfo> installedAccessibilityServiceList;
    private static List<AccessibilityServiceInfo> enabledAccessibilityServiceList;
    private static List<ServiceInfo> accessibilityServiceList;
    private static final HashMap<AccessibilityManager.AccessibilityStateChangeListener, Handler> onAccessibilityStateChangeListeners;
    private static boolean touchExplorationEnabled;
    private static boolean isAccessibilityButtonSupported;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = sInstanceSync;
        synchronized (object) {
            sInstance = null;
        }
        sentAccessibilityEvents.clear();
        enabled = false;
        installedAccessibilityServiceList.clear();
        enabledAccessibilityServiceList.clear();
        accessibilityServiceList.clear();
        onAccessibilityStateChangeListeners.clear();
        touchExplorationEnabled = false;
        isAccessibilityButtonSupported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation
    public static AccessibilityManager getInstance(Context context) throws Exception {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = ShadowAccessibilityManager.createInstance(context);
            }
        }
        return sInstance;
    }

    private static AccessibilityManager createInstance(Context context) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)Shadow.newInstance(AccessibilityManager.class, (Class[])new Class[]{Context.class, IAccessibilityManager.class, Integer.TYPE}, (Object[])new Object[]{context, ReflectionHelpers.createNullProxy(IAccessibilityManager.class), 0});
        ReflectionHelpers.setField((Object)accessibilityManager, (String)"mHandler", (Object)((Object)new MyHandler(context.getMainLooper(), accessibilityManager)));
        return accessibilityManager;
    }

    @Implementation
    protected boolean addAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        this.addAccessibilityStateChangeListener(listener, null);
        return true;
    }

    @Implementation(minSdk=26)
    protected void addAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener, Handler handler) {
        onAccessibilityStateChangeListeners.put(listener, handler);
    }

    @Implementation
    protected boolean removeAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        boolean wasRegistered = onAccessibilityStateChangeListeners.containsKey(listener);
        onAccessibilityStateChangeListeners.remove(listener);
        return wasRegistered;
    }

    @Implementation
    protected List<ServiceInfo> getAccessibilityServiceList() {
        return Collections.unmodifiableList(accessibilityServiceList);
    }

    public void setInteractiveUiTimeout(int interactiveUiTimeoutMillis) {
        ReflectionHelpers.setField((Object)this.realAccessibilityManager, (String)"mInteractiveUiTimeout", (Object)interactiveUiTimeoutMillis);
    }

    public void setNonInteractiveUiTimeout(int nonInteractiveUiTimeoutMillis) {
        ReflectionHelpers.setField((Object)this.realAccessibilityManager, (String)"mNonInteractiveUiTimeout", (Object)nonInteractiveUiTimeoutMillis);
    }

    public void setAccessibilityServiceList(List<ServiceInfo> accessibilityServiceList) {
        Preconditions.checkNotNull(accessibilityServiceList);
        ShadowAccessibilityManager.accessibilityServiceList = new ArrayList<ServiceInfo>(accessibilityServiceList);
    }

    @Nullable
    @Implementation
    protected List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        return Collections.unmodifiableList(enabledAccessibilityServiceList);
    }

    public void setEnabledAccessibilityServiceList(List<AccessibilityServiceInfo> enabledAccessibilityServiceList) {
        Preconditions.checkNotNull(enabledAccessibilityServiceList);
        ShadowAccessibilityManager.enabledAccessibilityServiceList = new ArrayList<AccessibilityServiceInfo>(enabledAccessibilityServiceList);
    }

    @Implementation
    protected List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        return Collections.unmodifiableList(installedAccessibilityServiceList);
    }

    public void setInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedAccessibilityServiceList) {
        Preconditions.checkNotNull(installedAccessibilityServiceList);
        ShadowAccessibilityManager.installedAccessibilityServiceList = new ArrayList<AccessibilityServiceInfo>(installedAccessibilityServiceList);
    }

    @Implementation
    protected void sendAccessibilityEvent(AccessibilityEvent event) {
        sentAccessibilityEvents.add(event);
        ((AccessibilityManagerReflector)Reflector.reflector(AccessibilityManagerReflector.class, (Object)this.realAccessibilityManager)).sendAccessibilityEvent(event);
    }

    public ImmutableList<AccessibilityEvent> getSentAccessibilityEvents() {
        return ImmutableList.copyOf(sentAccessibilityEvents);
    }

    @Implementation
    protected boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        ShadowAccessibilityManager.enabled = enabled;
        ReflectionHelpers.setField((Object)this.realAccessibilityManager, (String)"mIsEnabled", (Object)enabled);
        for (AccessibilityManager.AccessibilityStateChangeListener l : onAccessibilityStateChangeListeners.keySet()) {
            if (l == null) continue;
            l.onAccessibilityStateChanged(enabled);
        }
    }

    @Implementation
    protected boolean isTouchExplorationEnabled() {
        return touchExplorationEnabled;
    }

    public void setTouchExplorationEnabled(boolean touchExplorationEnabled) {
        ShadowAccessibilityManager.touchExplorationEnabled = touchExplorationEnabled;
        ArrayList<Object> listeners = new ArrayList();
        listeners = RuntimeEnvironment.getApiLevel() >= 26 ? new ArrayList(((AccessibilityManagerReflector)Reflector.reflector(AccessibilityManagerReflector.class, (Object)this.realAccessibilityManager)).getTouchExplorationStateChangeListeners().keySet()) : new ArrayList<AccessibilityManager.TouchExplorationStateChangeListener>(((AccessibilityManagerReflectorN)Reflector.reflector(AccessibilityManagerReflectorN.class, (Object)this.realAccessibilityManager)).getTouchExplorationStateChangeListeners());
        listeners.forEach(listener -> listener.onTouchExplorationStateChanged(touchExplorationEnabled));
    }

    @Implementation(minSdk=27)
    protected static boolean isAccessibilityButtonSupported() {
        return isAccessibilityButtonSupported;
    }

    @HiddenApi
    @Implementation(minSdk=26)
    protected void performAccessibilityShortcut() {
        this.setEnabled(true);
        this.setTouchExplorationEnabled(true);
    }

    public static void setAccessibilityButtonSupported(boolean supported) {
        isAccessibilityButtonSupported = supported;
    }

    static {
        sInstanceSync = new Object();
        sentAccessibilityEvents = new ArrayList<AccessibilityEvent>();
        installedAccessibilityServiceList = new ArrayList<AccessibilityServiceInfo>();
        enabledAccessibilityServiceList = new ArrayList<AccessibilityServiceInfo>();
        accessibilityServiceList = new ArrayList<ServiceInfo>();
        onAccessibilityStateChangeListeners = new HashMap();
        isAccessibilityButtonSupported = true;
    }

    static class MyHandler
    extends Handler {
        private static final int DO_SET_STATE = 10;
        private final AccessibilityManager accessibilityManager;

        MyHandler(Looper mainLooper, AccessibilityManager accessibilityManager) {
            super(mainLooper);
            this.accessibilityManager = accessibilityManager;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 10: {
                    ReflectionHelpers.callInstanceMethod((Object)this.accessibilityManager, (String)"setState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)message.arg1)});
                    return;
                }
            }
            Log.w((String)"AccessibilityManager", (String)("Unknown message type: " + message.what));
        }
    }

    @ForType(value=AccessibilityManager.class)
    static interface AccessibilityManagerReflector {
        @Direct
        public void sendAccessibilityEvent(AccessibilityEvent var1);

        @Accessor(value="mTouchExplorationStateChangeListeners")
        public ArrayMap<AccessibilityManager.TouchExplorationStateChangeListener, Handler> getTouchExplorationStateChangeListeners();
    }

    @ForType(value=AccessibilityManager.class)
    static interface AccessibilityManagerReflectorN {
        @Accessor(value="mTouchExplorationStateChangeListeners")
        public CopyOnWriteArrayList<AccessibilityManager.TouchExplorationStateChangeListener> getTouchExplorationStateChangeListeners();
    }
}

